/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.redshift.model.DescribeDefaultClusterParametersRequest;

public class DescribeDefaultClusterParametersRequestMarshaller
implements Marshaller<Request<DescribeDefaultClusterParametersRequest>, DescribeDefaultClusterParametersRequest> {
    public Request<DescribeDefaultClusterParametersRequest> marshall(DescribeDefaultClusterParametersRequest describeDefaultClusterParametersRequest) {
        if (describeDefaultClusterParametersRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)describeDefaultClusterParametersRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeDefaultClusterParameters");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeDefaultClusterParametersRequest.parameterGroupFamily() != null) {
            request.addParameter("ParameterGroupFamily", StringConversion.fromString((String)describeDefaultClusterParametersRequest.parameterGroupFamily()));
        }
        if (describeDefaultClusterParametersRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringConversion.fromInteger((Integer)describeDefaultClusterParametersRequest.maxRecords()));
        }
        if (describeDefaultClusterParametersRequest.marker() != null) {
            request.addParameter("Marker", StringConversion.fromString((String)describeDefaultClusterParametersRequest.marker()));
        }
        return request;
    }
}

