/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesRequest;
import software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesResponse;
import software.amazon.awssdk.services.redshift.model.HsmClientCertificate;

public class DescribeHsmClientCertificatesIterable
implements SdkIterable<DescribeHsmClientCertificatesResponse> {
    private final RedshiftClient client;
    private final DescribeHsmClientCertificatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeHsmClientCertificatesIterable(RedshiftClient client, DescribeHsmClientCertificatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeHsmClientCertificatesResponseFetcher();
    }

    public Iterator<DescribeHsmClientCertificatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<HsmClientCertificate> hsmClientCertificates() {
        Function<DescribeHsmClientCertificatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.hsmClientCertificates() != null) {
                return response.hsmClientCertificates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final DescribeHsmClientCertificatesIterable resume(DescribeHsmClientCertificatesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeHsmClientCertificatesIterable(this.client, (DescribeHsmClientCertificatesRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeHsmClientCertificatesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeHsmClientCertificatesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeHsmClientCertificatesResponseFetcher
    implements SyncPageFetcher<DescribeHsmClientCertificatesResponse> {
        private DescribeHsmClientCertificatesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeHsmClientCertificatesResponse previousPage) {
            return previousPage.marker() != null && !SdkAutoConstructList.class.isInstance(previousPage.marker()) && !SdkAutoConstructMap.class.isInstance(previousPage.marker());
        }

        public DescribeHsmClientCertificatesResponse nextPage(DescribeHsmClientCertificatesResponse previousPage) {
            if (previousPage == null) {
                return DescribeHsmClientCertificatesIterable.this.client.describeHsmClientCertificates(DescribeHsmClientCertificatesIterable.this.firstRequest);
            }
            return DescribeHsmClientCertificatesIterable.this.client.describeHsmClientCertificates((DescribeHsmClientCertificatesRequest)((Object)DescribeHsmClientCertificatesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

