/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.IamRoleArnListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyClusterIamRolesRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, ModifyClusterIamRolesRequest> {
    private final String clusterIdentifier;
    private final List<String> addIamRoles;
    private final List<String> removeIamRoles;

    private ModifyClusterIamRolesRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.addIamRoles = builder.addIamRoles;
        this.removeIamRoles = builder.removeIamRoles;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public List<String> addIamRoles() {
        return this.addIamRoles;
    }

    public List<String> removeIamRoles() {
        return this.removeIamRoles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.addIamRoles());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeIamRoles());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyClusterIamRolesRequest)) {
            return false;
        }
        ModifyClusterIamRolesRequest other = (ModifyClusterIamRolesRequest)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.addIamRoles(), other.addIamRoles()) && Objects.equals(this.removeIamRoles(), other.removeIamRoles());
    }

    public String toString() {
        return ToString.builder((String)"ModifyClusterIamRolesRequest").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("AddIamRoles", this.addIamRoles()).add("RemoveIamRoles", this.removeIamRoles()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "AddIamRoles": {
                return Optional.ofNullable(clazz.cast(this.addIamRoles()));
            }
            case "RemoveIamRoles": {
                return Optional.ofNullable(clazz.cast(this.removeIamRoles()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private List<String> addIamRoles = DefaultSdkAutoConstructList.getInstance();
        private List<String> removeIamRoles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyClusterIamRolesRequest model) {
            super(model);
            this.clusterIdentifier(model.clusterIdentifier);
            this.addIamRoles(model.addIamRoles);
            this.removeIamRoles(model.removeIamRoles);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final Collection<String> getAddIamRoles() {
            return this.addIamRoles;
        }

        @Override
        public final Builder addIamRoles(Collection<String> addIamRoles) {
            this.addIamRoles = IamRoleArnListCopier.copy(addIamRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addIamRoles(String ... addIamRoles) {
            this.addIamRoles(Arrays.asList(addIamRoles));
            return this;
        }

        public final void setAddIamRoles(Collection<String> addIamRoles) {
            this.addIamRoles = IamRoleArnListCopier.copy(addIamRoles);
        }

        public final Collection<String> getRemoveIamRoles() {
            return this.removeIamRoles;
        }

        @Override
        public final Builder removeIamRoles(Collection<String> removeIamRoles) {
            this.removeIamRoles = IamRoleArnListCopier.copy(removeIamRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeIamRoles(String ... removeIamRoles) {
            this.removeIamRoles(Arrays.asList(removeIamRoles));
            return this;
        }

        public final void setRemoveIamRoles(Collection<String> removeIamRoles) {
            this.removeIamRoles = IamRoleArnListCopier.copy(removeIamRoles);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyClusterIamRolesRequest build() {
            return new ModifyClusterIamRolesRequest(this);
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    CopyableBuilder<Builder, ModifyClusterIamRolesRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder addIamRoles(Collection<String> var1);

        public Builder addIamRoles(String ... var1);

        public Builder removeIamRoles(Collection<String> var1);

        public Builder removeIamRoles(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

