/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.ClusterIamRole;
import software.amazon.awssdk.services.redshift.model.ClusterIamRoleListCopier;
import software.amazon.awssdk.services.redshift.model.ClusterNode;
import software.amazon.awssdk.services.redshift.model.ClusterNodesListCopier;
import software.amazon.awssdk.services.redshift.model.ClusterParameterGroupStatus;
import software.amazon.awssdk.services.redshift.model.ClusterParameterGroupStatusListCopier;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupMembership;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupMembershipListCopier;
import software.amazon.awssdk.services.redshift.model.ClusterSnapshotCopyStatus;
import software.amazon.awssdk.services.redshift.model.ElasticIpStatus;
import software.amazon.awssdk.services.redshift.model.Endpoint;
import software.amazon.awssdk.services.redshift.model.HsmStatus;
import software.amazon.awssdk.services.redshift.model.PendingModifiedValues;
import software.amazon.awssdk.services.redshift.model.RestoreStatus;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.services.redshift.model.VpcSecurityGroupMembership;
import software.amazon.awssdk.services.redshift.model.VpcSecurityGroupMembershipListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Cluster
implements ToCopyableBuilder<Builder, Cluster> {
    private final String clusterIdentifier;
    private final String nodeType;
    private final String clusterStatus;
    private final String modifyStatus;
    private final String masterUsername;
    private final String dbName;
    private final Endpoint endpoint;
    private final Instant clusterCreateTime;
    private final Integer automatedSnapshotRetentionPeriod;
    private final List<ClusterSecurityGroupMembership> clusterSecurityGroups;
    private final List<VpcSecurityGroupMembership> vpcSecurityGroups;
    private final List<ClusterParameterGroupStatus> clusterParameterGroups;
    private final String clusterSubnetGroupName;
    private final String vpcId;
    private final String availabilityZone;
    private final String preferredMaintenanceWindow;
    private final PendingModifiedValues pendingModifiedValues;
    private final String clusterVersion;
    private final Boolean allowVersionUpgrade;
    private final Integer numberOfNodes;
    private final Boolean publiclyAccessible;
    private final Boolean encrypted;
    private final RestoreStatus restoreStatus;
    private final HsmStatus hsmStatus;
    private final ClusterSnapshotCopyStatus clusterSnapshotCopyStatus;
    private final String clusterPublicKey;
    private final List<ClusterNode> clusterNodes;
    private final ElasticIpStatus elasticIpStatus;
    private final String clusterRevisionNumber;
    private final List<Tag> tags;
    private final String kmsKeyId;
    private final Boolean enhancedVpcRouting;
    private final List<ClusterIamRole> iamRoles;

    private Cluster(BuilderImpl builder) {
        this.clusterIdentifier = builder.clusterIdentifier;
        this.nodeType = builder.nodeType;
        this.clusterStatus = builder.clusterStatus;
        this.modifyStatus = builder.modifyStatus;
        this.masterUsername = builder.masterUsername;
        this.dbName = builder.dbName;
        this.endpoint = builder.endpoint;
        this.clusterCreateTime = builder.clusterCreateTime;
        this.automatedSnapshotRetentionPeriod = builder.automatedSnapshotRetentionPeriod;
        this.clusterSecurityGroups = builder.clusterSecurityGroups;
        this.vpcSecurityGroups = builder.vpcSecurityGroups;
        this.clusterParameterGroups = builder.clusterParameterGroups;
        this.clusterSubnetGroupName = builder.clusterSubnetGroupName;
        this.vpcId = builder.vpcId;
        this.availabilityZone = builder.availabilityZone;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.pendingModifiedValues = builder.pendingModifiedValues;
        this.clusterVersion = builder.clusterVersion;
        this.allowVersionUpgrade = builder.allowVersionUpgrade;
        this.numberOfNodes = builder.numberOfNodes;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.encrypted = builder.encrypted;
        this.restoreStatus = builder.restoreStatus;
        this.hsmStatus = builder.hsmStatus;
        this.clusterSnapshotCopyStatus = builder.clusterSnapshotCopyStatus;
        this.clusterPublicKey = builder.clusterPublicKey;
        this.clusterNodes = builder.clusterNodes;
        this.elasticIpStatus = builder.elasticIpStatus;
        this.clusterRevisionNumber = builder.clusterRevisionNumber;
        this.tags = builder.tags;
        this.kmsKeyId = builder.kmsKeyId;
        this.enhancedVpcRouting = builder.enhancedVpcRouting;
        this.iamRoles = builder.iamRoles;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public String nodeType() {
        return this.nodeType;
    }

    public String clusterStatus() {
        return this.clusterStatus;
    }

    public String modifyStatus() {
        return this.modifyStatus;
    }

    public String masterUsername() {
        return this.masterUsername;
    }

    public String dbName() {
        return this.dbName;
    }

    public Endpoint endpoint() {
        return this.endpoint;
    }

    public Instant clusterCreateTime() {
        return this.clusterCreateTime;
    }

    public Integer automatedSnapshotRetentionPeriod() {
        return this.automatedSnapshotRetentionPeriod;
    }

    public List<ClusterSecurityGroupMembership> clusterSecurityGroups() {
        return this.clusterSecurityGroups;
    }

    public List<VpcSecurityGroupMembership> vpcSecurityGroups() {
        return this.vpcSecurityGroups;
    }

    public List<ClusterParameterGroupStatus> clusterParameterGroups() {
        return this.clusterParameterGroups;
    }

    public String clusterSubnetGroupName() {
        return this.clusterSubnetGroupName;
    }

    public String vpcId() {
        return this.vpcId;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public PendingModifiedValues pendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public String clusterVersion() {
        return this.clusterVersion;
    }

    public Boolean allowVersionUpgrade() {
        return this.allowVersionUpgrade;
    }

    public Integer numberOfNodes() {
        return this.numberOfNodes;
    }

    public Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public Boolean encrypted() {
        return this.encrypted;
    }

    public RestoreStatus restoreStatus() {
        return this.restoreStatus;
    }

    public HsmStatus hsmStatus() {
        return this.hsmStatus;
    }

    public ClusterSnapshotCopyStatus clusterSnapshotCopyStatus() {
        return this.clusterSnapshotCopyStatus;
    }

    public String clusterPublicKey() {
        return this.clusterPublicKey;
    }

    public List<ClusterNode> clusterNodes() {
        return this.clusterNodes;
    }

    public ElasticIpStatus elasticIpStatus() {
        return this.elasticIpStatus;
    }

    public String clusterRevisionNumber() {
        return this.clusterRevisionNumber;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Boolean enhancedVpcRouting() {
        return this.enhancedVpcRouting;
    }

    public List<ClusterIamRole> iamRoles() {
        return this.iamRoles;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifyStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbName());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.automatedSnapshotRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterSecurityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcSecurityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterParameterGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingModifiedValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterSnapshotCopyStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticIpStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterRevisionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedVpcRouting());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoles());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)obj;
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.nodeType(), other.nodeType()) && Objects.equals(this.clusterStatus(), other.clusterStatus()) && Objects.equals(this.modifyStatus(), other.modifyStatus()) && Objects.equals(this.masterUsername(), other.masterUsername()) && Objects.equals(this.dbName(), other.dbName()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.clusterCreateTime(), other.clusterCreateTime()) && Objects.equals(this.automatedSnapshotRetentionPeriod(), other.automatedSnapshotRetentionPeriod()) && Objects.equals(this.clusterSecurityGroups(), other.clusterSecurityGroups()) && Objects.equals(this.vpcSecurityGroups(), other.vpcSecurityGroups()) && Objects.equals(this.clusterParameterGroups(), other.clusterParameterGroups()) && Objects.equals(this.clusterSubnetGroupName(), other.clusterSubnetGroupName()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.pendingModifiedValues(), other.pendingModifiedValues()) && Objects.equals(this.clusterVersion(), other.clusterVersion()) && Objects.equals(this.allowVersionUpgrade(), other.allowVersionUpgrade()) && Objects.equals(this.numberOfNodes(), other.numberOfNodes()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.restoreStatus(), other.restoreStatus()) && Objects.equals(this.hsmStatus(), other.hsmStatus()) && Objects.equals(this.clusterSnapshotCopyStatus(), other.clusterSnapshotCopyStatus()) && Objects.equals(this.clusterPublicKey(), other.clusterPublicKey()) && Objects.equals(this.clusterNodes(), other.clusterNodes()) && Objects.equals(this.elasticIpStatus(), other.elasticIpStatus()) && Objects.equals(this.clusterRevisionNumber(), other.clusterRevisionNumber()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.enhancedVpcRouting(), other.enhancedVpcRouting()) && Objects.equals(this.iamRoles(), other.iamRoles());
    }

    public String toString() {
        return ToString.builder((String)"Cluster").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("NodeType", (Object)this.nodeType()).add("ClusterStatus", (Object)this.clusterStatus()).add("ModifyStatus", (Object)this.modifyStatus()).add("MasterUsername", (Object)this.masterUsername()).add("DBName", (Object)this.dbName()).add("Endpoint", (Object)this.endpoint()).add("ClusterCreateTime", (Object)this.clusterCreateTime()).add("AutomatedSnapshotRetentionPeriod", (Object)this.automatedSnapshotRetentionPeriod()).add("ClusterSecurityGroups", this.clusterSecurityGroups()).add("VpcSecurityGroups", this.vpcSecurityGroups()).add("ClusterParameterGroups", this.clusterParameterGroups()).add("ClusterSubnetGroupName", (Object)this.clusterSubnetGroupName()).add("VpcId", (Object)this.vpcId()).add("AvailabilityZone", (Object)this.availabilityZone()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("PendingModifiedValues", (Object)this.pendingModifiedValues()).add("ClusterVersion", (Object)this.clusterVersion()).add("AllowVersionUpgrade", (Object)this.allowVersionUpgrade()).add("NumberOfNodes", (Object)this.numberOfNodes()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("Encrypted", (Object)this.encrypted()).add("RestoreStatus", (Object)this.restoreStatus()).add("HsmStatus", (Object)this.hsmStatus()).add("ClusterSnapshotCopyStatus", (Object)this.clusterSnapshotCopyStatus()).add("ClusterPublicKey", (Object)this.clusterPublicKey()).add("ClusterNodes", this.clusterNodes()).add("ElasticIpStatus", (Object)this.elasticIpStatus()).add("ClusterRevisionNumber", (Object)this.clusterRevisionNumber()).add("Tags", this.tags()).add("KmsKeyId", (Object)this.kmsKeyId()).add("EnhancedVpcRouting", (Object)this.enhancedVpcRouting()).add("IamRoles", this.iamRoles()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "NodeType": {
                return Optional.ofNullable(clazz.cast(this.nodeType()));
            }
            case "ClusterStatus": {
                return Optional.ofNullable(clazz.cast(this.clusterStatus()));
            }
            case "ModifyStatus": {
                return Optional.ofNullable(clazz.cast(this.modifyStatus()));
            }
            case "MasterUsername": {
                return Optional.ofNullable(clazz.cast(this.masterUsername()));
            }
            case "DBName": {
                return Optional.ofNullable(clazz.cast(this.dbName()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "ClusterCreateTime": {
                return Optional.ofNullable(clazz.cast(this.clusterCreateTime()));
            }
            case "AutomatedSnapshotRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.automatedSnapshotRetentionPeriod()));
            }
            case "ClusterSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.clusterSecurityGroups()));
            }
            case "VpcSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroups()));
            }
            case "ClusterParameterGroups": {
                return Optional.ofNullable(clazz.cast(this.clusterParameterGroups()));
            }
            case "ClusterSubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.clusterSubnetGroupName()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "PendingModifiedValues": {
                return Optional.ofNullable(clazz.cast(this.pendingModifiedValues()));
            }
            case "ClusterVersion": {
                return Optional.ofNullable(clazz.cast(this.clusterVersion()));
            }
            case "AllowVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.allowVersionUpgrade()));
            }
            case "NumberOfNodes": {
                return Optional.ofNullable(clazz.cast(this.numberOfNodes()));
            }
            case "PubliclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "RestoreStatus": {
                return Optional.ofNullable(clazz.cast(this.restoreStatus()));
            }
            case "HsmStatus": {
                return Optional.ofNullable(clazz.cast(this.hsmStatus()));
            }
            case "ClusterSnapshotCopyStatus": {
                return Optional.ofNullable(clazz.cast(this.clusterSnapshotCopyStatus()));
            }
            case "ClusterPublicKey": {
                return Optional.ofNullable(clazz.cast(this.clusterPublicKey()));
            }
            case "ClusterNodes": {
                return Optional.ofNullable(clazz.cast(this.clusterNodes()));
            }
            case "ElasticIpStatus": {
                return Optional.ofNullable(clazz.cast(this.elasticIpStatus()));
            }
            case "ClusterRevisionNumber": {
                return Optional.ofNullable(clazz.cast(this.clusterRevisionNumber()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "EnhancedVpcRouting": {
                return Optional.ofNullable(clazz.cast(this.enhancedVpcRouting()));
            }
            case "IamRoles": {
                return Optional.ofNullable(clazz.cast(this.iamRoles()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String nodeType;
        private String clusterStatus;
        private String modifyStatus;
        private String masterUsername;
        private String dbName;
        private Endpoint endpoint;
        private Instant clusterCreateTime;
        private Integer automatedSnapshotRetentionPeriod;
        private List<ClusterSecurityGroupMembership> clusterSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private List<VpcSecurityGroupMembership> vpcSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private List<ClusterParameterGroupStatus> clusterParameterGroups = DefaultSdkAutoConstructList.getInstance();
        private String clusterSubnetGroupName;
        private String vpcId;
        private String availabilityZone;
        private String preferredMaintenanceWindow;
        private PendingModifiedValues pendingModifiedValues;
        private String clusterVersion;
        private Boolean allowVersionUpgrade;
        private Integer numberOfNodes;
        private Boolean publiclyAccessible;
        private Boolean encrypted;
        private RestoreStatus restoreStatus;
        private HsmStatus hsmStatus;
        private ClusterSnapshotCopyStatus clusterSnapshotCopyStatus;
        private String clusterPublicKey;
        private List<ClusterNode> clusterNodes = DefaultSdkAutoConstructList.getInstance();
        private ElasticIpStatus elasticIpStatus;
        private String clusterRevisionNumber;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String kmsKeyId;
        private Boolean enhancedVpcRouting;
        private List<ClusterIamRole> iamRoles = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Cluster model) {
            this.clusterIdentifier(model.clusterIdentifier);
            this.nodeType(model.nodeType);
            this.clusterStatus(model.clusterStatus);
            this.modifyStatus(model.modifyStatus);
            this.masterUsername(model.masterUsername);
            this.dbName(model.dbName);
            this.endpoint(model.endpoint);
            this.clusterCreateTime(model.clusterCreateTime);
            this.automatedSnapshotRetentionPeriod(model.automatedSnapshotRetentionPeriod);
            this.clusterSecurityGroups(model.clusterSecurityGroups);
            this.vpcSecurityGroups(model.vpcSecurityGroups);
            this.clusterParameterGroups(model.clusterParameterGroups);
            this.clusterSubnetGroupName(model.clusterSubnetGroupName);
            this.vpcId(model.vpcId);
            this.availabilityZone(model.availabilityZone);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.pendingModifiedValues(model.pendingModifiedValues);
            this.clusterVersion(model.clusterVersion);
            this.allowVersionUpgrade(model.allowVersionUpgrade);
            this.numberOfNodes(model.numberOfNodes);
            this.publiclyAccessible(model.publiclyAccessible);
            this.encrypted(model.encrypted);
            this.restoreStatus(model.restoreStatus);
            this.hsmStatus(model.hsmStatus);
            this.clusterSnapshotCopyStatus(model.clusterSnapshotCopyStatus);
            this.clusterPublicKey(model.clusterPublicKey);
            this.clusterNodes(model.clusterNodes);
            this.elasticIpStatus(model.elasticIpStatus);
            this.clusterRevisionNumber(model.clusterRevisionNumber);
            this.tags(model.tags);
            this.kmsKeyId(model.kmsKeyId);
            this.enhancedVpcRouting(model.enhancedVpcRouting);
            this.iamRoles(model.iamRoles);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public final String getClusterStatus() {
            return this.clusterStatus;
        }

        @Override
        public final Builder clusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
            return this;
        }

        public final void setClusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
        }

        public final String getModifyStatus() {
            return this.modifyStatus;
        }

        @Override
        public final Builder modifyStatus(String modifyStatus) {
            this.modifyStatus = modifyStatus;
            return this;
        }

        public final void setModifyStatus(String modifyStatus) {
            this.modifyStatus = modifyStatus;
        }

        public final String getMasterUsername() {
            return this.masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        public final String getDBName() {
            return this.dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final void setDBName(String dbName) {
            this.dbName = dbName;
        }

        public final Endpoint.Builder getEndpoint() {
            return this.endpoint != null ? this.endpoint.toBuilder() : null;
        }

        @Override
        public final Builder endpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final void setEndpoint(Endpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        public final Instant getClusterCreateTime() {
            return this.clusterCreateTime;
        }

        @Override
        public final Builder clusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
            return this;
        }

        public final void setClusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
        }

        public final Integer getAutomatedSnapshotRetentionPeriod() {
            return this.automatedSnapshotRetentionPeriod;
        }

        @Override
        public final Builder automatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
            return this;
        }

        public final void setAutomatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
        }

        public final Collection<ClusterSecurityGroupMembership.Builder> getClusterSecurityGroups() {
            return this.clusterSecurityGroups != null ? (Collection)this.clusterSecurityGroups.stream().map(ClusterSecurityGroupMembership::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder clusterSecurityGroups(Collection<ClusterSecurityGroupMembership> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupMembershipListCopier.copy(clusterSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSecurityGroups(ClusterSecurityGroupMembership ... clusterSecurityGroups) {
            this.clusterSecurityGroups(Arrays.asList(clusterSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSecurityGroups(Consumer<ClusterSecurityGroupMembership.Builder> ... clusterSecurityGroups) {
            this.clusterSecurityGroups(Stream.of(clusterSecurityGroups).map(c -> (ClusterSecurityGroupMembership)((ClusterSecurityGroupMembership.Builder)ClusterSecurityGroupMembership.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setClusterSecurityGroups(Collection<ClusterSecurityGroupMembership.BuilderImpl> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupMembershipListCopier.copyFromBuilder(clusterSecurityGroups);
        }

        public final Collection<VpcSecurityGroupMembership.Builder> getVpcSecurityGroups() {
            return this.vpcSecurityGroups != null ? (Collection)this.vpcSecurityGroups.stream().map(VpcSecurityGroupMembership::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copy(vpcSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(VpcSecurityGroupMembership ... vpcSecurityGroups) {
            this.vpcSecurityGroups(Arrays.asList(vpcSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(Consumer<VpcSecurityGroupMembership.Builder> ... vpcSecurityGroups) {
            this.vpcSecurityGroups(Stream.of(vpcSecurityGroups).map(c -> (VpcSecurityGroupMembership)((VpcSecurityGroupMembership.Builder)VpcSecurityGroupMembership.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVpcSecurityGroups(Collection<VpcSecurityGroupMembership.BuilderImpl> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copyFromBuilder(vpcSecurityGroups);
        }

        public final Collection<ClusterParameterGroupStatus.Builder> getClusterParameterGroups() {
            return this.clusterParameterGroups != null ? (Collection)this.clusterParameterGroups.stream().map(ClusterParameterGroupStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder clusterParameterGroups(Collection<ClusterParameterGroupStatus> clusterParameterGroups) {
            this.clusterParameterGroups = ClusterParameterGroupStatusListCopier.copy(clusterParameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterParameterGroups(ClusterParameterGroupStatus ... clusterParameterGroups) {
            this.clusterParameterGroups(Arrays.asList(clusterParameterGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterParameterGroups(Consumer<ClusterParameterGroupStatus.Builder> ... clusterParameterGroups) {
            this.clusterParameterGroups(Stream.of(clusterParameterGroups).map(c -> (ClusterParameterGroupStatus)((ClusterParameterGroupStatus.Builder)ClusterParameterGroupStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setClusterParameterGroups(Collection<ClusterParameterGroupStatus.BuilderImpl> clusterParameterGroups) {
            this.clusterParameterGroups = ClusterParameterGroupStatusListCopier.copyFromBuilder(clusterParameterGroups);
        }

        public final String getClusterSubnetGroupName() {
            return this.clusterSubnetGroupName;
        }

        @Override
        public final Builder clusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
            return this;
        }

        public final void setClusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        public final PendingModifiedValues.Builder getPendingModifiedValues() {
            return this.pendingModifiedValues != null ? this.pendingModifiedValues.toBuilder() : null;
        }

        @Override
        public final Builder pendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues;
            return this;
        }

        public final void setPendingModifiedValues(PendingModifiedValues.BuilderImpl pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues != null ? pendingModifiedValues.build() : null;
        }

        public final String getClusterVersion() {
            return this.clusterVersion;
        }

        @Override
        public final Builder clusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        public final void setClusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
        }

        public final Boolean getAllowVersionUpgrade() {
            return this.allowVersionUpgrade;
        }

        @Override
        public final Builder allowVersionUpgrade(Boolean allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
            return this;
        }

        public final void setAllowVersionUpgrade(Boolean allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
        }

        public final Integer getNumberOfNodes() {
            return this.numberOfNodes;
        }

        @Override
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final RestoreStatus.Builder getRestoreStatus() {
            return this.restoreStatus != null ? this.restoreStatus.toBuilder() : null;
        }

        @Override
        public final Builder restoreStatus(RestoreStatus restoreStatus) {
            this.restoreStatus = restoreStatus;
            return this;
        }

        public final void setRestoreStatus(RestoreStatus.BuilderImpl restoreStatus) {
            this.restoreStatus = restoreStatus != null ? restoreStatus.build() : null;
        }

        public final HsmStatus.Builder getHsmStatus() {
            return this.hsmStatus != null ? this.hsmStatus.toBuilder() : null;
        }

        @Override
        public final Builder hsmStatus(HsmStatus hsmStatus) {
            this.hsmStatus = hsmStatus;
            return this;
        }

        public final void setHsmStatus(HsmStatus.BuilderImpl hsmStatus) {
            this.hsmStatus = hsmStatus != null ? hsmStatus.build() : null;
        }

        public final ClusterSnapshotCopyStatus.Builder getClusterSnapshotCopyStatus() {
            return this.clusterSnapshotCopyStatus != null ? this.clusterSnapshotCopyStatus.toBuilder() : null;
        }

        @Override
        public final Builder clusterSnapshotCopyStatus(ClusterSnapshotCopyStatus clusterSnapshotCopyStatus) {
            this.clusterSnapshotCopyStatus = clusterSnapshotCopyStatus;
            return this;
        }

        public final void setClusterSnapshotCopyStatus(ClusterSnapshotCopyStatus.BuilderImpl clusterSnapshotCopyStatus) {
            this.clusterSnapshotCopyStatus = clusterSnapshotCopyStatus != null ? clusterSnapshotCopyStatus.build() : null;
        }

        public final String getClusterPublicKey() {
            return this.clusterPublicKey;
        }

        @Override
        public final Builder clusterPublicKey(String clusterPublicKey) {
            this.clusterPublicKey = clusterPublicKey;
            return this;
        }

        public final void setClusterPublicKey(String clusterPublicKey) {
            this.clusterPublicKey = clusterPublicKey;
        }

        public final Collection<ClusterNode.Builder> getClusterNodes() {
            return this.clusterNodes != null ? (Collection)this.clusterNodes.stream().map(ClusterNode::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder clusterNodes(Collection<ClusterNode> clusterNodes) {
            this.clusterNodes = ClusterNodesListCopier.copy(clusterNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterNodes(ClusterNode ... clusterNodes) {
            this.clusterNodes(Arrays.asList(clusterNodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterNodes(Consumer<ClusterNode.Builder> ... clusterNodes) {
            this.clusterNodes(Stream.of(clusterNodes).map(c -> (ClusterNode)((ClusterNode.Builder)ClusterNode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setClusterNodes(Collection<ClusterNode.BuilderImpl> clusterNodes) {
            this.clusterNodes = ClusterNodesListCopier.copyFromBuilder(clusterNodes);
        }

        public final ElasticIpStatus.Builder getElasticIpStatus() {
            return this.elasticIpStatus != null ? this.elasticIpStatus.toBuilder() : null;
        }

        @Override
        public final Builder elasticIpStatus(ElasticIpStatus elasticIpStatus) {
            this.elasticIpStatus = elasticIpStatus;
            return this;
        }

        public final void setElasticIpStatus(ElasticIpStatus.BuilderImpl elasticIpStatus) {
            this.elasticIpStatus = elasticIpStatus != null ? elasticIpStatus.build() : null;
        }

        public final String getClusterRevisionNumber() {
            return this.clusterRevisionNumber;
        }

        @Override
        public final Builder clusterRevisionNumber(String clusterRevisionNumber) {
            this.clusterRevisionNumber = clusterRevisionNumber;
            return this;
        }

        public final void setClusterRevisionNumber(String clusterRevisionNumber) {
            this.clusterRevisionNumber = clusterRevisionNumber;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Boolean getEnhancedVpcRouting() {
            return this.enhancedVpcRouting;
        }

        @Override
        public final Builder enhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        public final void setEnhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
        }

        public final Collection<ClusterIamRole.Builder> getIamRoles() {
            return this.iamRoles != null ? (Collection)this.iamRoles.stream().map(ClusterIamRole::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder iamRoles(Collection<ClusterIamRole> iamRoles) {
            this.iamRoles = ClusterIamRoleListCopier.copy(iamRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamRoles(ClusterIamRole ... iamRoles) {
            this.iamRoles(Arrays.asList(iamRoles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder iamRoles(Consumer<ClusterIamRole.Builder> ... iamRoles) {
            this.iamRoles(Stream.of(iamRoles).map(c -> (ClusterIamRole)((ClusterIamRole.Builder)ClusterIamRole.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setIamRoles(Collection<ClusterIamRole.BuilderImpl> iamRoles) {
            this.iamRoles = ClusterIamRoleListCopier.copyFromBuilder(iamRoles);
        }

        public Cluster build() {
            return new Cluster(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Cluster> {
        public Builder clusterIdentifier(String var1);

        public Builder nodeType(String var1);

        public Builder clusterStatus(String var1);

        public Builder modifyStatus(String var1);

        public Builder masterUsername(String var1);

        public Builder dbName(String var1);

        public Builder endpoint(Endpoint var1);

        default public Builder endpoint(Consumer<Endpoint.Builder> endpoint) {
            return this.endpoint((Endpoint)((Endpoint.Builder)Endpoint.builder().applyMutation(endpoint)).build());
        }

        public Builder clusterCreateTime(Instant var1);

        public Builder automatedSnapshotRetentionPeriod(Integer var1);

        public Builder clusterSecurityGroups(Collection<ClusterSecurityGroupMembership> var1);

        public Builder clusterSecurityGroups(ClusterSecurityGroupMembership ... var1);

        public Builder clusterSecurityGroups(Consumer<ClusterSecurityGroupMembership.Builder> ... var1);

        public Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> var1);

        public Builder vpcSecurityGroups(VpcSecurityGroupMembership ... var1);

        public Builder vpcSecurityGroups(Consumer<VpcSecurityGroupMembership.Builder> ... var1);

        public Builder clusterParameterGroups(Collection<ClusterParameterGroupStatus> var1);

        public Builder clusterParameterGroups(ClusterParameterGroupStatus ... var1);

        public Builder clusterParameterGroups(Consumer<ClusterParameterGroupStatus.Builder> ... var1);

        public Builder clusterSubnetGroupName(String var1);

        public Builder vpcId(String var1);

        public Builder availabilityZone(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder pendingModifiedValues(PendingModifiedValues var1);

        default public Builder pendingModifiedValues(Consumer<PendingModifiedValues.Builder> pendingModifiedValues) {
            return this.pendingModifiedValues((PendingModifiedValues)((PendingModifiedValues.Builder)PendingModifiedValues.builder().applyMutation(pendingModifiedValues)).build());
        }

        public Builder clusterVersion(String var1);

        public Builder allowVersionUpgrade(Boolean var1);

        public Builder numberOfNodes(Integer var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder encrypted(Boolean var1);

        public Builder restoreStatus(RestoreStatus var1);

        default public Builder restoreStatus(Consumer<RestoreStatus.Builder> restoreStatus) {
            return this.restoreStatus((RestoreStatus)((RestoreStatus.Builder)RestoreStatus.builder().applyMutation(restoreStatus)).build());
        }

        public Builder hsmStatus(HsmStatus var1);

        default public Builder hsmStatus(Consumer<HsmStatus.Builder> hsmStatus) {
            return this.hsmStatus((HsmStatus)((HsmStatus.Builder)HsmStatus.builder().applyMutation(hsmStatus)).build());
        }

        public Builder clusterSnapshotCopyStatus(ClusterSnapshotCopyStatus var1);

        default public Builder clusterSnapshotCopyStatus(Consumer<ClusterSnapshotCopyStatus.Builder> clusterSnapshotCopyStatus) {
            return this.clusterSnapshotCopyStatus((ClusterSnapshotCopyStatus)((ClusterSnapshotCopyStatus.Builder)ClusterSnapshotCopyStatus.builder().applyMutation(clusterSnapshotCopyStatus)).build());
        }

        public Builder clusterPublicKey(String var1);

        public Builder clusterNodes(Collection<ClusterNode> var1);

        public Builder clusterNodes(ClusterNode ... var1);

        public Builder clusterNodes(Consumer<ClusterNode.Builder> ... var1);

        public Builder elasticIpStatus(ElasticIpStatus var1);

        default public Builder elasticIpStatus(Consumer<ElasticIpStatus.Builder> elasticIpStatus) {
            return this.elasticIpStatus((ElasticIpStatus)((ElasticIpStatus.Builder)ElasticIpStatus.builder().applyMutation(elasticIpStatus)).build());
        }

        public Builder clusterRevisionNumber(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder kmsKeyId(String var1);

        public Builder enhancedVpcRouting(Boolean var1);

        public Builder iamRoles(Collection<ClusterIamRole> var1);

        public Builder iamRoles(ClusterIamRole ... var1);

        public Builder iamRoles(Consumer<ClusterIamRole.Builder> ... var1);
    }
}

