/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsResponse;
import software.amazon.awssdk.services.redshift.model.ReservedNodeOffering;

public class DescribeReservedNodeOfferingsIterable
implements SdkIterable<DescribeReservedNodeOfferingsResponse> {
    private final RedshiftClient client;
    private final DescribeReservedNodeOfferingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeReservedNodeOfferingsIterable(RedshiftClient client, DescribeReservedNodeOfferingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeReservedNodeOfferingsResponseFetcher();
    }

    public Iterator<DescribeReservedNodeOfferingsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<ReservedNodeOffering> reservedNodeOfferings() {
        Function<DescribeReservedNodeOfferingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedNodeOfferings() != null) {
                return response.reservedNodeOfferings().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeReservedNodeOfferingsIterable resume(DescribeReservedNodeOfferingsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeReservedNodeOfferingsIterable(this.client, (DescribeReservedNodeOfferingsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeReservedNodeOfferingsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeReservedNodeOfferingsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeReservedNodeOfferingsResponseFetcher
    implements SyncPageFetcher<DescribeReservedNodeOfferingsResponse> {
        private DescribeReservedNodeOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedNodeOfferingsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeReservedNodeOfferingsResponse nextPage(DescribeReservedNodeOfferingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedNodeOfferingsIterable.this.client.describeReservedNodeOfferings(DescribeReservedNodeOfferingsIterable.this.firstRequest);
            }
            return DescribeReservedNodeOfferingsIterable.this.client.describeReservedNodeOfferings((DescribeReservedNodeOfferingsRequest)((Object)DescribeReservedNodeOfferingsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

