/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.DescribeEventsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeEventsResponse;
import software.amazon.awssdk.services.redshift.model.Event;

public class DescribeEventsIterable
implements SdkIterable<DescribeEventsResponse> {
    private final RedshiftClient client;
    private final DescribeEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeEventsIterable(RedshiftClient client, DescribeEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeEventsResponseFetcher();
    }

    public Iterator<DescribeEventsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Event> events() {
        Function<DescribeEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeEventsIterable resume(DescribeEventsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeEventsIterable(this.client, (DescribeEventsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeEventsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeEventsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeEventsResponseFetcher
    implements SyncPageFetcher<DescribeEventsResponse> {
        private DescribeEventsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEventsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeEventsResponse nextPage(DescribeEventsResponse previousPage) {
            if (previousPage == null) {
                return DescribeEventsIterable.this.client.describeEvents(DescribeEventsIterable.this.firstRequest);
            }
            return DescribeEventsIterable.this.client.describeEvents((DescribeEventsRequest)((Object)DescribeEventsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

