/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.model.ClusterVersion;
import software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterVersionsResponse;

public class DescribeClusterVersionsPublisher
implements SdkPublisher<DescribeClusterVersionsResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeClusterVersionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeClusterVersionsPublisher(RedshiftAsyncClient client, DescribeClusterVersionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeClusterVersionsPublisher(RedshiftAsyncClient client, DescribeClusterVersionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeClusterVersionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeClusterVersionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<ClusterVersion> clusterVersions() {
        Function<DescribeClusterVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.clusterVersions() != null) {
                return response.clusterVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeClusterVersionsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeClusterVersionsPublisher resume(DescribeClusterVersionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeClusterVersionsPublisher(this.client, (DescribeClusterVersionsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeClusterVersionsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeClusterVersionsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeClusterVersionsResponseFetcher
    implements AsyncPageFetcher<DescribeClusterVersionsResponse> {
        private DescribeClusterVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClusterVersionsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public CompletableFuture<DescribeClusterVersionsResponse> nextPage(DescribeClusterVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeClusterVersionsPublisher.this.client.describeClusterVersions(DescribeClusterVersionsPublisher.this.firstRequest);
            }
            return DescribeClusterVersionsPublisher.this.client.describeClusterVersions((DescribeClusterVersionsRequest)((Object)DescribeClusterVersionsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

