/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroup;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSecurityGroupsResponse;

public class DescribeClusterSecurityGroupsPublisher
implements SdkPublisher<DescribeClusterSecurityGroupsResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeClusterSecurityGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeClusterSecurityGroupsPublisher(RedshiftAsyncClient client, DescribeClusterSecurityGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeClusterSecurityGroupsPublisher(RedshiftAsyncClient client, DescribeClusterSecurityGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeClusterSecurityGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeClusterSecurityGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<ClusterSecurityGroup> clusterSecurityGroups() {
        Function<DescribeClusterSecurityGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.clusterSecurityGroups() != null) {
                return response.clusterSecurityGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new DescribeClusterSecurityGroupsResponseFetcher(), getIterator, this.isLastPage);
    }

    public final DescribeClusterSecurityGroupsPublisher resume(DescribeClusterSecurityGroupsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeClusterSecurityGroupsPublisher(this.client, (DescribeClusterSecurityGroupsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeClusterSecurityGroupsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeClusterSecurityGroupsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeClusterSecurityGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeClusterSecurityGroupsResponse> {
        private DescribeClusterSecurityGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClusterSecurityGroupsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public CompletableFuture<DescribeClusterSecurityGroupsResponse> nextPage(DescribeClusterSecurityGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeClusterSecurityGroupsPublisher.this.client.describeClusterSecurityGroups(DescribeClusterSecurityGroupsPublisher.this.firstRequest);
            }
            return DescribeClusterSecurityGroupsPublisher.this.client.describeClusterSecurityGroups((DescribeClusterSecurityGroupsRequest)((Object)DescribeClusterSecurityGroupsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

