/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParametersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParametersResponse;
import software.amazon.awssdk.services.redshift.model.Parameter;

public class DescribeClusterParametersIterable
implements SdkIterable<DescribeClusterParametersResponse> {
    private final RedshiftClient client;
    private final DescribeClusterParametersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeClusterParametersIterable(RedshiftClient client, DescribeClusterParametersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeClusterParametersResponseFetcher();
    }

    public Iterator<DescribeClusterParametersResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Parameter> parameters() {
        Function<DescribeClusterParametersResponse, Iterator> getIterator = response -> {
            if (response != null && response.parameters() != null) {
                return response.parameters().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeClusterParametersIterable resume(DescribeClusterParametersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeClusterParametersIterable(this.client, (DescribeClusterParametersRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeClusterParametersIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeClusterParametersResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeClusterParametersResponseFetcher
    implements SyncPageFetcher<DescribeClusterParametersResponse> {
        private DescribeClusterParametersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClusterParametersResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeClusterParametersResponse nextPage(DescribeClusterParametersResponse previousPage) {
            if (previousPage == null) {
                return DescribeClusterParametersIterable.this.client.describeClusterParameters(DescribeClusterParametersIterable.this.firstRequest);
            }
            return DescribeClusterParametersIterable.this.client.describeClusterParameters((DescribeClusterParametersRequest)((Object)DescribeClusterParametersIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

