/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.services.redshift.model.TaggedResource;
import software.amazon.awssdk.services.redshift.model.TaggedResourceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeTagsResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeTagsResponse> {
    private final List<TaggedResource> taggedResources;
    private final String marker;

    private DescribeTagsResponse(BuilderImpl builder) {
        super(builder);
        this.taggedResources = builder.taggedResources;
        this.marker = builder.marker;
    }

    public List<TaggedResource> taggedResources() {
        return this.taggedResources;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.taggedResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTagsResponse)) {
            return false;
        }
        DescribeTagsResponse other = (DescribeTagsResponse)((Object)obj);
        return Objects.equals(this.taggedResources(), other.taggedResources()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"DescribeTagsResponse").add("TaggedResources", this.taggedResources()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TaggedResources": {
                return Optional.of(clazz.cast(this.taggedResources()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private List<TaggedResource> taggedResources;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTagsResponse model) {
            super(model);
            this.taggedResources(model.taggedResources);
            this.marker(model.marker);
        }

        public final Collection<TaggedResource.Builder> getTaggedResources() {
            return this.taggedResources != null ? (Collection)this.taggedResources.stream().map(TaggedResource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder taggedResources(Collection<TaggedResource> taggedResources) {
            this.taggedResources = TaggedResourceListCopier.copy(taggedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taggedResources(TaggedResource ... taggedResources) {
            this.taggedResources(Arrays.asList(taggedResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taggedResources(Consumer<TaggedResource.Builder> ... taggedResources) {
            this.taggedResources(Stream.of(taggedResources).map(c -> (TaggedResource)((TaggedResource.Builder)TaggedResource.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTaggedResources(Collection<TaggedResource.BuilderImpl> taggedResources) {
            this.taggedResources = TaggedResourceListCopier.copyFromBuilder(taggedResources);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeTagsResponse build() {
            return new DescribeTagsResponse(this);
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    CopyableBuilder<Builder, DescribeTagsResponse> {
        public Builder taggedResources(Collection<TaggedResource> var1);

        public Builder taggedResources(TaggedResource ... var1);

        public Builder taggedResources(Consumer<TaggedResource.Builder> ... var1);

        public Builder marker(String var1);
    }
}

