/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.redshift.model.ClusterSubnetGroup;
import software.amazon.awssdk.services.redshift.model.ClusterSubnetGroupsCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeClusterSubnetGroupsResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeClusterSubnetGroupsResponse> {
    private final String marker;
    private final List<ClusterSubnetGroup> clusterSubnetGroups;

    private DescribeClusterSubnetGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.clusterSubnetGroups = builder.clusterSubnetGroups;
    }

    public String marker() {
        return this.marker;
    }

    public List<ClusterSubnetGroup> clusterSubnetGroups() {
        return this.clusterSubnetGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterSubnetGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterSubnetGroupsResponse)) {
            return false;
        }
        DescribeClusterSubnetGroupsResponse other = (DescribeClusterSubnetGroupsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.clusterSubnetGroups(), other.clusterSubnetGroups());
    }

    public String toString() {
        return ToString.builder((String)"DescribeClusterSubnetGroupsResponse").add("Marker", (Object)this.marker()).add("ClusterSubnetGroups", this.clusterSubnetGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "ClusterSubnetGroups": {
                return Optional.of(clazz.cast(this.clusterSubnetGroups()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<ClusterSubnetGroup> clusterSubnetGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterSubnetGroupsResponse model) {
            super(model);
            this.marker(model.marker);
            this.clusterSubnetGroups(model.clusterSubnetGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ClusterSubnetGroup.Builder> getClusterSubnetGroups() {
            return this.clusterSubnetGroups != null ? (Collection)this.clusterSubnetGroups.stream().map(ClusterSubnetGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder clusterSubnetGroups(Collection<ClusterSubnetGroup> clusterSubnetGroups) {
            this.clusterSubnetGroups = ClusterSubnetGroupsCopier.copy(clusterSubnetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSubnetGroups(ClusterSubnetGroup ... clusterSubnetGroups) {
            this.clusterSubnetGroups(Arrays.asList(clusterSubnetGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSubnetGroups(Consumer<ClusterSubnetGroup.Builder> ... clusterSubnetGroups) {
            this.clusterSubnetGroups(Stream.of(clusterSubnetGroups).map(c -> (ClusterSubnetGroup)((ClusterSubnetGroup.Builder)ClusterSubnetGroup.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setClusterSubnetGroups(Collection<ClusterSubnetGroup.BuilderImpl> clusterSubnetGroups) {
            this.clusterSubnetGroups = ClusterSubnetGroupsCopier.copyFromBuilder(clusterSubnetGroups);
        }

        @Override
        public DescribeClusterSubnetGroupsResponse build() {
            return new DescribeClusterSubnetGroupsResponse(this);
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    CopyableBuilder<Builder, DescribeClusterSubnetGroupsResponse> {
        public Builder marker(String var1);

        public Builder clusterSubnetGroups(Collection<ClusterSubnetGroup> var1);

        public Builder clusterSubnetGroups(ClusterSubnetGroup ... var1);

        public Builder clusterSubnetGroups(Consumer<ClusterSubnetGroup.Builder> ... var1);
    }
}

