/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteClusterSnapshotRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, DeleteClusterSnapshotRequest> {
    private final String snapshotIdentifier;
    private final String snapshotClusterIdentifier;

    private DeleteClusterSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.snapshotClusterIdentifier = builder.snapshotClusterIdentifier;
    }

    public String snapshotIdentifier() {
        return this.snapshotIdentifier;
    }

    public String snapshotClusterIdentifier() {
        return this.snapshotClusterIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotClusterIdentifier());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteClusterSnapshotRequest)) {
            return false;
        }
        DeleteClusterSnapshotRequest other = (DeleteClusterSnapshotRequest)((Object)obj);
        return Objects.equals(this.snapshotIdentifier(), other.snapshotIdentifier()) && Objects.equals(this.snapshotClusterIdentifier(), other.snapshotClusterIdentifier());
    }

    public String toString() {
        return ToString.builder((String)"DeleteClusterSnapshotRequest").add("SnapshotIdentifier", (Object)this.snapshotIdentifier()).add("SnapshotClusterIdentifier", (Object)this.snapshotClusterIdentifier()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotIdentifier": {
                return Optional.of(clazz.cast(this.snapshotIdentifier()));
            }
            case "SnapshotClusterIdentifier": {
                return Optional.of(clazz.cast(this.snapshotClusterIdentifier()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String snapshotIdentifier;
        private String snapshotClusterIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteClusterSnapshotRequest model) {
            super(model);
            this.snapshotIdentifier(model.snapshotIdentifier);
            this.snapshotClusterIdentifier(model.snapshotClusterIdentifier);
        }

        public final String getSnapshotIdentifier() {
            return this.snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        public final String getSnapshotClusterIdentifier() {
            return this.snapshotClusterIdentifier;
        }

        @Override
        public final Builder snapshotClusterIdentifier(String snapshotClusterIdentifier) {
            this.snapshotClusterIdentifier = snapshotClusterIdentifier;
            return this;
        }

        public final void setSnapshotClusterIdentifier(String snapshotClusterIdentifier) {
            this.snapshotClusterIdentifier = snapshotClusterIdentifier;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DeleteClusterSnapshotRequest build() {
            return new DeleteClusterSnapshotRequest(this);
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    CopyableBuilder<Builder, DeleteClusterSnapshotRequest> {
        public Builder snapshotIdentifier(String var1);

        public Builder snapshotClusterIdentifier(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

