/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.redshift.model.RotateEncryptionKeyRequest;
import software.amazon.awssdk.util.StringUtils;

public class RotateEncryptionKeyRequestMarshaller
implements Marshaller<Request<RotateEncryptionKeyRequest>, RotateEncryptionKeyRequest> {
    public Request<RotateEncryptionKeyRequest> marshall(RotateEncryptionKeyRequest rotateEncryptionKeyRequest) {
        if (rotateEncryptionKeyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)rotateEncryptionKeyRequest, "RedshiftClient");
        request.addParameter("Action", "RotateEncryptionKey");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (rotateEncryptionKeyRequest.clusterIdentifier() != null) {
            request.addParameter("ClusterIdentifier", StringUtils.fromString((String)rotateEncryptionKeyRequest.clusterIdentifier()));
        }
        return request;
    }
}

