/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.redshift.model.AvailabilityZone;
import software.amazon.awssdk.services.redshift.model.OrderableClusterOption;
import software.amazon.awssdk.services.redshift.transform.AvailabilityZoneUnmarshaller;

public class OrderableClusterOptionUnmarshaller
implements Unmarshaller<OrderableClusterOption, StaxUnmarshallerContext> {
    private static OrderableClusterOptionUnmarshaller INSTANCE;

    public OrderableClusterOption unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        OrderableClusterOption.Builder orderableClusterOption = OrderableClusterOption.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("ClusterVersion", targetDepth)) {
                    orderableClusterOption.clusterVersion(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ClusterType", targetDepth)) {
                    orderableClusterOption.clusterType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("NodeType", targetDepth)) {
                    orderableClusterOption.nodeType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("AvailabilityZones", targetDepth)) {
                    orderableClusterOption.availabilityZones(new ArrayList<AvailabilityZone>());
                    continue;
                }
                if (!context.testExpression("AvailabilityZones/AvailabilityZone", targetDepth)) continue;
                orderableClusterOption.availabilityZones(AvailabilityZoneUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (OrderableClusterOption)orderableClusterOption.build();
    }

    public static OrderableClusterOptionUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new OrderableClusterOptionUnmarshaller();
        }
        return INSTANCE;
    }
}

