/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.redshift.model.ModifyEventSubscriptionRequest;
import software.amazon.awssdk.util.StringUtils;

public class ModifyEventSubscriptionRequestMarshaller
implements Marshaller<Request<ModifyEventSubscriptionRequest>, ModifyEventSubscriptionRequest> {
    public Request<ModifyEventSubscriptionRequest> marshall(ModifyEventSubscriptionRequest modifyEventSubscriptionRequest) {
        SdkInternalList eventCategoriesList;
        SdkInternalList sourceIdsList;
        if (modifyEventSubscriptionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyEventSubscriptionRequest, "RedshiftClient");
        request.addParameter("Action", "ModifyEventSubscription");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyEventSubscriptionRequest.subscriptionName() != null) {
            request.addParameter("SubscriptionName", StringUtils.fromString((String)modifyEventSubscriptionRequest.subscriptionName()));
        }
        if (modifyEventSubscriptionRequest.snsTopicArn() != null) {
            request.addParameter("SnsTopicArn", StringUtils.fromString((String)modifyEventSubscriptionRequest.snsTopicArn()));
        }
        if (modifyEventSubscriptionRequest.sourceType() != null) {
            request.addParameter("SourceType", StringUtils.fromString((String)modifyEventSubscriptionRequest.sourceType()));
        }
        if (!(sourceIdsList = (SdkInternalList)modifyEventSubscriptionRequest.sourceIds()).isEmpty() || !sourceIdsList.isAutoConstruct()) {
            int sourceIdsListIndex = 1;
            for (String sourceIdsListValue : sourceIdsList) {
                if (sourceIdsListValue != null) {
                    request.addParameter("SourceIds.SourceId." + sourceIdsListIndex, StringUtils.fromString((String)sourceIdsListValue));
                }
                ++sourceIdsListIndex;
            }
        }
        if (!(eventCategoriesList = (SdkInternalList)modifyEventSubscriptionRequest.eventCategories()).isEmpty() || !eventCategoriesList.isAutoConstruct()) {
            int eventCategoriesListIndex = 1;
            for (String eventCategoriesListValue : eventCategoriesList) {
                if (eventCategoriesListValue != null) {
                    request.addParameter("EventCategories.EventCategory." + eventCategoriesListIndex, StringUtils.fromString((String)eventCategoriesListValue));
                }
                ++eventCategoriesListIndex;
            }
        }
        if (modifyEventSubscriptionRequest.severity() != null) {
            request.addParameter("Severity", StringUtils.fromString((String)modifyEventSubscriptionRequest.severity()));
        }
        if (modifyEventSubscriptionRequest.enabled() != null) {
            request.addParameter("Enabled", StringUtils.fromBoolean((Boolean)modifyEventSubscriptionRequest.enabled()));
        }
        return request;
    }
}

