/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.redshift.model.EventSubscription;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.transform.TagUnmarshaller;

public class EventSubscriptionUnmarshaller
implements Unmarshaller<EventSubscription, StaxUnmarshallerContext> {
    private static EventSubscriptionUnmarshaller INSTANCE;

    public EventSubscription unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        EventSubscription.Builder eventSubscription = EventSubscription.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CustomerAwsId", targetDepth)) {
                    eventSubscription.customerAwsId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CustSubscriptionId", targetDepth)) {
                    eventSubscription.custSubscriptionId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SnsTopicArn", targetDepth)) {
                    eventSubscription.snsTopicArn(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Status", targetDepth)) {
                    eventSubscription.status(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SubscriptionCreationTime", targetDepth)) {
                    eventSubscription.subscriptionCreationTime(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SourceType", targetDepth)) {
                    eventSubscription.sourceType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SourceIdsList", targetDepth)) {
                    eventSubscription.sourceIdsList(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("SourceIdsList/SourceId", targetDepth)) {
                    eventSubscription.sourceIdsList(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EventCategoriesList", targetDepth)) {
                    eventSubscription.eventCategoriesList(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("EventCategoriesList/EventCategory", targetDepth)) {
                    eventSubscription.eventCategoriesList(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Severity", targetDepth)) {
                    eventSubscription.severity(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Enabled", targetDepth)) {
                    eventSubscription.enabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Tags", targetDepth)) {
                    eventSubscription.tags(new ArrayList<Tag>());
                    continue;
                }
                if (!context.testExpression("Tags/Tag", targetDepth)) continue;
                eventSubscription.tags(TagUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (EventSubscription)eventSubscription.build();
    }

    public static EventSubscriptionUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EventSubscriptionUnmarshaller();
        }
        return INSTANCE;
    }
}

