/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.redshift.model.EventInfoMap;

public class EventInfoMapUnmarshaller
implements Unmarshaller<EventInfoMap, StaxUnmarshallerContext> {
    private static EventInfoMapUnmarshaller INSTANCE;

    public EventInfoMap unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        EventInfoMap.Builder eventInfoMap = EventInfoMap.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("EventId", targetDepth)) {
                    eventInfoMap.eventId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EventCategories", targetDepth)) {
                    eventInfoMap.eventCategories(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("EventCategories/EventCategory", targetDepth)) {
                    eventInfoMap.eventCategories(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("EventDescription", targetDepth)) {
                    eventInfoMap.eventDescription(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Severity", targetDepth)) continue;
                eventInfoMap.severity(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (EventInfoMap)eventInfoMap.build();
    }

    public static EventInfoMapUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new EventInfoMapUnmarshaller();
        }
        return INSTANCE;
    }
}

