/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodesRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeReservedNodesRequestMarshaller
implements Marshaller<Request<DescribeReservedNodesRequest>, DescribeReservedNodesRequest> {
    public Request<DescribeReservedNodesRequest> marshall(DescribeReservedNodesRequest describeReservedNodesRequest) {
        if (describeReservedNodesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeReservedNodesRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeReservedNodes");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeReservedNodesRequest.reservedNodeId() != null) {
            request.addParameter("ReservedNodeId", StringUtils.fromString((String)describeReservedNodesRequest.reservedNodeId()));
        }
        if (describeReservedNodesRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeReservedNodesRequest.maxRecords()));
        }
        if (describeReservedNodesRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeReservedNodesRequest.marker()));
        }
        return request;
    }
}

