/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RestoreStatus
implements ToCopyableBuilder<Builder, RestoreStatus> {
    private final String status;
    private final Double currentRestoreRateInMegaBytesPerSecond;
    private final Long snapshotSizeInMegaBytes;
    private final Long progressInMegaBytes;
    private final Long elapsedTimeInSeconds;
    private final Long estimatedTimeToCompletionInSeconds;

    private RestoreStatus(BuilderImpl builder) {
        this.status = builder.status;
        this.currentRestoreRateInMegaBytesPerSecond = builder.currentRestoreRateInMegaBytesPerSecond;
        this.snapshotSizeInMegaBytes = builder.snapshotSizeInMegaBytes;
        this.progressInMegaBytes = builder.progressInMegaBytes;
        this.elapsedTimeInSeconds = builder.elapsedTimeInSeconds;
        this.estimatedTimeToCompletionInSeconds = builder.estimatedTimeToCompletionInSeconds;
    }

    public String status() {
        return this.status;
    }

    public Double currentRestoreRateInMegaBytesPerSecond() {
        return this.currentRestoreRateInMegaBytesPerSecond;
    }

    public Long snapshotSizeInMegaBytes() {
        return this.snapshotSizeInMegaBytes;
    }

    public Long progressInMegaBytes() {
        return this.progressInMegaBytes;
    }

    public Long elapsedTimeInSeconds() {
        return this.elapsedTimeInSeconds;
    }

    public Long estimatedTimeToCompletionInSeconds() {
        return this.estimatedTimeToCompletionInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.currentRestoreRateInMegaBytesPerSecond() == null ? 0 : this.currentRestoreRateInMegaBytesPerSecond().hashCode());
        hashCode = 31 * hashCode + (this.snapshotSizeInMegaBytes() == null ? 0 : this.snapshotSizeInMegaBytes().hashCode());
        hashCode = 31 * hashCode + (this.progressInMegaBytes() == null ? 0 : this.progressInMegaBytes().hashCode());
        hashCode = 31 * hashCode + (this.elapsedTimeInSeconds() == null ? 0 : this.elapsedTimeInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.estimatedTimeToCompletionInSeconds() == null ? 0 : this.estimatedTimeToCompletionInSeconds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreStatus)) {
            return false;
        }
        RestoreStatus other = (RestoreStatus)obj;
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.currentRestoreRateInMegaBytesPerSecond() == null ^ this.currentRestoreRateInMegaBytesPerSecond() == null) {
            return false;
        }
        if (other.currentRestoreRateInMegaBytesPerSecond() != null && !other.currentRestoreRateInMegaBytesPerSecond().equals(this.currentRestoreRateInMegaBytesPerSecond())) {
            return false;
        }
        if (other.snapshotSizeInMegaBytes() == null ^ this.snapshotSizeInMegaBytes() == null) {
            return false;
        }
        if (other.snapshotSizeInMegaBytes() != null && !other.snapshotSizeInMegaBytes().equals(this.snapshotSizeInMegaBytes())) {
            return false;
        }
        if (other.progressInMegaBytes() == null ^ this.progressInMegaBytes() == null) {
            return false;
        }
        if (other.progressInMegaBytes() != null && !other.progressInMegaBytes().equals(this.progressInMegaBytes())) {
            return false;
        }
        if (other.elapsedTimeInSeconds() == null ^ this.elapsedTimeInSeconds() == null) {
            return false;
        }
        if (other.elapsedTimeInSeconds() != null && !other.elapsedTimeInSeconds().equals(this.elapsedTimeInSeconds())) {
            return false;
        }
        if (other.estimatedTimeToCompletionInSeconds() == null ^ this.estimatedTimeToCompletionInSeconds() == null) {
            return false;
        }
        return other.estimatedTimeToCompletionInSeconds() == null || other.estimatedTimeToCompletionInSeconds().equals(this.estimatedTimeToCompletionInSeconds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.currentRestoreRateInMegaBytesPerSecond() != null) {
            sb.append("CurrentRestoreRateInMegaBytesPerSecond: ").append(this.currentRestoreRateInMegaBytesPerSecond()).append(",");
        }
        if (this.snapshotSizeInMegaBytes() != null) {
            sb.append("SnapshotSizeInMegaBytes: ").append(this.snapshotSizeInMegaBytes()).append(",");
        }
        if (this.progressInMegaBytes() != null) {
            sb.append("ProgressInMegaBytes: ").append(this.progressInMegaBytes()).append(",");
        }
        if (this.elapsedTimeInSeconds() != null) {
            sb.append("ElapsedTimeInSeconds: ").append(this.elapsedTimeInSeconds()).append(",");
        }
        if (this.estimatedTimeToCompletionInSeconds() != null) {
            sb.append("EstimatedTimeToCompletionInSeconds: ").append(this.estimatedTimeToCompletionInSeconds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String status;
        private Double currentRestoreRateInMegaBytesPerSecond;
        private Long snapshotSizeInMegaBytes;
        private Long progressInMegaBytes;
        private Long elapsedTimeInSeconds;
        private Long estimatedTimeToCompletionInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreStatus model) {
            this.setStatus(model.status);
            this.setCurrentRestoreRateInMegaBytesPerSecond(model.currentRestoreRateInMegaBytesPerSecond);
            this.setSnapshotSizeInMegaBytes(model.snapshotSizeInMegaBytes);
            this.setProgressInMegaBytes(model.progressInMegaBytes);
            this.setElapsedTimeInSeconds(model.elapsedTimeInSeconds);
            this.setEstimatedTimeToCompletionInSeconds(model.estimatedTimeToCompletionInSeconds);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Double getCurrentRestoreRateInMegaBytesPerSecond() {
            return this.currentRestoreRateInMegaBytesPerSecond;
        }

        @Override
        public final Builder currentRestoreRateInMegaBytesPerSecond(Double currentRestoreRateInMegaBytesPerSecond) {
            this.currentRestoreRateInMegaBytesPerSecond = currentRestoreRateInMegaBytesPerSecond;
            return this;
        }

        public final void setCurrentRestoreRateInMegaBytesPerSecond(Double currentRestoreRateInMegaBytesPerSecond) {
            this.currentRestoreRateInMegaBytesPerSecond = currentRestoreRateInMegaBytesPerSecond;
        }

        public final Long getSnapshotSizeInMegaBytes() {
            return this.snapshotSizeInMegaBytes;
        }

        @Override
        public final Builder snapshotSizeInMegaBytes(Long snapshotSizeInMegaBytes) {
            this.snapshotSizeInMegaBytes = snapshotSizeInMegaBytes;
            return this;
        }

        public final void setSnapshotSizeInMegaBytes(Long snapshotSizeInMegaBytes) {
            this.snapshotSizeInMegaBytes = snapshotSizeInMegaBytes;
        }

        public final Long getProgressInMegaBytes() {
            return this.progressInMegaBytes;
        }

        @Override
        public final Builder progressInMegaBytes(Long progressInMegaBytes) {
            this.progressInMegaBytes = progressInMegaBytes;
            return this;
        }

        public final void setProgressInMegaBytes(Long progressInMegaBytes) {
            this.progressInMegaBytes = progressInMegaBytes;
        }

        public final Long getElapsedTimeInSeconds() {
            return this.elapsedTimeInSeconds;
        }

        @Override
        public final Builder elapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
            return this;
        }

        public final void setElapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
        }

        public final Long getEstimatedTimeToCompletionInSeconds() {
            return this.estimatedTimeToCompletionInSeconds;
        }

        @Override
        public final Builder estimatedTimeToCompletionInSeconds(Long estimatedTimeToCompletionInSeconds) {
            this.estimatedTimeToCompletionInSeconds = estimatedTimeToCompletionInSeconds;
            return this;
        }

        public final void setEstimatedTimeToCompletionInSeconds(Long estimatedTimeToCompletionInSeconds) {
            this.estimatedTimeToCompletionInSeconds = estimatedTimeToCompletionInSeconds;
        }

        public RestoreStatus build() {
            return new RestoreStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, RestoreStatus> {
        public Builder status(String var1);

        public Builder currentRestoreRateInMegaBytesPerSecond(Double var1);

        public Builder snapshotSizeInMegaBytes(Long var1);

        public Builder progressInMegaBytes(Long var1);

        public Builder elapsedTimeInSeconds(Long var1);

        public Builder estimatedTimeToCompletionInSeconds(Long var1);
    }
}

