/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.redshift.model.Parameter;
import software.amazon.awssdk.services.redshift.model.ParametersListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ResetClusterParameterGroupRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ResetClusterParameterGroupRequest> {
    private final String parameterGroupName;
    private final Boolean resetAllParameters;
    private final List<Parameter> parameters;

    private ResetClusterParameterGroupRequest(BuilderImpl builder) {
        this.parameterGroupName = builder.parameterGroupName;
        this.resetAllParameters = builder.resetAllParameters;
        this.parameters = builder.parameters;
    }

    public String parameterGroupName() {
        return this.parameterGroupName;
    }

    public Boolean resetAllParameters() {
        return this.resetAllParameters;
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.parameterGroupName() == null ? 0 : this.parameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.resetAllParameters() == null ? 0 : this.resetAllParameters().hashCode());
        hashCode = 31 * hashCode + (this.parameters() == null ? 0 : this.parameters().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResetClusterParameterGroupRequest)) {
            return false;
        }
        ResetClusterParameterGroupRequest other = (ResetClusterParameterGroupRequest)((Object)obj);
        if (other.parameterGroupName() == null ^ this.parameterGroupName() == null) {
            return false;
        }
        if (other.parameterGroupName() != null && !other.parameterGroupName().equals(this.parameterGroupName())) {
            return false;
        }
        if (other.resetAllParameters() == null ^ this.resetAllParameters() == null) {
            return false;
        }
        if (other.resetAllParameters() != null && !other.resetAllParameters().equals(this.resetAllParameters())) {
            return false;
        }
        if (other.parameters() == null ^ this.parameters() == null) {
            return false;
        }
        return other.parameters() == null || other.parameters().equals(this.parameters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.parameterGroupName() != null) {
            sb.append("ParameterGroupName: ").append(this.parameterGroupName()).append(",");
        }
        if (this.resetAllParameters() != null) {
            sb.append("ResetAllParameters: ").append(this.resetAllParameters()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String parameterGroupName;
        private Boolean resetAllParameters;
        private List<Parameter> parameters = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(ResetClusterParameterGroupRequest model) {
            this.setParameterGroupName(model.parameterGroupName);
            this.setResetAllParameters(model.resetAllParameters);
            this.setParameters(model.parameters);
        }

        public final String getParameterGroupName() {
            return this.parameterGroupName;
        }

        @Override
        public final Builder parameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
            return this;
        }

        public final void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        public final Boolean getResetAllParameters() {
            return this.resetAllParameters;
        }

        @Override
        public final Builder resetAllParameters(Boolean resetAllParameters) {
            this.resetAllParameters = resetAllParameters;
            return this;
        }

        public final void setResetAllParameters(Boolean resetAllParameters) {
            this.resetAllParameters = resetAllParameters;
        }

        public final Collection<Parameter> getParameters() {
            return this.parameters;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            if (this.parameters == null) {
                this.parameters = new SdkInternalList(parameters.length);
            }
            for (Parameter e : parameters) {
                this.parameters.add(e);
            }
            return this;
        }

        public final void setParameters(Collection<Parameter> parameters) {
            this.parameters = ParametersListCopier.copy(parameters);
        }

        @SafeVarargs
        public final void setParameters(Parameter ... parameters) {
            if (this.parameters == null) {
                this.parameters = new SdkInternalList(parameters.length);
            }
            for (Parameter e : parameters) {
                this.parameters.add(e);
            }
        }

        public ResetClusterParameterGroupRequest build() {
            return new ResetClusterParameterGroupRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ResetClusterParameterGroupRequest> {
        public Builder parameterGroupName(String var1);

        public Builder resetAllParameters(Boolean var1);

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);
    }
}

