/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.redshift.model.TaggedResource;
import software.amazon.awssdk.services.redshift.model.TaggedResourceListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeTagsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeTagsResponse> {
    private final List<TaggedResource> taggedResources;
    private final String marker;

    private DescribeTagsResponse(BuilderImpl builder) {
        this.taggedResources = builder.taggedResources;
        this.marker = builder.marker;
    }

    public List<TaggedResource> taggedResources() {
        return this.taggedResources;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.taggedResources() == null ? 0 : this.taggedResources().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTagsResponse)) {
            return false;
        }
        DescribeTagsResponse other = (DescribeTagsResponse)((Object)obj);
        if (other.taggedResources() == null ^ this.taggedResources() == null) {
            return false;
        }
        if (other.taggedResources() != null && !other.taggedResources().equals(this.taggedResources())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.taggedResources() != null) {
            sb.append("TaggedResources: ").append(this.taggedResources()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<TaggedResource> taggedResources = new SdkInternalList();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTagsResponse model) {
            this.setTaggedResources(model.taggedResources);
            this.setMarker(model.marker);
        }

        public final Collection<TaggedResource> getTaggedResources() {
            return this.taggedResources;
        }

        @Override
        public final Builder taggedResources(Collection<TaggedResource> taggedResources) {
            this.taggedResources = TaggedResourceListCopier.copy(taggedResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taggedResources(TaggedResource ... taggedResources) {
            if (this.taggedResources == null) {
                this.taggedResources = new SdkInternalList(taggedResources.length);
            }
            for (TaggedResource e : taggedResources) {
                this.taggedResources.add(e);
            }
            return this;
        }

        public final void setTaggedResources(Collection<TaggedResource> taggedResources) {
            this.taggedResources = TaggedResourceListCopier.copy(taggedResources);
        }

        @SafeVarargs
        public final void setTaggedResources(TaggedResource ... taggedResources) {
            if (this.taggedResources == null) {
                this.taggedResources = new SdkInternalList(taggedResources.length);
            }
            for (TaggedResource e : taggedResources) {
                this.taggedResources.add(e);
            }
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public DescribeTagsResponse build() {
            return new DescribeTagsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeTagsResponse> {
        public Builder taggedResources(Collection<TaggedResource> var1);

        public Builder taggedResources(TaggedResource ... var1);

        public Builder marker(String var1);
    }
}

