/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.redshift.model.OrderableClusterOption;
import software.amazon.awssdk.services.redshift.model.OrderableClusterOptionsListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeOrderableClusterOptionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeOrderableClusterOptionsResponse> {
    private final List<OrderableClusterOption> orderableClusterOptions;
    private final String marker;

    private DescribeOrderableClusterOptionsResponse(BuilderImpl builder) {
        this.orderableClusterOptions = builder.orderableClusterOptions;
        this.marker = builder.marker;
    }

    public List<OrderableClusterOption> orderableClusterOptions() {
        return this.orderableClusterOptions;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.orderableClusterOptions() == null ? 0 : this.orderableClusterOptions().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrderableClusterOptionsResponse)) {
            return false;
        }
        DescribeOrderableClusterOptionsResponse other = (DescribeOrderableClusterOptionsResponse)((Object)obj);
        if (other.orderableClusterOptions() == null ^ this.orderableClusterOptions() == null) {
            return false;
        }
        if (other.orderableClusterOptions() != null && !other.orderableClusterOptions().equals(this.orderableClusterOptions())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.orderableClusterOptions() != null) {
            sb.append("OrderableClusterOptions: ").append(this.orderableClusterOptions()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<OrderableClusterOption> orderableClusterOptions = new SdkInternalList();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrderableClusterOptionsResponse model) {
            this.setOrderableClusterOptions(model.orderableClusterOptions);
            this.setMarker(model.marker);
        }

        public final Collection<OrderableClusterOption> getOrderableClusterOptions() {
            return this.orderableClusterOptions;
        }

        @Override
        public final Builder orderableClusterOptions(Collection<OrderableClusterOption> orderableClusterOptions) {
            this.orderableClusterOptions = OrderableClusterOptionsListCopier.copy(orderableClusterOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderableClusterOptions(OrderableClusterOption ... orderableClusterOptions) {
            if (this.orderableClusterOptions == null) {
                this.orderableClusterOptions = new SdkInternalList(orderableClusterOptions.length);
            }
            for (OrderableClusterOption e : orderableClusterOptions) {
                this.orderableClusterOptions.add(e);
            }
            return this;
        }

        public final void setOrderableClusterOptions(Collection<OrderableClusterOption> orderableClusterOptions) {
            this.orderableClusterOptions = OrderableClusterOptionsListCopier.copy(orderableClusterOptions);
        }

        @SafeVarargs
        public final void setOrderableClusterOptions(OrderableClusterOption ... orderableClusterOptions) {
            if (this.orderableClusterOptions == null) {
                this.orderableClusterOptions = new SdkInternalList(orderableClusterOptions.length);
            }
            for (OrderableClusterOption e : orderableClusterOptions) {
                this.orderableClusterOptions.add(e);
            }
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public DescribeOrderableClusterOptionsResponse build() {
            return new DescribeOrderableClusterOptionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeOrderableClusterOptionsResponse> {
        public Builder orderableClusterOptions(Collection<OrderableClusterOption> var1);

        public Builder orderableClusterOptions(OrderableClusterOption ... var1);

        public Builder marker(String var1);
    }
}

