/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.services.redshift.model.HsmClientCertificate;
import software.amazon.awssdk.services.redshift.model.HsmClientCertificateListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeHsmClientCertificatesResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeHsmClientCertificatesResponse> {
    private final String marker;
    private final List<HsmClientCertificate> hsmClientCertificates;

    private DescribeHsmClientCertificatesResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.hsmClientCertificates = builder.hsmClientCertificates;
    }

    public String marker() {
        return this.marker;
    }

    public List<HsmClientCertificate> hsmClientCertificates() {
        return this.hsmClientCertificates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        hashCode = 31 * hashCode + (this.hsmClientCertificates() == null ? 0 : this.hsmClientCertificates().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHsmClientCertificatesResponse)) {
            return false;
        }
        DescribeHsmClientCertificatesResponse other = (DescribeHsmClientCertificatesResponse)((Object)obj);
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        if (other.marker() != null && !other.marker().equals(this.marker())) {
            return false;
        }
        if (other.hsmClientCertificates() == null ^ this.hsmClientCertificates() == null) {
            return false;
        }
        return other.hsmClientCertificates() == null || other.hsmClientCertificates().equals(this.hsmClientCertificates());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.hsmClientCertificates() != null) {
            sb.append("HsmClientCertificates: ").append(this.hsmClientCertificates()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<HsmClientCertificate> hsmClientCertificates = new SdkInternalList();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHsmClientCertificatesResponse model) {
            this.setMarker(model.marker);
            this.setHsmClientCertificates(model.hsmClientCertificates);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<HsmClientCertificate> getHsmClientCertificates() {
            return this.hsmClientCertificates;
        }

        @Override
        public final Builder hsmClientCertificates(Collection<HsmClientCertificate> hsmClientCertificates) {
            this.hsmClientCertificates = HsmClientCertificateListCopier.copy(hsmClientCertificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hsmClientCertificates(HsmClientCertificate ... hsmClientCertificates) {
            if (this.hsmClientCertificates == null) {
                this.hsmClientCertificates = new SdkInternalList(hsmClientCertificates.length);
            }
            for (HsmClientCertificate e : hsmClientCertificates) {
                this.hsmClientCertificates.add(e);
            }
            return this;
        }

        public final void setHsmClientCertificates(Collection<HsmClientCertificate> hsmClientCertificates) {
            this.hsmClientCertificates = HsmClientCertificateListCopier.copy(hsmClientCertificates);
        }

        @SafeVarargs
        public final void setHsmClientCertificates(HsmClientCertificate ... hsmClientCertificates) {
            if (this.hsmClientCertificates == null) {
                this.hsmClientCertificates = new SdkInternalList(hsmClientCertificates.length);
            }
            for (HsmClientCertificate e : hsmClientCertificates) {
                this.hsmClientCertificates.add(e);
            }
        }

        public DescribeHsmClientCertificatesResponse build() {
            return new DescribeHsmClientCertificatesResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeHsmClientCertificatesResponse> {
        public Builder marker(String var1);

        public Builder hsmClientCertificates(Collection<HsmClientCertificate> var1);

        public Builder hsmClientCertificates(HsmClientCertificate ... var1);
    }
}

