/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rdsdata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rdsdata.model.RdsDataResponse;
import software.amazon.awssdk.services.rdsdata.model.UpdateResult;
import software.amazon.awssdk.services.rdsdata.model.UpdateResultsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchExecuteStatementResponse
extends RdsDataResponse
implements ToCopyableBuilder<Builder, BatchExecuteStatementResponse> {
    private static final SdkField<List<UpdateResult>> UPDATE_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("updateResults").getter(BatchExecuteStatementResponse.getter(BatchExecuteStatementResponse::updateResults)).setter(BatchExecuteStatementResponse.setter(Builder::updateResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UpdateResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPDATE_RESULTS_FIELD));
    private final List<UpdateResult> updateResults;

    private BatchExecuteStatementResponse(BuilderImpl builder) {
        super(builder);
        this.updateResults = builder.updateResults;
    }

    public final boolean hasUpdateResults() {
        return this.updateResults != null && !(this.updateResults instanceof SdkAutoConstructList);
    }

    public final List<UpdateResult> updateResults() {
        return this.updateResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUpdateResults() ? this.updateResults() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchExecuteStatementResponse)) {
            return false;
        }
        BatchExecuteStatementResponse other = (BatchExecuteStatementResponse)((Object)obj);
        return this.hasUpdateResults() == other.hasUpdateResults() && Objects.equals(this.updateResults(), other.updateResults());
    }

    public final String toString() {
        return ToString.builder((String)"BatchExecuteStatementResponse").add("UpdateResults", this.hasUpdateResults() ? this.updateResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "updateResults": {
                return Optional.ofNullable(clazz.cast(this.updateResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchExecuteStatementResponse, T> g) {
        return obj -> g.apply((BatchExecuteStatementResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsDataResponse.BuilderImpl
    implements Builder {
        private List<UpdateResult> updateResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchExecuteStatementResponse model) {
            super(model);
            this.updateResults(model.updateResults);
        }

        public final Collection<UpdateResult.Builder> getUpdateResults() {
            if (this.updateResults instanceof SdkAutoConstructList) {
                return null;
            }
            return this.updateResults != null ? (Collection)this.updateResults.stream().map(UpdateResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder updateResults(Collection<UpdateResult> updateResults) {
            this.updateResults = UpdateResultsCopier.copy(updateResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateResults(UpdateResult ... updateResults) {
            this.updateResults(Arrays.asList(updateResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateResults(Consumer<UpdateResult.Builder> ... updateResults) {
            this.updateResults(Stream.of(updateResults).map(c -> (UpdateResult)((UpdateResult.Builder)UpdateResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUpdateResults(Collection<UpdateResult.BuilderImpl> updateResults) {
            this.updateResults = UpdateResultsCopier.copyFromBuilder(updateResults);
        }

        @Override
        public BatchExecuteStatementResponse build() {
            return new BatchExecuteStatementResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchExecuteStatementResponse> {
        public Builder updateResults(Collection<UpdateResult> var1);

        public Builder updateResults(UpdateResult ... var1);

        public Builder updateResults(Consumer<UpdateResult.Builder> ... var1);
    }
}

