/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rdsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure value returned by a call.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StructValue implements SdkPojo, Serializable, ToCopyableBuilder<StructValue.Builder, StructValue> {
    private static final SdkField<List<Value>> ATTRIBUTES_FIELD = SdkField
            .<List<Value>> builder(MarshallingType.LIST)
            .memberName("attributes")
            .getter(getter(StructValue::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Value> builder(MarshallingType.SDK_POJO)
                                            .constructor(Value::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Value> attributes;

    private StructValue(BuilderImpl builder) {
        this.attributes = builder.attributes;
    }

    /**
     * Returns true if the Attributes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attributes returned in the record.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The attributes returned in the record.
     */
    public final List<Value> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StructValue)) {
            return false;
        }
        StructValue other = (StructValue) obj;
        return hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StructValue").add("Attributes", hasAttributes() ? attributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StructValue, T> g) {
        return obj -> g.apply((StructValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StructValue> {
        /**
         * <p>
         * The attributes returned in the record.
         * </p>
         * 
         * @param attributes
         *        The attributes returned in the record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<Value> attributes);

        /**
         * <p>
         * The attributes returned in the record.
         * </p>
         * 
         * @param attributes
         *        The attributes returned in the record.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Value... attributes);

        /**
         * <p>
         * The attributes returned in the record.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Value>.Builder} avoiding the need to create
         * one manually via {@link List<Value>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Value>.Builder#build()} is called immediately and its result
         * is passed to {@link #attributes(List<Value>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on {@link List<Value>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(List<Value>)
         */
        Builder attributes(Consumer<Value.Builder>... attributes);
    }

    static final class BuilderImpl implements Builder {
        private List<Value> attributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StructValue model) {
            attributes(model.attributes);
        }

        public final Collection<Value.Builder> getAttributes() {
            if (attributes instanceof SdkAutoConstructList) {
                return null;
            }
            return attributes != null ? attributes.stream().map(Value::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attributes(Collection<Value> attributes) {
            this.attributes = ArrayValueListCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Value... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<Value.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> Value.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttributes(Collection<Value.BuilderImpl> attributes) {
            this.attributes = ArrayValueListCopier.copyFromBuilder(attributes);
        }

        @Override
        public StructValue build() {
            return new StructValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
