/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rdsdata.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rdsdata.model.ArrayValueListCopier;
import software.amazon.awssdk.services.rdsdata.model.StructValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Value
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Value> {
    private static final SdkField<List<Value>> ARRAY_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(Value.getter(Value::arrayValues)).setter(Value.setter(Builder::arrayValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arrayValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Value::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Long> BIG_INT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(Value.getter(Value::bigIntValue)).setter(Value.setter(Builder::bigIntValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bigIntValue").build()}).build();
    private static final SdkField<Boolean> BIT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Value.getter(Value::bitValue)).setter(Value.setter(Builder::bitValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bitValue").build()}).build();
    private static final SdkField<SdkBytes> BLOB_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).getter(Value.getter(Value::blobValue)).setter(Value.setter(Builder::blobValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blobValue").build()}).build();
    private static final SdkField<Double> DOUBLE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(Value.getter(Value::doubleValue)).setter(Value.setter(Builder::doubleValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("doubleValue").build()}).build();
    private static final SdkField<Integer> INT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(Value.getter(Value::intValue)).setter(Value.setter(Builder::intValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intValue").build()}).build();
    private static final SdkField<Boolean> IS_NULL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Value.getter(Value::isNull)).setter(Value.setter(Builder::isNull)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isNull").build()}).build();
    private static final SdkField<Float> REAL_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).getter(Value.getter(Value::realValue)).setter(Value.setter(Builder::realValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("realValue").build()}).build();
    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Value.getter(Value::stringValue)).setter(Value.setter(Builder::stringValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()}).build();
    private static final SdkField<StructValue> STRUCT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Value.getter(Value::structValue)).setter(Value.setter(Builder::structValue)).constructor(StructValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("structValue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARRAY_VALUES_FIELD, BIG_INT_VALUE_FIELD, BIT_VALUE_FIELD, BLOB_VALUE_FIELD, DOUBLE_VALUE_FIELD, INT_VALUE_FIELD, IS_NULL_FIELD, REAL_VALUE_FIELD, STRING_VALUE_FIELD, STRUCT_VALUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<Value> arrayValues;
    private final Long bigIntValue;
    private final Boolean bitValue;
    private final SdkBytes blobValue;
    private final Double doubleValue;
    private final Integer intValue;
    private final Boolean isNull;
    private final Float realValue;
    private final String stringValue;
    private final StructValue structValue;

    private Value(BuilderImpl builder) {
        this.arrayValues = builder.arrayValues;
        this.bigIntValue = builder.bigIntValue;
        this.bitValue = builder.bitValue;
        this.blobValue = builder.blobValue;
        this.doubleValue = builder.doubleValue;
        this.intValue = builder.intValue;
        this.isNull = builder.isNull;
        this.realValue = builder.realValue;
        this.stringValue = builder.stringValue;
        this.structValue = builder.structValue;
    }

    public boolean hasArrayValues() {
        return this.arrayValues != null && !(this.arrayValues instanceof SdkAutoConstructList);
    }

    public List<Value> arrayValues() {
        return this.arrayValues;
    }

    public Long bigIntValue() {
        return this.bigIntValue;
    }

    public Boolean bitValue() {
        return this.bitValue;
    }

    public SdkBytes blobValue() {
        return this.blobValue;
    }

    public Double doubleValue() {
        return this.doubleValue;
    }

    public Integer intValue() {
        return this.intValue;
    }

    public Boolean isNull() {
        return this.isNull;
    }

    public Float realValue() {
        return this.realValue;
    }

    public String stringValue() {
        return this.stringValue;
    }

    public StructValue structValue() {
        return this.structValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arrayValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.bigIntValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.bitValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.blobValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.intValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.isNull());
        hashCode = 31 * hashCode + Objects.hashCode(this.realValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.structValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Value)) {
            return false;
        }
        Value other = (Value)obj;
        return Objects.equals(this.arrayValues(), other.arrayValues()) && Objects.equals(this.bigIntValue(), other.bigIntValue()) && Objects.equals(this.bitValue(), other.bitValue()) && Objects.equals(this.blobValue(), other.blobValue()) && Objects.equals(this.doubleValue(), other.doubleValue()) && Objects.equals(this.intValue(), other.intValue()) && Objects.equals(this.isNull(), other.isNull()) && Objects.equals(this.realValue(), other.realValue()) && Objects.equals(this.stringValue(), other.stringValue()) && Objects.equals(this.structValue(), other.structValue());
    }

    public String toString() {
        return ToString.builder((String)"Value").add("ArrayValues", this.arrayValues()).add("BigIntValue", (Object)this.bigIntValue()).add("BitValue", (Object)this.bitValue()).add("BlobValue", (Object)this.blobValue()).add("DoubleValue", (Object)this.doubleValue()).add("IntValue", (Object)this.intValue()).add("IsNull", (Object)this.isNull()).add("RealValue", (Object)this.realValue()).add("StringValue", (Object)this.stringValue()).add("StructValue", (Object)this.structValue()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arrayValues": {
                return Optional.ofNullable(clazz.cast(this.arrayValues()));
            }
            case "bigIntValue": {
                return Optional.ofNullable(clazz.cast(this.bigIntValue()));
            }
            case "bitValue": {
                return Optional.ofNullable(clazz.cast(this.bitValue()));
            }
            case "blobValue": {
                return Optional.ofNullable(clazz.cast(this.blobValue()));
            }
            case "doubleValue": {
                return Optional.ofNullable(clazz.cast(this.doubleValue()));
            }
            case "intValue": {
                return Optional.ofNullable(clazz.cast(this.intValue()));
            }
            case "isNull": {
                return Optional.ofNullable(clazz.cast(this.isNull()));
            }
            case "realValue": {
                return Optional.ofNullable(clazz.cast(this.realValue()));
            }
            case "stringValue": {
                return Optional.ofNullable(clazz.cast(this.stringValue()));
            }
            case "structValue": {
                return Optional.ofNullable(clazz.cast(this.structValue()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Value, T> g) {
        return obj -> g.apply((Value)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Value> arrayValues = DefaultSdkAutoConstructList.getInstance();
        private Long bigIntValue;
        private Boolean bitValue;
        private SdkBytes blobValue;
        private Double doubleValue;
        private Integer intValue;
        private Boolean isNull;
        private Float realValue;
        private String stringValue;
        private StructValue structValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Value model) {
            this.arrayValues(model.arrayValues);
            this.bigIntValue(model.bigIntValue);
            this.bitValue(model.bitValue);
            this.blobValue(model.blobValue);
            this.doubleValue(model.doubleValue);
            this.intValue(model.intValue);
            this.isNull(model.isNull);
            this.realValue(model.realValue);
            this.stringValue(model.stringValue);
            this.structValue(model.structValue);
        }

        public final Collection<Builder> getArrayValues() {
            return this.arrayValues != null ? (Collection)this.arrayValues.stream().map(Value::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder arrayValues(Collection<Value> arrayValues) {
            this.arrayValues = ArrayValueListCopier.copy(arrayValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder arrayValues(Value ... arrayValues) {
            this.arrayValues(Arrays.asList(arrayValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder arrayValues(Consumer<Builder> ... arrayValues) {
            this.arrayValues(Stream.of(arrayValues).map(c -> (Value)((Builder)Value.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setArrayValues(Collection<BuilderImpl> arrayValues) {
            this.arrayValues = ArrayValueListCopier.copyFromBuilder(arrayValues);
        }

        public final Long getBigIntValue() {
            return this.bigIntValue;
        }

        @Override
        public final Builder bigIntValue(Long bigIntValue) {
            this.bigIntValue = bigIntValue;
            return this;
        }

        public final void setBigIntValue(Long bigIntValue) {
            this.bigIntValue = bigIntValue;
        }

        public final Boolean getBitValue() {
            return this.bitValue;
        }

        @Override
        public final Builder bitValue(Boolean bitValue) {
            this.bitValue = bitValue;
            return this;
        }

        public final void setBitValue(Boolean bitValue) {
            this.bitValue = bitValue;
        }

        public final ByteBuffer getBlobValue() {
            return this.blobValue == null ? null : this.blobValue.asByteBuffer();
        }

        @Override
        public final Builder blobValue(SdkBytes blobValue) {
            this.blobValue = StandardMemberCopier.copy((SdkBytes)blobValue);
            return this;
        }

        public final void setBlobValue(ByteBuffer blobValue) {
            this.blobValue(blobValue == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)blobValue));
        }

        public final Double getDoubleValue() {
            return this.doubleValue;
        }

        @Override
        public final Builder doubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
            return this;
        }

        public final void setDoubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
        }

        public final Integer getIntValue() {
            return this.intValue;
        }

        @Override
        public final Builder intValue(Integer intValue) {
            this.intValue = intValue;
            return this;
        }

        public final void setIntValue(Integer intValue) {
            this.intValue = intValue;
        }

        public final Boolean getIsNull() {
            return this.isNull;
        }

        @Override
        public final Builder isNull(Boolean isNull) {
            this.isNull = isNull;
            return this;
        }

        public final void setIsNull(Boolean isNull) {
            this.isNull = isNull;
        }

        public final Float getRealValue() {
            return this.realValue;
        }

        @Override
        public final Builder realValue(Float realValue) {
            this.realValue = realValue;
            return this;
        }

        public final void setRealValue(Float realValue) {
            this.realValue = realValue;
        }

        public final String getStringValue() {
            return this.stringValue;
        }

        @Override
        public final Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public final void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        public final StructValue.Builder getStructValue() {
            return this.structValue != null ? this.structValue.toBuilder() : null;
        }

        @Override
        public final Builder structValue(StructValue structValue) {
            this.structValue = structValue;
            return this;
        }

        public final void setStructValue(StructValue.BuilderImpl structValue) {
            this.structValue = structValue != null ? structValue.build() : null;
        }

        public Value build() {
            return new Value(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Value> {
        public Builder arrayValues(Collection<Value> var1);

        public Builder arrayValues(Value ... var1);

        public Builder arrayValues(Consumer<Builder> ... var1);

        public Builder bigIntValue(Long var1);

        public Builder bitValue(Boolean var1);

        public Builder blobValue(SdkBytes var1);

        public Builder doubleValue(Double var1);

        public Builder intValue(Integer var1);

        public Builder isNull(Boolean var1);

        public Builder realValue(Float var1);

        public Builder stringValue(String var1);

        public Builder structValue(StructValue var1);

        default public Builder structValue(Consumer<StructValue.Builder> structValue) {
            return this.structValue((StructValue)((StructValue.Builder)StructValue.builder().applyMutation(structValue)).build());
        }
    }
}

