/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rdsdata.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DecimalReturnType {
    DOUBLE_OR_LONG("DOUBLE_OR_LONG"),
    STRING("STRING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DecimalReturnType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DecimalReturnType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DecimalReturnType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DecimalReturnType> knownValues() {
        return Stream.of(DecimalReturnType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

