/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rdsdata.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result set returned by a SQL statement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResultFrame implements SdkPojo, Serializable, ToCopyableBuilder<ResultFrame.Builder, ResultFrame> {
    private static final SdkField<List<Record>> RECORDS_FIELD = SdkField
            .<List<Record>> builder(MarshallingType.LIST)
            .getter(getter(ResultFrame::records))
            .setter(setter(Builder::records))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("records").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Record> builder(MarshallingType.SDK_POJO)
                                            .constructor(Record::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ResultSetMetadata> RESULT_SET_METADATA_FIELD = SdkField
            .<ResultSetMetadata> builder(MarshallingType.SDK_POJO).getter(getter(ResultFrame::resultSetMetadata))
            .setter(setter(Builder::resultSetMetadata)).constructor(ResultSetMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultSetMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDS_FIELD,
            RESULT_SET_METADATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<Record> records;

    private final ResultSetMetadata resultSetMetadata;

    private ResultFrame(BuilderImpl builder) {
        this.records = builder.records;
        this.resultSetMetadata = builder.resultSetMetadata;
    }

    /**
     * Returns true if the Records property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRecords() {
        return records != null && !(records instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The records in the result set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRecords()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The records in the result set.
     */
    public List<Record> records() {
        return records;
    }

    /**
     * <p>
     * The result-set metadata in the result set.
     * </p>
     * 
     * @return The result-set metadata in the result set.
     */
    public ResultSetMetadata resultSetMetadata() {
        return resultSetMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(records());
        hashCode = 31 * hashCode + Objects.hashCode(resultSetMetadata());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResultFrame)) {
            return false;
        }
        ResultFrame other = (ResultFrame) obj;
        return Objects.equals(records(), other.records()) && Objects.equals(resultSetMetadata(), other.resultSetMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResultFrame").add("Records", records()).add("ResultSetMetadata", resultSetMetadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "records":
            return Optional.ofNullable(clazz.cast(records()));
        case "resultSetMetadata":
            return Optional.ofNullable(clazz.cast(resultSetMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResultFrame, T> g) {
        return obj -> g.apply((ResultFrame) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResultFrame> {
        /**
         * <p>
         * The records in the result set.
         * </p>
         * 
         * @param records
         *        The records in the result set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Collection<Record> records);

        /**
         * <p>
         * The records in the result set.
         * </p>
         * 
         * @param records
         *        The records in the result set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Record... records);

        /**
         * <p>
         * The records in the result set.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Record>.Builder} avoiding the need to
         * create one manually via {@link List<Record>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Record>.Builder#build()} is called immediately and its
         * result is passed to {@link #records(List<Record>)}.
         * 
         * @param records
         *        a consumer that will call methods on {@link List<Record>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #records(List<Record>)
         */
        Builder records(Consumer<Record.Builder>... records);

        /**
         * <p>
         * The result-set metadata in the result set.
         * </p>
         * 
         * @param resultSetMetadata
         *        The result-set metadata in the result set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultSetMetadata(ResultSetMetadata resultSetMetadata);

        /**
         * <p>
         * The result-set metadata in the result set.
         * </p>
         * This is a convenience that creates an instance of the {@link ResultSetMetadata.Builder} avoiding the need to
         * create one manually via {@link ResultSetMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResultSetMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #resultSetMetadata(ResultSetMetadata)}.
         * 
         * @param resultSetMetadata
         *        a consumer that will call methods on {@link ResultSetMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultSetMetadata(ResultSetMetadata)
         */
        default Builder resultSetMetadata(Consumer<ResultSetMetadata.Builder> resultSetMetadata) {
            return resultSetMetadata(ResultSetMetadata.builder().applyMutation(resultSetMetadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<Record> records = DefaultSdkAutoConstructList.getInstance();

        private ResultSetMetadata resultSetMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(ResultFrame model) {
            records(model.records);
            resultSetMetadata(model.resultSetMetadata);
        }

        public final Collection<Record.Builder> getRecords() {
            return records != null ? records.stream().map(Record::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder records(Collection<Record> records) {
            this.records = RecordsCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Record... records) {
            records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<Record.Builder>... records) {
            records(Stream.of(records).map(c -> Record.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecords(Collection<Record.BuilderImpl> records) {
            this.records = RecordsCopier.copyFromBuilder(records);
        }

        public final ResultSetMetadata.Builder getResultSetMetadata() {
            return resultSetMetadata != null ? resultSetMetadata.toBuilder() : null;
        }

        @Override
        public final Builder resultSetMetadata(ResultSetMetadata resultSetMetadata) {
            this.resultSetMetadata = resultSetMetadata;
            return this;
        }

        public final void setResultSetMetadata(ResultSetMetadata.BuilderImpl resultSetMetadata) {
            this.resultSetMetadata = resultSetMetadata != null ? resultSetMetadata.build() : null;
        }

        @Override
        public ResultFrame build() {
            return new ResultFrame(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
