/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AvailableProcessorFeature
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AvailableProcessorFeature> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AvailableProcessorFeature.getter(AvailableProcessorFeature::name)).setter(AvailableProcessorFeature.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AvailableProcessorFeature.getter(AvailableProcessorFeature::defaultValue)).setter(AvailableProcessorFeature.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()}).build();
    private static final SdkField<String> ALLOWED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AvailableProcessorFeature.getter(AvailableProcessorFeature::allowedValues)).setter(AvailableProcessorFeature.setter(Builder::allowedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedValues").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DEFAULT_VALUE_FIELD, ALLOWED_VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String defaultValue;
    private final String allowedValues;

    private AvailableProcessorFeature(BuilderImpl builder) {
        this.name = builder.name;
        this.defaultValue = builder.defaultValue;
        this.allowedValues = builder.allowedValues;
    }

    public String name() {
        return this.name;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public String allowedValues() {
        return this.allowedValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowedValues());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailableProcessorFeature)) {
            return false;
        }
        AvailableProcessorFeature other = (AvailableProcessorFeature)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.allowedValues(), other.allowedValues());
    }

    public String toString() {
        return ToString.builder((String)"AvailableProcessorFeature").add("Name", (Object)this.name()).add("DefaultValue", (Object)this.defaultValue()).add("AllowedValues", (Object)this.allowedValues()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DefaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "AllowedValues": {
                return Optional.ofNullable(clazz.cast(this.allowedValues()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AvailableProcessorFeature, T> g) {
        return obj -> g.apply((AvailableProcessorFeature)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String defaultValue;
        private String allowedValues;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailableProcessorFeature model) {
            this.name(model.name);
            this.defaultValue(model.defaultValue);
            this.allowedValues(model.allowedValues);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public final String getAllowedValues() {
            return this.allowedValues;
        }

        @Override
        public final Builder allowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
            return this;
        }

        public final void setAllowedValues(String allowedValues) {
            this.allowedValues = allowedValues;
        }

        public AvailableProcessorFeature build() {
            return new AvailableProcessorFeature(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AvailableProcessorFeature> {
        public Builder name(String var1);

        public Builder defaultValue(String var1);

        public Builder allowedValues(String var1);
    }
}

