/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DBSubnetGroup;
import software.amazon.awssdk.services.rds.model.DBSubnetGroupsCopier;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDbSubnetGroupsResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeDbSubnetGroupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeDbSubnetGroupsResponse.getter(DescribeDbSubnetGroupsResponse::marker)).setter(DescribeDbSubnetGroupsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<DBSubnetGroup>> DB_SUBNET_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeDbSubnetGroupsResponse.getter(DescribeDbSubnetGroupsResponse::dbSubnetGroups)).setter(DescribeDbSubnetGroupsResponse.setter(Builder::dbSubnetGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroups").build(), ListTrait.builder().memberLocationName("DBSubnetGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBSubnetGroup::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroup").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, DB_SUBNET_GROUPS_FIELD));
    private final String marker;
    private final List<DBSubnetGroup> dbSubnetGroups;

    private DescribeDbSubnetGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbSubnetGroups = builder.dbSubnetGroups;
    }

    public String marker() {
        return this.marker;
    }

    public List<DBSubnetGroup> dbSubnetGroups() {
        return this.dbSubnetGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbSubnetGroupsResponse)) {
            return false;
        }
        DescribeDbSubnetGroupsResponse other = (DescribeDbSubnetGroupsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.dbSubnetGroups(), other.dbSubnetGroups());
    }

    public String toString() {
        return ToString.builder((String)"DescribeDbSubnetGroupsResponse").add("Marker", (Object)this.marker()).add("DBSubnetGroups", this.dbSubnetGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "DBSubnetGroups": {
                return Optional.ofNullable(clazz.cast(this.dbSubnetGroups()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbSubnetGroupsResponse, T> g) {
        return obj -> g.apply((DescribeDbSubnetGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<DBSubnetGroup> dbSubnetGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbSubnetGroupsResponse model) {
            super(model);
            this.marker(model.marker);
            this.dbSubnetGroups(model.dbSubnetGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBSubnetGroup.Builder> getDbSubnetGroups() {
            return this.dbSubnetGroups != null ? (Collection)this.dbSubnetGroups.stream().map(DBSubnetGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbSubnetGroups(Collection<DBSubnetGroup> dbSubnetGroups) {
            this.dbSubnetGroups = DBSubnetGroupsCopier.copy(dbSubnetGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSubnetGroups(DBSubnetGroup ... dbSubnetGroups) {
            this.dbSubnetGroups(Arrays.asList(dbSubnetGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSubnetGroups(Consumer<DBSubnetGroup.Builder> ... dbSubnetGroups) {
            this.dbSubnetGroups(Stream.of(dbSubnetGroups).map(c -> (DBSubnetGroup)((DBSubnetGroup.Builder)DBSubnetGroup.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDbSubnetGroups(Collection<DBSubnetGroup.BuilderImpl> dbSubnetGroups) {
            this.dbSubnetGroups = DBSubnetGroupsCopier.copyFromBuilder(dbSubnetGroups);
        }

        @Override
        public DescribeDbSubnetGroupsResponse build() {
            return new DescribeDbSubnetGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDbSubnetGroupsResponse> {
        public Builder marker(String var1);

        public Builder dbSubnetGroups(Collection<DBSubnetGroup> var1);

        public Builder dbSubnetGroups(DBSubnetGroup ... var1);

        public Builder dbSubnetGroups(Consumer<DBSubnetGroup.Builder> ... var1);
    }
}

