/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.ValidStorageOptions;
import software.amazon.awssdk.services.rds.model.ValidStorageOptionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidVolumeOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ValidVolumeOptions> {
    private static final SdkField<String> VOLUME_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeName").getter(ValidVolumeOptions.getter(ValidVolumeOptions::volumeName)).setter(ValidVolumeOptions.setter(Builder::volumeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeName").build()}).build();
    private static final SdkField<List<ValidStorageOptions>> STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Storage").getter(ValidVolumeOptions.getter(ValidVolumeOptions::storage)).setter(ValidVolumeOptions.setter(Builder::storage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Storage").build(), ListTrait.builder().memberLocationName("ValidStorageOptions").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ValidStorageOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidStorageOptions").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_NAME_FIELD, STORAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ValidVolumeOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String volumeName;
    private final List<ValidStorageOptions> storage;

    private ValidVolumeOptions(BuilderImpl builder) {
        this.volumeName = builder.volumeName;
        this.storage = builder.storage;
    }

    public final String volumeName() {
        return this.volumeName;
    }

    public final boolean hasStorage() {
        return this.storage != null && !(this.storage instanceof SdkAutoConstructList);
    }

    public final List<ValidStorageOptions> storage() {
        return this.storage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStorage() ? this.storage() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidVolumeOptions)) {
            return false;
        }
        ValidVolumeOptions other = (ValidVolumeOptions)obj;
        return Objects.equals(this.volumeName(), other.volumeName()) && this.hasStorage() == other.hasStorage() && Objects.equals(this.storage(), other.storage());
    }

    public final String toString() {
        return ToString.builder((String)"ValidVolumeOptions").add("VolumeName", (Object)this.volumeName()).add("Storage", this.hasStorage() ? this.storage() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VolumeName": {
                return Optional.ofNullable(clazz.cast(this.volumeName()));
            }
            case "Storage": {
                return Optional.ofNullable(clazz.cast(this.storage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VolumeName", VOLUME_NAME_FIELD);
        map.put("Storage", STORAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidVolumeOptions, T> g) {
        return obj -> g.apply((ValidVolumeOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String volumeName;
        private List<ValidStorageOptions> storage = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidVolumeOptions model) {
            this.volumeName(model.volumeName);
            this.storage(model.storage);
        }

        public final String getVolumeName() {
            return this.volumeName;
        }

        public final void setVolumeName(String volumeName) {
            this.volumeName = volumeName;
        }

        @Override
        public final Builder volumeName(String volumeName) {
            this.volumeName = volumeName;
            return this;
        }

        public final List<ValidStorageOptions.Builder> getStorage() {
            List<ValidStorageOptions.Builder> result = ValidStorageOptionsListCopier.copyToBuilder(this.storage);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStorage(Collection<ValidStorageOptions.BuilderImpl> storage) {
            this.storage = ValidStorageOptionsListCopier.copyFromBuilder(storage);
        }

        @Override
        public final Builder storage(Collection<ValidStorageOptions> storage) {
            this.storage = ValidStorageOptionsListCopier.copy(storage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storage(ValidStorageOptions ... storage) {
            this.storage(Arrays.asList(storage));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storage(Consumer<ValidStorageOptions.Builder> ... storage) {
            this.storage(Stream.of(storage).map(c -> (ValidStorageOptions)((ValidStorageOptions.Builder)ValidStorageOptions.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ValidVolumeOptions build() {
            return new ValidVolumeOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ValidVolumeOptions> {
        public Builder volumeName(String var1);

        public Builder storage(Collection<ValidStorageOptions> var1);

        public Builder storage(ValidStorageOptions ... var1);

        public Builder storage(Consumer<ValidStorageOptions.Builder> ... var1);
    }
}

