/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.ReplicaMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RdsCustomClusterConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RdsCustomClusterConfiguration> {
    private static final SdkField<String> INTERCONNECT_SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InterconnectSubnetId").getter(RdsCustomClusterConfiguration.getter(RdsCustomClusterConfiguration::interconnectSubnetId)).setter(RdsCustomClusterConfiguration.setter(Builder::interconnectSubnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterconnectSubnetId").build()}).build();
    private static final SdkField<String> TRANSIT_GATEWAY_MULTICAST_DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransitGatewayMulticastDomainId").getter(RdsCustomClusterConfiguration.getter(RdsCustomClusterConfiguration::transitGatewayMulticastDomainId)).setter(RdsCustomClusterConfiguration.setter(Builder::transitGatewayMulticastDomainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayMulticastDomainId").build()}).build();
    private static final SdkField<String> REPLICA_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicaMode").getter(RdsCustomClusterConfiguration.getter(RdsCustomClusterConfiguration::replicaModeAsString)).setter(RdsCustomClusterConfiguration.setter(Builder::replicaMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaMode").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERCONNECT_SUBNET_ID_FIELD, TRANSIT_GATEWAY_MULTICAST_DOMAIN_ID_FIELD, REPLICA_MODE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RdsCustomClusterConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String interconnectSubnetId;
    private final String transitGatewayMulticastDomainId;
    private final String replicaMode;

    private RdsCustomClusterConfiguration(BuilderImpl builder) {
        this.interconnectSubnetId = builder.interconnectSubnetId;
        this.transitGatewayMulticastDomainId = builder.transitGatewayMulticastDomainId;
        this.replicaMode = builder.replicaMode;
    }

    public final String interconnectSubnetId() {
        return this.interconnectSubnetId;
    }

    public final String transitGatewayMulticastDomainId() {
        return this.transitGatewayMulticastDomainId;
    }

    public final ReplicaMode replicaMode() {
        return ReplicaMode.fromValue(this.replicaMode);
    }

    public final String replicaModeAsString() {
        return this.replicaMode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.interconnectSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transitGatewayMulticastDomainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaModeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RdsCustomClusterConfiguration)) {
            return false;
        }
        RdsCustomClusterConfiguration other = (RdsCustomClusterConfiguration)obj;
        return Objects.equals(this.interconnectSubnetId(), other.interconnectSubnetId()) && Objects.equals(this.transitGatewayMulticastDomainId(), other.transitGatewayMulticastDomainId()) && Objects.equals(this.replicaModeAsString(), other.replicaModeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RdsCustomClusterConfiguration").add("InterconnectSubnetId", (Object)this.interconnectSubnetId()).add("TransitGatewayMulticastDomainId", (Object)this.transitGatewayMulticastDomainId()).add("ReplicaMode", (Object)this.replicaModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InterconnectSubnetId": {
                return Optional.ofNullable(clazz.cast(this.interconnectSubnetId()));
            }
            case "TransitGatewayMulticastDomainId": {
                return Optional.ofNullable(clazz.cast(this.transitGatewayMulticastDomainId()));
            }
            case "ReplicaMode": {
                return Optional.ofNullable(clazz.cast(this.replicaModeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("InterconnectSubnetId", INTERCONNECT_SUBNET_ID_FIELD);
        map.put("TransitGatewayMulticastDomainId", TRANSIT_GATEWAY_MULTICAST_DOMAIN_ID_FIELD);
        map.put("ReplicaMode", REPLICA_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RdsCustomClusterConfiguration, T> g) {
        return obj -> g.apply((RdsCustomClusterConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String interconnectSubnetId;
        private String transitGatewayMulticastDomainId;
        private String replicaMode;

        private BuilderImpl() {
        }

        private BuilderImpl(RdsCustomClusterConfiguration model) {
            this.interconnectSubnetId(model.interconnectSubnetId);
            this.transitGatewayMulticastDomainId(model.transitGatewayMulticastDomainId);
            this.replicaMode(model.replicaMode);
        }

        public final String getInterconnectSubnetId() {
            return this.interconnectSubnetId;
        }

        public final void setInterconnectSubnetId(String interconnectSubnetId) {
            this.interconnectSubnetId = interconnectSubnetId;
        }

        @Override
        public final Builder interconnectSubnetId(String interconnectSubnetId) {
            this.interconnectSubnetId = interconnectSubnetId;
            return this;
        }

        public final String getTransitGatewayMulticastDomainId() {
            return this.transitGatewayMulticastDomainId;
        }

        public final void setTransitGatewayMulticastDomainId(String transitGatewayMulticastDomainId) {
            this.transitGatewayMulticastDomainId = transitGatewayMulticastDomainId;
        }

        @Override
        public final Builder transitGatewayMulticastDomainId(String transitGatewayMulticastDomainId) {
            this.transitGatewayMulticastDomainId = transitGatewayMulticastDomainId;
            return this;
        }

        public final String getReplicaMode() {
            return this.replicaMode;
        }

        public final void setReplicaMode(String replicaMode) {
            this.replicaMode = replicaMode;
        }

        @Override
        public final Builder replicaMode(String replicaMode) {
            this.replicaMode = replicaMode;
            return this;
        }

        @Override
        public final Builder replicaMode(ReplicaMode replicaMode) {
            this.replicaMode(replicaMode == null ? null : replicaMode.toString());
            return this;
        }

        public RdsCustomClusterConfiguration build() {
            return new RdsCustomClusterConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RdsCustomClusterConfiguration> {
        public Builder interconnectSubnetId(String var1);

        public Builder transitGatewayMulticastDomainId(String var1);

        public Builder replicaMode(String var1);

        public Builder replicaMode(ReplicaMode var1);
    }
}

