/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.internal.UserAgentUtils;
import software.amazon.awssdk.services.rds.model.DBMajorEngineVersion;
import software.amazon.awssdk.services.rds.model.DescribeDbMajorEngineVersionsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbMajorEngineVersionsResponse;

public class DescribeDBMajorEngineVersionsIterable
implements SdkIterable<DescribeDbMajorEngineVersionsResponse> {
    private final RdsClient client;
    private final DescribeDbMajorEngineVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeDBMajorEngineVersionsIterable(RdsClient client, DescribeDbMajorEngineVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeDbMajorEngineVersionsResponseFetcher();
    }

    public Iterator<DescribeDbMajorEngineVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DBMajorEngineVersion> dbMajorEngineVersions() {
        Function<DescribeDbMajorEngineVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbMajorEngineVersions() != null) {
                return response.dbMajorEngineVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeDbMajorEngineVersionsResponseFetcher
    implements SyncPageFetcher<DescribeDbMajorEngineVersionsResponse> {
        private DescribeDbMajorEngineVersionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDbMajorEngineVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeDbMajorEngineVersionsResponse nextPage(DescribeDbMajorEngineVersionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeDBMajorEngineVersionsIterable.this.client.describeDBMajorEngineVersions(DescribeDBMajorEngineVersionsIterable.this.firstRequest);
            }
            return DescribeDBMajorEngineVersionsIterable.this.client.describeDBMajorEngineVersions((DescribeDbMajorEngineVersionsRequest)((Object)DescribeDBMajorEngineVersionsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

