/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.LifecycleSupportName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SupportedEngineLifecycle
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SupportedEngineLifecycle> {
    private static final SdkField<String> LIFECYCLE_SUPPORT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LifecycleSupportName").getter(SupportedEngineLifecycle.getter(SupportedEngineLifecycle::lifecycleSupportNameAsString)).setter(SupportedEngineLifecycle.setter(Builder::lifecycleSupportName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleSupportName").build()}).build();
    private static final SdkField<Instant> LIFECYCLE_SUPPORT_START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LifecycleSupportStartDate").getter(SupportedEngineLifecycle.getter(SupportedEngineLifecycle::lifecycleSupportStartDate)).setter(SupportedEngineLifecycle.setter(Builder::lifecycleSupportStartDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleSupportStartDate").build()}).build();
    private static final SdkField<Instant> LIFECYCLE_SUPPORT_END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LifecycleSupportEndDate").getter(SupportedEngineLifecycle.getter(SupportedEngineLifecycle::lifecycleSupportEndDate)).setter(SupportedEngineLifecycle.setter(Builder::lifecycleSupportEndDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleSupportEndDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_SUPPORT_NAME_FIELD, LIFECYCLE_SUPPORT_START_DATE_FIELD, LIFECYCLE_SUPPORT_END_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SupportedEngineLifecycle.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String lifecycleSupportName;
    private final Instant lifecycleSupportStartDate;
    private final Instant lifecycleSupportEndDate;

    private SupportedEngineLifecycle(BuilderImpl builder) {
        this.lifecycleSupportName = builder.lifecycleSupportName;
        this.lifecycleSupportStartDate = builder.lifecycleSupportStartDate;
        this.lifecycleSupportEndDate = builder.lifecycleSupportEndDate;
    }

    public final LifecycleSupportName lifecycleSupportName() {
        return LifecycleSupportName.fromValue(this.lifecycleSupportName);
    }

    public final String lifecycleSupportNameAsString() {
        return this.lifecycleSupportName;
    }

    public final Instant lifecycleSupportStartDate() {
        return this.lifecycleSupportStartDate;
    }

    public final Instant lifecycleSupportEndDate() {
        return this.lifecycleSupportEndDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleSupportNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleSupportStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleSupportEndDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SupportedEngineLifecycle)) {
            return false;
        }
        SupportedEngineLifecycle other = (SupportedEngineLifecycle)obj;
        return Objects.equals(this.lifecycleSupportNameAsString(), other.lifecycleSupportNameAsString()) && Objects.equals(this.lifecycleSupportStartDate(), other.lifecycleSupportStartDate()) && Objects.equals(this.lifecycleSupportEndDate(), other.lifecycleSupportEndDate());
    }

    public final String toString() {
        return ToString.builder((String)"SupportedEngineLifecycle").add("LifecycleSupportName", (Object)this.lifecycleSupportNameAsString()).add("LifecycleSupportStartDate", (Object)this.lifecycleSupportStartDate()).add("LifecycleSupportEndDate", (Object)this.lifecycleSupportEndDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LifecycleSupportName": {
                return Optional.ofNullable(clazz.cast(this.lifecycleSupportNameAsString()));
            }
            case "LifecycleSupportStartDate": {
                return Optional.ofNullable(clazz.cast(this.lifecycleSupportStartDate()));
            }
            case "LifecycleSupportEndDate": {
                return Optional.ofNullable(clazz.cast(this.lifecycleSupportEndDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LifecycleSupportName", LIFECYCLE_SUPPORT_NAME_FIELD);
        map.put("LifecycleSupportStartDate", LIFECYCLE_SUPPORT_START_DATE_FIELD);
        map.put("LifecycleSupportEndDate", LIFECYCLE_SUPPORT_END_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SupportedEngineLifecycle, T> g) {
        return obj -> g.apply((SupportedEngineLifecycle)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String lifecycleSupportName;
        private Instant lifecycleSupportStartDate;
        private Instant lifecycleSupportEndDate;

        private BuilderImpl() {
        }

        private BuilderImpl(SupportedEngineLifecycle model) {
            this.lifecycleSupportName(model.lifecycleSupportName);
            this.lifecycleSupportStartDate(model.lifecycleSupportStartDate);
            this.lifecycleSupportEndDate(model.lifecycleSupportEndDate);
        }

        public final String getLifecycleSupportName() {
            return this.lifecycleSupportName;
        }

        public final void setLifecycleSupportName(String lifecycleSupportName) {
            this.lifecycleSupportName = lifecycleSupportName;
        }

        @Override
        public final Builder lifecycleSupportName(String lifecycleSupportName) {
            this.lifecycleSupportName = lifecycleSupportName;
            return this;
        }

        @Override
        public final Builder lifecycleSupportName(LifecycleSupportName lifecycleSupportName) {
            this.lifecycleSupportName(lifecycleSupportName == null ? null : lifecycleSupportName.toString());
            return this;
        }

        public final Instant getLifecycleSupportStartDate() {
            return this.lifecycleSupportStartDate;
        }

        public final void setLifecycleSupportStartDate(Instant lifecycleSupportStartDate) {
            this.lifecycleSupportStartDate = lifecycleSupportStartDate;
        }

        @Override
        public final Builder lifecycleSupportStartDate(Instant lifecycleSupportStartDate) {
            this.lifecycleSupportStartDate = lifecycleSupportStartDate;
            return this;
        }

        public final Instant getLifecycleSupportEndDate() {
            return this.lifecycleSupportEndDate;
        }

        public final void setLifecycleSupportEndDate(Instant lifecycleSupportEndDate) {
            this.lifecycleSupportEndDate = lifecycleSupportEndDate;
        }

        @Override
        public final Builder lifecycleSupportEndDate(Instant lifecycleSupportEndDate) {
            this.lifecycleSupportEndDate = lifecycleSupportEndDate;
            return this;
        }

        public SupportedEngineLifecycle build() {
            return new SupportedEngineLifecycle(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SupportedEngineLifecycle> {
        public Builder lifecycleSupportName(String var1);

        public Builder lifecycleSupportName(LifecycleSupportName var1);

        public Builder lifecycleSupportStartDate(Instant var1);

        public Builder lifecycleSupportEndDate(Instant var1);
    }
}

