/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DBProxyEndpoint;
import software.amazon.awssdk.services.rds.model.DBProxyEndpointListCopier;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDbProxyEndpointsResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeDbProxyEndpointsResponse> {
    private static final SdkField<List<DBProxyEndpoint>> DB_PROXY_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DBProxyEndpoints").getter(DescribeDbProxyEndpointsResponse.getter(DescribeDbProxyEndpointsResponse::dbProxyEndpoints)).setter(DescribeDbProxyEndpointsResponse.setter(Builder::dbProxyEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBProxyEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBProxyEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeDbProxyEndpointsResponse.getter(DescribeDbProxyEndpointsResponse::marker)).setter(DescribeDbProxyEndpointsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_PROXY_ENDPOINTS_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeDbProxyEndpointsResponse.memberNameToFieldInitializer();
    private final List<DBProxyEndpoint> dbProxyEndpoints;
    private final String marker;

    private DescribeDbProxyEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.dbProxyEndpoints = builder.dbProxyEndpoints;
        this.marker = builder.marker;
    }

    public final boolean hasDbProxyEndpoints() {
        return this.dbProxyEndpoints != null && !(this.dbProxyEndpoints instanceof SdkAutoConstructList);
    }

    public final List<DBProxyEndpoint> dbProxyEndpoints() {
        return this.dbProxyEndpoints;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbProxyEndpoints() ? this.dbProxyEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbProxyEndpointsResponse)) {
            return false;
        }
        DescribeDbProxyEndpointsResponse other = (DescribeDbProxyEndpointsResponse)((Object)obj);
        return this.hasDbProxyEndpoints() == other.hasDbProxyEndpoints() && Objects.equals(this.dbProxyEndpoints(), other.dbProxyEndpoints()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDbProxyEndpointsResponse").add("DBProxyEndpoints", this.hasDbProxyEndpoints() ? this.dbProxyEndpoints() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBProxyEndpoints": {
                return Optional.ofNullable(clazz.cast(this.dbProxyEndpoints()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DBProxyEndpoints", DB_PROXY_ENDPOINTS_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbProxyEndpointsResponse, T> g) {
        return obj -> g.apply((DescribeDbProxyEndpointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private List<DBProxyEndpoint> dbProxyEndpoints = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbProxyEndpointsResponse model) {
            super(model);
            this.dbProxyEndpoints(model.dbProxyEndpoints);
            this.marker(model.marker);
        }

        public final List<DBProxyEndpoint.Builder> getDbProxyEndpoints() {
            List<DBProxyEndpoint.Builder> result = DBProxyEndpointListCopier.copyToBuilder(this.dbProxyEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbProxyEndpoints(Collection<DBProxyEndpoint.BuilderImpl> dbProxyEndpoints) {
            this.dbProxyEndpoints = DBProxyEndpointListCopier.copyFromBuilder(dbProxyEndpoints);
        }

        @Override
        public final Builder dbProxyEndpoints(Collection<DBProxyEndpoint> dbProxyEndpoints) {
            this.dbProxyEndpoints = DBProxyEndpointListCopier.copy(dbProxyEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbProxyEndpoints(DBProxyEndpoint ... dbProxyEndpoints) {
            this.dbProxyEndpoints(Arrays.asList(dbProxyEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbProxyEndpoints(Consumer<DBProxyEndpoint.Builder> ... dbProxyEndpoints) {
            this.dbProxyEndpoints(Stream.of(dbProxyEndpoints).map(c -> (DBProxyEndpoint)((DBProxyEndpoint.Builder)DBProxyEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeDbProxyEndpointsResponse build() {
            return new DescribeDbProxyEndpointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDbProxyEndpointsResponse> {
        public Builder dbProxyEndpoints(Collection<DBProxyEndpoint> var1);

        public Builder dbProxyEndpoints(DBProxyEndpoint ... var1);

        public Builder dbProxyEndpoints(Consumer<DBProxyEndpoint.Builder> ... var1);

        public Builder marker(String var1);
    }
}

