/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.internal.UserAgentUtils;
import software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesRequest;
import software.amazon.awssdk.services.rds.model.DescribeReservedDbInstancesResponse;
import software.amazon.awssdk.services.rds.model.ReservedDBInstance;

public class DescribeReservedDBInstancesIterable
implements SdkIterable<DescribeReservedDbInstancesResponse> {
    private final RdsClient client;
    private final DescribeReservedDbInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeReservedDBInstancesIterable(RdsClient client, DescribeReservedDbInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeReservedDbInstancesResponseFetcher();
    }

    public Iterator<DescribeReservedDbInstancesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReservedDBInstance> reservedDBInstances() {
        Function<DescribeReservedDbInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedDBInstances() != null) {
                return response.reservedDBInstances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeReservedDbInstancesResponseFetcher
    implements SyncPageFetcher<DescribeReservedDbInstancesResponse> {
        private DescribeReservedDbInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedDbInstancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeReservedDbInstancesResponse nextPage(DescribeReservedDbInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedDBInstancesIterable.this.client.describeReservedDBInstances(DescribeReservedDBInstancesIterable.this.firstRequest);
            }
            return DescribeReservedDBInstancesIterable.this.client.describeReservedDBInstances((DescribeReservedDbInstancesRequest)((Object)DescribeReservedDBInstancesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

