/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DBProxyEndpointTargetRole;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.model.StringListCopier;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDbProxyEndpointRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, CreateDbProxyEndpointRequest> {
    private static final SdkField<String> DB_PROXY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBProxyName").getter(CreateDbProxyEndpointRequest.getter(CreateDbProxyEndpointRequest::dbProxyName)).setter(CreateDbProxyEndpointRequest.setter(Builder::dbProxyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBProxyName").build()}).build();
    private static final SdkField<String> DB_PROXY_ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBProxyEndpointName").getter(CreateDbProxyEndpointRequest.getter(CreateDbProxyEndpointRequest::dbProxyEndpointName)).setter(CreateDbProxyEndpointRequest.setter(Builder::dbProxyEndpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBProxyEndpointName").build()}).build();
    private static final SdkField<List<String>> VPC_SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSubnetIds").getter(CreateDbProxyEndpointRequest.getter(CreateDbProxyEndpointRequest::vpcSubnetIds)).setter(CreateDbProxyEndpointRequest.setter(Builder::vpcSubnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSubnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSecurityGroupIds").getter(CreateDbProxyEndpointRequest.getter(CreateDbProxyEndpointRequest::vpcSecurityGroupIds)).setter(CreateDbProxyEndpointRequest.setter(Builder::vpcSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TARGET_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetRole").getter(CreateDbProxyEndpointRequest.getter(CreateDbProxyEndpointRequest::targetRoleAsString)).setter(CreateDbProxyEndpointRequest.setter(Builder::targetRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetRole").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateDbProxyEndpointRequest.getter(CreateDbProxyEndpointRequest::tags)).setter(CreateDbProxyEndpointRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_PROXY_NAME_FIELD, DB_PROXY_ENDPOINT_NAME_FIELD, VPC_SUBNET_IDS_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, TARGET_ROLE_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDbProxyEndpointRequest.memberNameToFieldInitializer();
    private final String dbProxyName;
    private final String dbProxyEndpointName;
    private final List<String> vpcSubnetIds;
    private final List<String> vpcSecurityGroupIds;
    private final String targetRole;
    private final List<Tag> tags;

    private CreateDbProxyEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.dbProxyName = builder.dbProxyName;
        this.dbProxyEndpointName = builder.dbProxyEndpointName;
        this.vpcSubnetIds = builder.vpcSubnetIds;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.targetRole = builder.targetRole;
        this.tags = builder.tags;
    }

    public final String dbProxyName() {
        return this.dbProxyName;
    }

    public final String dbProxyEndpointName() {
        return this.dbProxyEndpointName;
    }

    public final boolean hasVpcSubnetIds() {
        return this.vpcSubnetIds != null && !(this.vpcSubnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcSubnetIds() {
        return this.vpcSubnetIds;
    }

    public final boolean hasVpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds != null && !(this.vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public final DBProxyEndpointTargetRole targetRole() {
        return DBProxyEndpointTargetRole.fromValue(this.targetRole);
    }

    public final String targetRoleAsString() {
        return this.targetRole;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbProxyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbProxyEndpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSubnetIds() ? this.vpcSubnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDbProxyEndpointRequest)) {
            return false;
        }
        CreateDbProxyEndpointRequest other = (CreateDbProxyEndpointRequest)((Object)obj);
        return Objects.equals(this.dbProxyName(), other.dbProxyName()) && Objects.equals(this.dbProxyEndpointName(), other.dbProxyEndpointName()) && this.hasVpcSubnetIds() == other.hasVpcSubnetIds() && Objects.equals(this.vpcSubnetIds(), other.vpcSubnetIds()) && this.hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds() && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && Objects.equals(this.targetRoleAsString(), other.targetRoleAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDbProxyEndpointRequest").add("DBProxyName", (Object)this.dbProxyName()).add("DBProxyEndpointName", (Object)this.dbProxyEndpointName()).add("VpcSubnetIds", this.hasVpcSubnetIds() ? this.vpcSubnetIds() : null).add("VpcSecurityGroupIds", this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null).add("TargetRole", (Object)this.targetRoleAsString()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBProxyName": {
                return Optional.ofNullable(clazz.cast(this.dbProxyName()));
            }
            case "DBProxyEndpointName": {
                return Optional.ofNullable(clazz.cast(this.dbProxyEndpointName()));
            }
            case "VpcSubnetIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSubnetIds()));
            }
            case "VpcSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroupIds()));
            }
            case "TargetRole": {
                return Optional.ofNullable(clazz.cast(this.targetRoleAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DBProxyName", DB_PROXY_NAME_FIELD);
        map.put("DBProxyEndpointName", DB_PROXY_ENDPOINT_NAME_FIELD);
        map.put("VpcSubnetIds", VPC_SUBNET_IDS_FIELD);
        map.put("VpcSecurityGroupIds", VPC_SECURITY_GROUP_IDS_FIELD);
        map.put("TargetRole", TARGET_ROLE_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDbProxyEndpointRequest, T> g) {
        return obj -> g.apply((CreateDbProxyEndpointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbProxyName;
        private String dbProxyEndpointName;
        private List<String> vpcSubnetIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String targetRole;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDbProxyEndpointRequest model) {
            super(model);
            this.dbProxyName(model.dbProxyName);
            this.dbProxyEndpointName(model.dbProxyEndpointName);
            this.vpcSubnetIds(model.vpcSubnetIds);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.targetRole(model.targetRole);
            this.tags(model.tags);
        }

        public final String getDbProxyName() {
            return this.dbProxyName;
        }

        public final void setDbProxyName(String dbProxyName) {
            this.dbProxyName = dbProxyName;
        }

        @Override
        public final Builder dbProxyName(String dbProxyName) {
            this.dbProxyName = dbProxyName;
            return this;
        }

        public final String getDbProxyEndpointName() {
            return this.dbProxyEndpointName;
        }

        public final void setDbProxyEndpointName(String dbProxyEndpointName) {
            this.dbProxyEndpointName = dbProxyEndpointName;
        }

        @Override
        public final Builder dbProxyEndpointName(String dbProxyEndpointName) {
            this.dbProxyEndpointName = dbProxyEndpointName;
            return this;
        }

        public final Collection<String> getVpcSubnetIds() {
            if (this.vpcSubnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcSubnetIds;
        }

        public final void setVpcSubnetIds(Collection<String> vpcSubnetIds) {
            this.vpcSubnetIds = StringListCopier.copy(vpcSubnetIds);
        }

        @Override
        public final Builder vpcSubnetIds(Collection<String> vpcSubnetIds) {
            this.vpcSubnetIds = StringListCopier.copy(vpcSubnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSubnetIds(String ... vpcSubnetIds) {
            this.vpcSubnetIds(Arrays.asList(vpcSubnetIds));
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (this.vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final String getTargetRole() {
            return this.targetRole;
        }

        public final void setTargetRole(String targetRole) {
            this.targetRole = targetRole;
        }

        @Override
        public final Builder targetRole(String targetRole) {
            this.targetRole = targetRole;
            return this;
        }

        @Override
        public final Builder targetRole(DBProxyEndpointTargetRole targetRole) {
            this.targetRole(targetRole == null ? null : targetRole.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDbProxyEndpointRequest build() {
            return new CreateDbProxyEndpointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDbProxyEndpointRequest> {
        public Builder dbProxyName(String var1);

        public Builder dbProxyEndpointName(String var1);

        public Builder vpcSubnetIds(Collection<String> var1);

        public Builder vpcSubnetIds(String ... var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder targetRole(String var1);

        public Builder targetRole(DBProxyEndpointTargetRole var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

