/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.ActivityStreamMode;
import software.amazon.awssdk.services.rds.model.ActivityStreamPolicyStatus;
import software.amazon.awssdk.services.rds.model.ActivityStreamStatus;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyActivityStreamResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, ModifyActivityStreamResponse> {
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(ModifyActivityStreamResponse.getter(ModifyActivityStreamResponse::kmsKeyId)).setter(ModifyActivityStreamResponse.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> KINESIS_STREAM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KinesisStreamName").getter(ModifyActivityStreamResponse.getter(ModifyActivityStreamResponse::kinesisStreamName)).setter(ModifyActivityStreamResponse.setter(Builder::kinesisStreamName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ModifyActivityStreamResponse.getter(ModifyActivityStreamResponse::statusAsString)).setter(ModifyActivityStreamResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(ModifyActivityStreamResponse.getter(ModifyActivityStreamResponse::modeAsString)).setter(ModifyActivityStreamResponse.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final SdkField<Boolean> ENGINE_NATIVE_AUDIT_FIELDS_INCLUDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EngineNativeAuditFieldsIncluded").getter(ModifyActivityStreamResponse.getter(ModifyActivityStreamResponse::engineNativeAuditFieldsIncluded)).setter(ModifyActivityStreamResponse.setter(Builder::engineNativeAuditFieldsIncluded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineNativeAuditFieldsIncluded").build()}).build();
    private static final SdkField<String> POLICY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PolicyStatus").getter(ModifyActivityStreamResponse.getter(ModifyActivityStreamResponse::policyStatusAsString)).setter(ModifyActivityStreamResponse.setter(Builder::policyStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_KEY_ID_FIELD, KINESIS_STREAM_NAME_FIELD, STATUS_FIELD, MODE_FIELD, ENGINE_NATIVE_AUDIT_FIELDS_INCLUDED_FIELD, POLICY_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("KmsKeyId", KMS_KEY_ID_FIELD);
            this.put("KinesisStreamName", KINESIS_STREAM_NAME_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("Mode", MODE_FIELD);
            this.put("EngineNativeAuditFieldsIncluded", ENGINE_NATIVE_AUDIT_FIELDS_INCLUDED_FIELD);
            this.put("PolicyStatus", POLICY_STATUS_FIELD);
        }
    });
    private final String kmsKeyId;
    private final String kinesisStreamName;
    private final String status;
    private final String mode;
    private final Boolean engineNativeAuditFieldsIncluded;
    private final String policyStatus;

    private ModifyActivityStreamResponse(BuilderImpl builder) {
        super(builder);
        this.kmsKeyId = builder.kmsKeyId;
        this.kinesisStreamName = builder.kinesisStreamName;
        this.status = builder.status;
        this.mode = builder.mode;
        this.engineNativeAuditFieldsIncluded = builder.engineNativeAuditFieldsIncluded;
        this.policyStatus = builder.policyStatus;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String kinesisStreamName() {
        return this.kinesisStreamName;
    }

    public final ActivityStreamStatus status() {
        return ActivityStreamStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final ActivityStreamMode mode() {
        return ActivityStreamMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final Boolean engineNativeAuditFieldsIncluded() {
        return this.engineNativeAuditFieldsIncluded;
    }

    public final ActivityStreamPolicyStatus policyStatus() {
        return ActivityStreamPolicyStatus.fromValue(this.policyStatus);
    }

    public final String policyStatusAsString() {
        return this.policyStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineNativeAuditFieldsIncluded());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyActivityStreamResponse)) {
            return false;
        }
        ModifyActivityStreamResponse other = (ModifyActivityStreamResponse)((Object)obj);
        return Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.kinesisStreamName(), other.kinesisStreamName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.engineNativeAuditFieldsIncluded(), other.engineNativeAuditFieldsIncluded()) && Objects.equals(this.policyStatusAsString(), other.policyStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyActivityStreamResponse").add("KmsKeyId", (Object)this.kmsKeyId()).add("KinesisStreamName", (Object)this.kinesisStreamName()).add("Status", (Object)this.statusAsString()).add("Mode", (Object)this.modeAsString()).add("EngineNativeAuditFieldsIncluded", (Object)this.engineNativeAuditFieldsIncluded()).add("PolicyStatus", (Object)this.policyStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "KinesisStreamName": {
                return Optional.ofNullable(clazz.cast(this.kinesisStreamName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "EngineNativeAuditFieldsIncluded": {
                return Optional.ofNullable(clazz.cast(this.engineNativeAuditFieldsIncluded()));
            }
            case "PolicyStatus": {
                return Optional.ofNullable(clazz.cast(this.policyStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModifyActivityStreamResponse, T> g) {
        return obj -> g.apply((ModifyActivityStreamResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private String kmsKeyId;
        private String kinesisStreamName;
        private String status;
        private String mode;
        private Boolean engineNativeAuditFieldsIncluded;
        private String policyStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyActivityStreamResponse model) {
            super(model);
            this.kmsKeyId(model.kmsKeyId);
            this.kinesisStreamName(model.kinesisStreamName);
            this.status(model.status);
            this.mode(model.mode);
            this.engineNativeAuditFieldsIncluded(model.engineNativeAuditFieldsIncluded);
            this.policyStatus(model.policyStatus);
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getKinesisStreamName() {
            return this.kinesisStreamName;
        }

        public final void setKinesisStreamName(String kinesisStreamName) {
            this.kinesisStreamName = kinesisStreamName;
        }

        @Override
        public final Builder kinesisStreamName(String kinesisStreamName) {
            this.kinesisStreamName = kinesisStreamName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ActivityStreamStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ActivityStreamMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final Boolean getEngineNativeAuditFieldsIncluded() {
            return this.engineNativeAuditFieldsIncluded;
        }

        public final void setEngineNativeAuditFieldsIncluded(Boolean engineNativeAuditFieldsIncluded) {
            this.engineNativeAuditFieldsIncluded = engineNativeAuditFieldsIncluded;
        }

        @Override
        public final Builder engineNativeAuditFieldsIncluded(Boolean engineNativeAuditFieldsIncluded) {
            this.engineNativeAuditFieldsIncluded = engineNativeAuditFieldsIncluded;
            return this;
        }

        public final String getPolicyStatus() {
            return this.policyStatus;
        }

        public final void setPolicyStatus(String policyStatus) {
            this.policyStatus = policyStatus;
        }

        @Override
        public final Builder policyStatus(String policyStatus) {
            this.policyStatus = policyStatus;
            return this;
        }

        @Override
        public final Builder policyStatus(ActivityStreamPolicyStatus policyStatus) {
            this.policyStatus(policyStatus == null ? null : policyStatus.toString());
            return this;
        }

        @Override
        public ModifyActivityStreamResponse build() {
            return new ModifyActivityStreamResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyActivityStreamResponse> {
        public Builder kmsKeyId(String var1);

        public Builder kinesisStreamName(String var1);

        public Builder status(String var1);

        public Builder status(ActivityStreamStatus var1);

        public Builder mode(String var1);

        public Builder mode(ActivityStreamMode var1);

        public Builder engineNativeAuditFieldsIncluded(Boolean var1);

        public Builder policyStatus(String var1);

        public Builder policyStatus(ActivityStreamPolicyStatus var1);
    }
}

