/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.Option;
import software.amazon.awssdk.services.rds.model.OptionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OptionGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OptionGroup> {
    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptionGroupName").getter(OptionGroup.getter(OptionGroup::optionGroupName)).setter(OptionGroup.setter(Builder::optionGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()}).build();
    private static final SdkField<String> OPTION_GROUP_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptionGroupDescription").getter(OptionGroup.getter(OptionGroup::optionGroupDescription)).setter(OptionGroup.setter(Builder::optionGroupDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupDescription").build()}).build();
    private static final SdkField<String> ENGINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineName").getter(OptionGroup.getter(OptionGroup::engineName)).setter(OptionGroup.setter(Builder::engineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineName").build()}).build();
    private static final SdkField<String> MAJOR_ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MajorEngineVersion").getter(OptionGroup.getter(OptionGroup::majorEngineVersion)).setter(OptionGroup.setter(Builder::majorEngineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MajorEngineVersion").build()}).build();
    private static final SdkField<List<Option>> OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Options").getter(OptionGroup.getter(OptionGroup::options)).setter(OptionGroup.setter(Builder::options)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build(), ListTrait.builder().memberLocationName("Option").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Option::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Option").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ALLOWS_VPC_AND_NON_VPC_INSTANCE_MEMBERSHIPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowsVpcAndNonVpcInstanceMemberships").getter(OptionGroup.getter(OptionGroup::allowsVpcAndNonVpcInstanceMemberships)).setter(OptionGroup.setter(Builder::allowsVpcAndNonVpcInstanceMemberships)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowsVpcAndNonVpcInstanceMemberships").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(OptionGroup.getter(OptionGroup::vpcId)).setter(OptionGroup.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<String> OPTION_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptionGroupArn").getter(OptionGroup.getter(OptionGroup::optionGroupArn)).setter(OptionGroup.setter(Builder::optionGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupArn").build()}).build();
    private static final SdkField<String> SOURCE_OPTION_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceOptionGroup").getter(OptionGroup.getter(OptionGroup::sourceOptionGroup)).setter(OptionGroup.setter(Builder::sourceOptionGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceOptionGroup").build()}).build();
    private static final SdkField<String> SOURCE_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceAccountId").getter(OptionGroup.getter(OptionGroup::sourceAccountId)).setter(OptionGroup.setter(Builder::sourceAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAccountId").build()}).build();
    private static final SdkField<Instant> COPY_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CopyTimestamp").getter(OptionGroup.getter(OptionGroup::copyTimestamp)).setter(OptionGroup.setter(Builder::copyTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTION_GROUP_NAME_FIELD, OPTION_GROUP_DESCRIPTION_FIELD, ENGINE_NAME_FIELD, MAJOR_ENGINE_VERSION_FIELD, OPTIONS_FIELD, ALLOWS_VPC_AND_NON_VPC_INSTANCE_MEMBERSHIPS_FIELD, VPC_ID_FIELD, OPTION_GROUP_ARN_FIELD, SOURCE_OPTION_GROUP_FIELD, SOURCE_ACCOUNT_ID_FIELD, COPY_TIMESTAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("OptionGroupName", OPTION_GROUP_NAME_FIELD);
            this.put("OptionGroupDescription", OPTION_GROUP_DESCRIPTION_FIELD);
            this.put("EngineName", ENGINE_NAME_FIELD);
            this.put("MajorEngineVersion", MAJOR_ENGINE_VERSION_FIELD);
            this.put("Options", OPTIONS_FIELD);
            this.put("AllowsVpcAndNonVpcInstanceMemberships", ALLOWS_VPC_AND_NON_VPC_INSTANCE_MEMBERSHIPS_FIELD);
            this.put("VpcId", VPC_ID_FIELD);
            this.put("OptionGroupArn", OPTION_GROUP_ARN_FIELD);
            this.put("SourceOptionGroup", SOURCE_OPTION_GROUP_FIELD);
            this.put("SourceAccountId", SOURCE_ACCOUNT_ID_FIELD);
            this.put("CopyTimestamp", COPY_TIMESTAMP_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String optionGroupName;
    private final String optionGroupDescription;
    private final String engineName;
    private final String majorEngineVersion;
    private final List<Option> options;
    private final Boolean allowsVpcAndNonVpcInstanceMemberships;
    private final String vpcId;
    private final String optionGroupArn;
    private final String sourceOptionGroup;
    private final String sourceAccountId;
    private final Instant copyTimestamp;

    private OptionGroup(BuilderImpl builder) {
        this.optionGroupName = builder.optionGroupName;
        this.optionGroupDescription = builder.optionGroupDescription;
        this.engineName = builder.engineName;
        this.majorEngineVersion = builder.majorEngineVersion;
        this.options = builder.options;
        this.allowsVpcAndNonVpcInstanceMemberships = builder.allowsVpcAndNonVpcInstanceMemberships;
        this.vpcId = builder.vpcId;
        this.optionGroupArn = builder.optionGroupArn;
        this.sourceOptionGroup = builder.sourceOptionGroup;
        this.sourceAccountId = builder.sourceAccountId;
        this.copyTimestamp = builder.copyTimestamp;
    }

    public final String optionGroupName() {
        return this.optionGroupName;
    }

    public final String optionGroupDescription() {
        return this.optionGroupDescription;
    }

    public final String engineName() {
        return this.engineName;
    }

    public final String majorEngineVersion() {
        return this.majorEngineVersion;
    }

    public final boolean hasOptions() {
        return this.options != null && !(this.options instanceof SdkAutoConstructList);
    }

    public final List<Option> options() {
        return this.options;
    }

    public final Boolean allowsVpcAndNonVpcInstanceMemberships() {
        return this.allowsVpcAndNonVpcInstanceMemberships;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String optionGroupArn() {
        return this.optionGroupArn;
    }

    public final String sourceOptionGroup() {
        return this.sourceOptionGroup;
    }

    public final String sourceAccountId() {
        return this.sourceAccountId;
    }

    public final Instant copyTimestamp() {
        return this.copyTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.majorEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptions() ? this.options() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.allowsVpcAndNonVpcInstanceMemberships());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceOptionGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptionGroup)) {
            return false;
        }
        OptionGroup other = (OptionGroup)obj;
        return Objects.equals(this.optionGroupName(), other.optionGroupName()) && Objects.equals(this.optionGroupDescription(), other.optionGroupDescription()) && Objects.equals(this.engineName(), other.engineName()) && Objects.equals(this.majorEngineVersion(), other.majorEngineVersion()) && this.hasOptions() == other.hasOptions() && Objects.equals(this.options(), other.options()) && Objects.equals(this.allowsVpcAndNonVpcInstanceMemberships(), other.allowsVpcAndNonVpcInstanceMemberships()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.optionGroupArn(), other.optionGroupArn()) && Objects.equals(this.sourceOptionGroup(), other.sourceOptionGroup()) && Objects.equals(this.sourceAccountId(), other.sourceAccountId()) && Objects.equals(this.copyTimestamp(), other.copyTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"OptionGroup").add("OptionGroupName", (Object)this.optionGroupName()).add("OptionGroupDescription", (Object)this.optionGroupDescription()).add("EngineName", (Object)this.engineName()).add("MajorEngineVersion", (Object)this.majorEngineVersion()).add("Options", this.hasOptions() ? this.options() : null).add("AllowsVpcAndNonVpcInstanceMemberships", (Object)this.allowsVpcAndNonVpcInstanceMemberships()).add("VpcId", (Object)this.vpcId()).add("OptionGroupArn", (Object)this.optionGroupArn()).add("SourceOptionGroup", (Object)this.sourceOptionGroup()).add("SourceAccountId", (Object)this.sourceAccountId()).add("CopyTimestamp", (Object)this.copyTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OptionGroupName": {
                return Optional.ofNullable(clazz.cast(this.optionGroupName()));
            }
            case "OptionGroupDescription": {
                return Optional.ofNullable(clazz.cast(this.optionGroupDescription()));
            }
            case "EngineName": {
                return Optional.ofNullable(clazz.cast(this.engineName()));
            }
            case "MajorEngineVersion": {
                return Optional.ofNullable(clazz.cast(this.majorEngineVersion()));
            }
            case "Options": {
                return Optional.ofNullable(clazz.cast(this.options()));
            }
            case "AllowsVpcAndNonVpcInstanceMemberships": {
                return Optional.ofNullable(clazz.cast(this.allowsVpcAndNonVpcInstanceMemberships()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "OptionGroupArn": {
                return Optional.ofNullable(clazz.cast(this.optionGroupArn()));
            }
            case "SourceOptionGroup": {
                return Optional.ofNullable(clazz.cast(this.sourceOptionGroup()));
            }
            case "SourceAccountId": {
                return Optional.ofNullable(clazz.cast(this.sourceAccountId()));
            }
            case "CopyTimestamp": {
                return Optional.ofNullable(clazz.cast(this.copyTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OptionGroup, T> g) {
        return obj -> g.apply((OptionGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String optionGroupName;
        private String optionGroupDescription;
        private String engineName;
        private String majorEngineVersion;
        private List<Option> options = DefaultSdkAutoConstructList.getInstance();
        private Boolean allowsVpcAndNonVpcInstanceMemberships;
        private String vpcId;
        private String optionGroupArn;
        private String sourceOptionGroup;
        private String sourceAccountId;
        private Instant copyTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(OptionGroup model) {
            this.optionGroupName(model.optionGroupName);
            this.optionGroupDescription(model.optionGroupDescription);
            this.engineName(model.engineName);
            this.majorEngineVersion(model.majorEngineVersion);
            this.options(model.options);
            this.allowsVpcAndNonVpcInstanceMemberships(model.allowsVpcAndNonVpcInstanceMemberships);
            this.vpcId(model.vpcId);
            this.optionGroupArn(model.optionGroupArn);
            this.sourceOptionGroup(model.sourceOptionGroup);
            this.sourceAccountId(model.sourceAccountId);
            this.copyTimestamp(model.copyTimestamp);
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final String getOptionGroupDescription() {
            return this.optionGroupDescription;
        }

        public final void setOptionGroupDescription(String optionGroupDescription) {
            this.optionGroupDescription = optionGroupDescription;
        }

        @Override
        public final Builder optionGroupDescription(String optionGroupDescription) {
            this.optionGroupDescription = optionGroupDescription;
            return this;
        }

        public final String getEngineName() {
            return this.engineName;
        }

        public final void setEngineName(String engineName) {
            this.engineName = engineName;
        }

        @Override
        public final Builder engineName(String engineName) {
            this.engineName = engineName;
            return this;
        }

        public final String getMajorEngineVersion() {
            return this.majorEngineVersion;
        }

        public final void setMajorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
        }

        @Override
        public final Builder majorEngineVersion(String majorEngineVersion) {
            this.majorEngineVersion = majorEngineVersion;
            return this;
        }

        public final List<Option.Builder> getOptions() {
            List<Option.Builder> result = OptionsListCopier.copyToBuilder(this.options);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptions(Collection<Option.BuilderImpl> options) {
            this.options = OptionsListCopier.copyFromBuilder(options);
        }

        @Override
        public final Builder options(Collection<Option> options) {
            this.options = OptionsListCopier.copy(options);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(Option ... options) {
            this.options(Arrays.asList(options));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder options(Consumer<Option.Builder> ... options) {
            this.options(Stream.of(options).map(c -> (Option)((Option.Builder)Option.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getAllowsVpcAndNonVpcInstanceMemberships() {
            return this.allowsVpcAndNonVpcInstanceMemberships;
        }

        public final void setAllowsVpcAndNonVpcInstanceMemberships(Boolean allowsVpcAndNonVpcInstanceMemberships) {
            this.allowsVpcAndNonVpcInstanceMemberships = allowsVpcAndNonVpcInstanceMemberships;
        }

        @Override
        public final Builder allowsVpcAndNonVpcInstanceMemberships(Boolean allowsVpcAndNonVpcInstanceMemberships) {
            this.allowsVpcAndNonVpcInstanceMemberships = allowsVpcAndNonVpcInstanceMemberships;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getOptionGroupArn() {
            return this.optionGroupArn;
        }

        public final void setOptionGroupArn(String optionGroupArn) {
            this.optionGroupArn = optionGroupArn;
        }

        @Override
        public final Builder optionGroupArn(String optionGroupArn) {
            this.optionGroupArn = optionGroupArn;
            return this;
        }

        public final String getSourceOptionGroup() {
            return this.sourceOptionGroup;
        }

        public final void setSourceOptionGroup(String sourceOptionGroup) {
            this.sourceOptionGroup = sourceOptionGroup;
        }

        @Override
        public final Builder sourceOptionGroup(String sourceOptionGroup) {
            this.sourceOptionGroup = sourceOptionGroup;
            return this;
        }

        public final String getSourceAccountId() {
            return this.sourceAccountId;
        }

        public final void setSourceAccountId(String sourceAccountId) {
            this.sourceAccountId = sourceAccountId;
        }

        @Override
        public final Builder sourceAccountId(String sourceAccountId) {
            this.sourceAccountId = sourceAccountId;
            return this;
        }

        public final Instant getCopyTimestamp() {
            return this.copyTimestamp;
        }

        public final void setCopyTimestamp(Instant copyTimestamp) {
            this.copyTimestamp = copyTimestamp;
        }

        @Override
        public final Builder copyTimestamp(Instant copyTimestamp) {
            this.copyTimestamp = copyTimestamp;
            return this;
        }

        public OptionGroup build() {
            return new OptionGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OptionGroup> {
        public Builder optionGroupName(String var1);

        public Builder optionGroupDescription(String var1);

        public Builder engineName(String var1);

        public Builder majorEngineVersion(String var1);

        public Builder options(Collection<Option> var1);

        public Builder options(Option ... var1);

        public Builder options(Consumer<Option.Builder> ... var1);

        public Builder allowsVpcAndNonVpcInstanceMemberships(Boolean var1);

        public Builder vpcId(String var1);

        public Builder optionGroupArn(String var1);

        public Builder sourceOptionGroup(String var1);

        public Builder sourceAccountId(String var1);

        public Builder copyTimestamp(Instant var1);
    }
}

