/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DBRecommendation;
import software.amazon.awssdk.services.rds.model.DBRecommendationListCopier;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDbRecommendationsResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DescribeDbRecommendationsResponse> {
    private static final SdkField<List<DBRecommendation>> DB_RECOMMENDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DBRecommendations").getter(DescribeDbRecommendationsResponse.getter(DescribeDbRecommendationsResponse::dbRecommendations)).setter(DescribeDbRecommendationsResponse.setter(Builder::dbRecommendations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBRecommendations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DBRecommendation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeDbRecommendationsResponse.getter(DescribeDbRecommendationsResponse::marker)).setter(DescribeDbRecommendationsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_RECOMMENDATIONS_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DBRecommendations", DB_RECOMMENDATIONS_FIELD);
            this.put("Marker", MARKER_FIELD);
        }
    });
    private final List<DBRecommendation> dbRecommendations;
    private final String marker;

    private DescribeDbRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.dbRecommendations = builder.dbRecommendations;
        this.marker = builder.marker;
    }

    public final boolean hasDbRecommendations() {
        return this.dbRecommendations != null && !(this.dbRecommendations instanceof SdkAutoConstructList);
    }

    public final List<DBRecommendation> dbRecommendations() {
        return this.dbRecommendations;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbRecommendations() ? this.dbRecommendations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbRecommendationsResponse)) {
            return false;
        }
        DescribeDbRecommendationsResponse other = (DescribeDbRecommendationsResponse)((Object)obj);
        return this.hasDbRecommendations() == other.hasDbRecommendations() && Objects.equals(this.dbRecommendations(), other.dbRecommendations()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDbRecommendationsResponse").add("DBRecommendations", this.hasDbRecommendations() ? this.dbRecommendations() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBRecommendations": {
                return Optional.ofNullable(clazz.cast(this.dbRecommendations()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbRecommendationsResponse, T> g) {
        return obj -> g.apply((DescribeDbRecommendationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private List<DBRecommendation> dbRecommendations = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbRecommendationsResponse model) {
            super(model);
            this.dbRecommendations(model.dbRecommendations);
            this.marker(model.marker);
        }

        public final List<DBRecommendation.Builder> getDbRecommendations() {
            List<DBRecommendation.Builder> result = DBRecommendationListCopier.copyToBuilder(this.dbRecommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbRecommendations(Collection<DBRecommendation.BuilderImpl> dbRecommendations) {
            this.dbRecommendations = DBRecommendationListCopier.copyFromBuilder(dbRecommendations);
        }

        @Override
        public final Builder dbRecommendations(Collection<DBRecommendation> dbRecommendations) {
            this.dbRecommendations = DBRecommendationListCopier.copy(dbRecommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbRecommendations(DBRecommendation ... dbRecommendations) {
            this.dbRecommendations(Arrays.asList(dbRecommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbRecommendations(Consumer<DBRecommendation.Builder> ... dbRecommendations) {
            this.dbRecommendations(Stream.of(dbRecommendations).map(c -> (DBRecommendation)((DBRecommendation.Builder)DBRecommendation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeDbRecommendationsResponse build() {
            return new DescribeDbRecommendationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDbRecommendationsResponse> {
        public Builder dbRecommendations(Collection<DBRecommendation> var1);

        public Builder dbRecommendations(DBRecommendation ... var1);

        public Builder dbRecommendations(Consumer<DBRecommendation.Builder> ... var1);

        public Builder marker(String var1);
    }
}

