/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDbShardGroupResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, CreateDbShardGroupResponse> {
    private static final SdkField<String> DB_SHARD_GROUP_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBShardGroupResourceId").getter(CreateDbShardGroupResponse.getter(CreateDbShardGroupResponse::dbShardGroupResourceId)).setter(CreateDbShardGroupResponse.setter(Builder::dbShardGroupResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBShardGroupResourceId").build()}).build();
    private static final SdkField<String> DB_SHARD_GROUP_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBShardGroupIdentifier").getter(CreateDbShardGroupResponse.getter(CreateDbShardGroupResponse::dbShardGroupIdentifier)).setter(CreateDbShardGroupResponse.setter(Builder::dbShardGroupIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBShardGroupIdentifier").build()}).build();
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterIdentifier").getter(CreateDbShardGroupResponse.getter(CreateDbShardGroupResponse::dbClusterIdentifier)).setter(CreateDbShardGroupResponse.setter(Builder::dbClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build()}).build();
    private static final SdkField<Double> MAX_ACU_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MaxACU").getter(CreateDbShardGroupResponse.getter(CreateDbShardGroupResponse::maxACU)).setter(CreateDbShardGroupResponse.setter(Builder::maxACU)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxACU").build()}).build();
    private static final SdkField<Double> MIN_ACU_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MinACU").getter(CreateDbShardGroupResponse.getter(CreateDbShardGroupResponse::minACU)).setter(CreateDbShardGroupResponse.setter(Builder::minACU)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinACU").build()}).build();
    private static final SdkField<Integer> COMPUTE_REDUNDANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ComputeRedundancy").getter(CreateDbShardGroupResponse.getter(CreateDbShardGroupResponse::computeRedundancy)).setter(CreateDbShardGroupResponse.setter(Builder::computeRedundancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeRedundancy").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CreateDbShardGroupResponse.getter(CreateDbShardGroupResponse::status)).setter(CreateDbShardGroupResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PubliclyAccessible").getter(CreateDbShardGroupResponse.getter(CreateDbShardGroupResponse::publiclyAccessible)).setter(CreateDbShardGroupResponse.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build()}).build();
    private static final SdkField<String> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Endpoint").getter(CreateDbShardGroupResponse.getter(CreateDbShardGroupResponse::endpoint)).setter(CreateDbShardGroupResponse.setter(Builder::endpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<String> DB_SHARD_GROUP_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBShardGroupArn").getter(CreateDbShardGroupResponse.getter(CreateDbShardGroupResponse::dbShardGroupArn)).setter(CreateDbShardGroupResponse.setter(Builder::dbShardGroupArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBShardGroupArn").build()}).build();
    private static final SdkField<List<Tag>> TAG_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagList").getter(CreateDbShardGroupResponse.getter(CreateDbShardGroupResponse::tagList)).setter(CreateDbShardGroupResponse.setter(Builder::tagList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagList").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_SHARD_GROUP_RESOURCE_ID_FIELD, DB_SHARD_GROUP_IDENTIFIER_FIELD, DB_CLUSTER_IDENTIFIER_FIELD, MAX_ACU_FIELD, MIN_ACU_FIELD, COMPUTE_REDUNDANCY_FIELD, STATUS_FIELD, PUBLICLY_ACCESSIBLE_FIELD, ENDPOINT_FIELD, DB_SHARD_GROUP_ARN_FIELD, TAG_LIST_FIELD));
    private final String dbShardGroupResourceId;
    private final String dbShardGroupIdentifier;
    private final String dbClusterIdentifier;
    private final Double maxACU;
    private final Double minACU;
    private final Integer computeRedundancy;
    private final String status;
    private final Boolean publiclyAccessible;
    private final String endpoint;
    private final String dbShardGroupArn;
    private final List<Tag> tagList;

    private CreateDbShardGroupResponse(BuilderImpl builder) {
        super(builder);
        this.dbShardGroupResourceId = builder.dbShardGroupResourceId;
        this.dbShardGroupIdentifier = builder.dbShardGroupIdentifier;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.maxACU = builder.maxACU;
        this.minACU = builder.minACU;
        this.computeRedundancy = builder.computeRedundancy;
        this.status = builder.status;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.endpoint = builder.endpoint;
        this.dbShardGroupArn = builder.dbShardGroupArn;
        this.tagList = builder.tagList;
    }

    public final String dbShardGroupResourceId() {
        return this.dbShardGroupResourceId;
    }

    public final String dbShardGroupIdentifier() {
        return this.dbShardGroupIdentifier;
    }

    public final String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public final Double maxACU() {
        return this.maxACU;
    }

    public final Double minACU() {
        return this.minACU;
    }

    public final Integer computeRedundancy() {
        return this.computeRedundancy;
    }

    public final String status() {
        return this.status;
    }

    public final Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public final String endpoint() {
        return this.endpoint;
    }

    public final String dbShardGroupArn() {
        return this.dbShardGroupArn;
    }

    public final boolean hasTagList() {
        return this.tagList != null && !(this.tagList instanceof SdkAutoConstructList);
    }

    public final List<Tag> tagList() {
        return this.tagList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbShardGroupResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbShardGroupIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxACU());
        hashCode = 31 * hashCode + Objects.hashCode(this.minACU());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeRedundancy());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbShardGroupArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagList() ? this.tagList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDbShardGroupResponse)) {
            return false;
        }
        CreateDbShardGroupResponse other = (CreateDbShardGroupResponse)((Object)obj);
        return Objects.equals(this.dbShardGroupResourceId(), other.dbShardGroupResourceId()) && Objects.equals(this.dbShardGroupIdentifier(), other.dbShardGroupIdentifier()) && Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.maxACU(), other.maxACU()) && Objects.equals(this.minACU(), other.minACU()) && Objects.equals(this.computeRedundancy(), other.computeRedundancy()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.dbShardGroupArn(), other.dbShardGroupArn()) && this.hasTagList() == other.hasTagList() && Objects.equals(this.tagList(), other.tagList());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDbShardGroupResponse").add("DBShardGroupResourceId", (Object)this.dbShardGroupResourceId()).add("DBShardGroupIdentifier", (Object)this.dbShardGroupIdentifier()).add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("MaxACU", (Object)this.maxACU()).add("MinACU", (Object)this.minACU()).add("ComputeRedundancy", (Object)this.computeRedundancy()).add("Status", (Object)this.status()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("Endpoint", (Object)this.endpoint()).add("DBShardGroupArn", (Object)this.dbShardGroupArn()).add("TagList", this.hasTagList() ? this.tagList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBShardGroupResourceId": {
                return Optional.ofNullable(clazz.cast(this.dbShardGroupResourceId()));
            }
            case "DBShardGroupIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbShardGroupIdentifier()));
            }
            case "DBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "MaxACU": {
                return Optional.ofNullable(clazz.cast(this.maxACU()));
            }
            case "MinACU": {
                return Optional.ofNullable(clazz.cast(this.minACU()));
            }
            case "ComputeRedundancy": {
                return Optional.ofNullable(clazz.cast(this.computeRedundancy()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "PubliclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "DBShardGroupArn": {
                return Optional.ofNullable(clazz.cast(this.dbShardGroupArn()));
            }
            case "TagList": {
                return Optional.ofNullable(clazz.cast(this.tagList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDbShardGroupResponse, T> g) {
        return obj -> g.apply((CreateDbShardGroupResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private String dbShardGroupResourceId;
        private String dbShardGroupIdentifier;
        private String dbClusterIdentifier;
        private Double maxACU;
        private Double minACU;
        private Integer computeRedundancy;
        private String status;
        private Boolean publiclyAccessible;
        private String endpoint;
        private String dbShardGroupArn;
        private List<Tag> tagList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDbShardGroupResponse model) {
            super(model);
            this.dbShardGroupResourceId(model.dbShardGroupResourceId);
            this.dbShardGroupIdentifier(model.dbShardGroupIdentifier);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.maxACU(model.maxACU);
            this.minACU(model.minACU);
            this.computeRedundancy(model.computeRedundancy);
            this.status(model.status);
            this.publiclyAccessible(model.publiclyAccessible);
            this.endpoint(model.endpoint);
            this.dbShardGroupArn(model.dbShardGroupArn);
            this.tagList(model.tagList);
        }

        public final String getDbShardGroupResourceId() {
            return this.dbShardGroupResourceId;
        }

        public final void setDbShardGroupResourceId(String dbShardGroupResourceId) {
            this.dbShardGroupResourceId = dbShardGroupResourceId;
        }

        @Override
        public final Builder dbShardGroupResourceId(String dbShardGroupResourceId) {
            this.dbShardGroupResourceId = dbShardGroupResourceId;
            return this;
        }

        public final String getDbShardGroupIdentifier() {
            return this.dbShardGroupIdentifier;
        }

        public final void setDbShardGroupIdentifier(String dbShardGroupIdentifier) {
            this.dbShardGroupIdentifier = dbShardGroupIdentifier;
        }

        @Override
        public final Builder dbShardGroupIdentifier(String dbShardGroupIdentifier) {
            this.dbShardGroupIdentifier = dbShardGroupIdentifier;
            return this;
        }

        public final String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final Double getMaxACU() {
            return this.maxACU;
        }

        public final void setMaxACU(Double maxACU) {
            this.maxACU = maxACU;
        }

        @Override
        public final Builder maxACU(Double maxACU) {
            this.maxACU = maxACU;
            return this;
        }

        public final Double getMinACU() {
            return this.minACU;
        }

        public final void setMinACU(Double minACU) {
            this.minACU = minACU;
        }

        @Override
        public final Builder minACU(Double minACU) {
            this.minACU = minACU;
            return this;
        }

        public final Integer getComputeRedundancy() {
            return this.computeRedundancy;
        }

        public final void setComputeRedundancy(Integer computeRedundancy) {
            this.computeRedundancy = computeRedundancy;
        }

        @Override
        public final Builder computeRedundancy(Integer computeRedundancy) {
            this.computeRedundancy = computeRedundancy;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final String getEndpoint() {
            return this.endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getDbShardGroupArn() {
            return this.dbShardGroupArn;
        }

        public final void setDbShardGroupArn(String dbShardGroupArn) {
            this.dbShardGroupArn = dbShardGroupArn;
        }

        @Override
        public final Builder dbShardGroupArn(String dbShardGroupArn) {
            this.dbShardGroupArn = dbShardGroupArn;
            return this;
        }

        public final List<Tag.Builder> getTagList() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tagList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagList(Collection<Tag.BuilderImpl> tagList) {
            this.tagList = TagListCopier.copyFromBuilder(tagList);
        }

        @Override
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Tag ... tagList) {
            this.tagList(Arrays.asList(tagList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Consumer<Tag.Builder> ... tagList) {
            this.tagList(Stream.of(tagList).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateDbShardGroupResponse build() {
            return new CreateDbShardGroupResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDbShardGroupResponse> {
        public Builder dbShardGroupResourceId(String var1);

        public Builder dbShardGroupIdentifier(String var1);

        public Builder dbClusterIdentifier(String var1);

        public Builder maxACU(Double var1);

        public Builder minACU(Double var1);

        public Builder computeRedundancy(Integer var1);

        public Builder status(String var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder endpoint(String var1);

        public Builder dbShardGroupArn(String var1);

        public Builder tagList(Collection<Tag> var1);

        public Builder tagList(Tag ... var1);

        public Builder tagList(Consumer<Tag.Builder> ... var1);
    }
}

