/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.internal.UserAgentUtils;
import software.amazon.awssdk.services.rds.model.BlueGreenDeployment;
import software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsRequest;
import software.amazon.awssdk.services.rds.model.DescribeBlueGreenDeploymentsResponse;

public class DescribeBlueGreenDeploymentsIterable
implements SdkIterable<DescribeBlueGreenDeploymentsResponse> {
    private final RdsClient client;
    private final DescribeBlueGreenDeploymentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeBlueGreenDeploymentsIterable(RdsClient client, DescribeBlueGreenDeploymentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeBlueGreenDeploymentsResponseFetcher();
    }

    public Iterator<DescribeBlueGreenDeploymentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<BlueGreenDeployment> blueGreenDeployments() {
        Function<DescribeBlueGreenDeploymentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.blueGreenDeployments() != null) {
                return response.blueGreenDeployments().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeBlueGreenDeploymentsResponseFetcher
    implements SyncPageFetcher<DescribeBlueGreenDeploymentsResponse> {
        private DescribeBlueGreenDeploymentsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeBlueGreenDeploymentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeBlueGreenDeploymentsResponse nextPage(DescribeBlueGreenDeploymentsResponse previousPage) {
            if (previousPage == null) {
                return DescribeBlueGreenDeploymentsIterable.this.client.describeBlueGreenDeployments(DescribeBlueGreenDeploymentsIterable.this.firstRequest);
            }
            return DescribeBlueGreenDeploymentsIterable.this.client.describeBlueGreenDeployments((DescribeBlueGreenDeploymentsRequest)((Object)DescribeBlueGreenDeploymentsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

