/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DocLink;
import software.amazon.awssdk.services.rds.model.DocLinkListCopier;
import software.amazon.awssdk.services.rds.model.IssueDetails;
import software.amazon.awssdk.services.rds.model.RecommendedAction;
import software.amazon.awssdk.services.rds.model.RecommendedActionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DBRecommendation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DBRecommendation> {
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendationId").getter(DBRecommendation.getter(DBRecommendation::recommendationId)).setter(DBRecommendation.setter(Builder::recommendationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationId").build()}).build();
    private static final SdkField<String> TYPE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeId").getter(DBRecommendation.getter(DBRecommendation::typeId)).setter(DBRecommendation.setter(Builder::typeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeId").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Severity").getter(DBRecommendation.getter(DBRecommendation::severity)).setter(DBRecommendation.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(DBRecommendation.getter(DBRecommendation::resourceArn)).setter(DBRecommendation.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DBRecommendation.getter(DBRecommendation::status)).setter(DBRecommendation.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedTime").getter(DBRecommendation.getter(DBRecommendation::createdTime)).setter(DBRecommendation.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<Instant> UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedTime").getter(DBRecommendation.getter(DBRecommendation::updatedTime)).setter(DBRecommendation.setter(Builder::updatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedTime").build()}).build();
    private static final SdkField<String> DETECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Detection").getter(DBRecommendation.getter(DBRecommendation::detection)).setter(DBRecommendation.setter(Builder::detection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Detection").build()}).build();
    private static final SdkField<String> RECOMMENDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Recommendation").getter(DBRecommendation.getter(DBRecommendation::recommendation)).setter(DBRecommendation.setter(Builder::recommendation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recommendation").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DBRecommendation.getter(DBRecommendation::description)).setter(DBRecommendation.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Reason").getter(DBRecommendation.getter(DBRecommendation::reason)).setter(DBRecommendation.setter(Builder::reason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()}).build();
    private static final SdkField<List<RecommendedAction>> RECOMMENDED_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RecommendedActions").getter(DBRecommendation.getter(DBRecommendation::recommendedActions)).setter(DBRecommendation.setter(Builder::recommendedActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendedActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecommendedAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Category").getter(DBRecommendation.getter(DBRecommendation::category)).setter(DBRecommendation.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()}).build();
    private static final SdkField<String> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Source").getter(DBRecommendation.getter(DBRecommendation::source)).setter(DBRecommendation.setter(Builder::source)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<String> TYPE_DETECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeDetection").getter(DBRecommendation.getter(DBRecommendation::typeDetection)).setter(DBRecommendation.setter(Builder::typeDetection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeDetection").build()}).build();
    private static final SdkField<String> TYPE_RECOMMENDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TypeRecommendation").getter(DBRecommendation.getter(DBRecommendation::typeRecommendation)).setter(DBRecommendation.setter(Builder::typeRecommendation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeRecommendation").build()}).build();
    private static final SdkField<String> IMPACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Impact").getter(DBRecommendation.getter(DBRecommendation::impact)).setter(DBRecommendation.setter(Builder::impact)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Impact").build()}).build();
    private static final SdkField<String> ADDITIONAL_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AdditionalInfo").getter(DBRecommendation.getter(DBRecommendation::additionalInfo)).setter(DBRecommendation.setter(Builder::additionalInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalInfo").build()}).build();
    private static final SdkField<List<DocLink>> LINKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Links").getter(DBRecommendation.getter(DBRecommendation::links)).setter(DBRecommendation.setter(Builder::links)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Links").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DocLink::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<IssueDetails> ISSUE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IssueDetails").getter(DBRecommendation.getter(DBRecommendation::issueDetails)).setter(DBRecommendation.setter(Builder::issueDetails)).constructor(IssueDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IssueDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATION_ID_FIELD, TYPE_ID_FIELD, SEVERITY_FIELD, RESOURCE_ARN_FIELD, STATUS_FIELD, CREATED_TIME_FIELD, UPDATED_TIME_FIELD, DETECTION_FIELD, RECOMMENDATION_FIELD, DESCRIPTION_FIELD, REASON_FIELD, RECOMMENDED_ACTIONS_FIELD, CATEGORY_FIELD, SOURCE_FIELD, TYPE_DETECTION_FIELD, TYPE_RECOMMENDATION_FIELD, IMPACT_FIELD, ADDITIONAL_INFO_FIELD, LINKS_FIELD, ISSUE_DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String recommendationId;
    private final String typeId;
    private final String severity;
    private final String resourceArn;
    private final String status;
    private final Instant createdTime;
    private final Instant updatedTime;
    private final String detection;
    private final String recommendation;
    private final String description;
    private final String reason;
    private final List<RecommendedAction> recommendedActions;
    private final String category;
    private final String source;
    private final String typeDetection;
    private final String typeRecommendation;
    private final String impact;
    private final String additionalInfo;
    private final List<DocLink> links;
    private final IssueDetails issueDetails;

    private DBRecommendation(BuilderImpl builder) {
        this.recommendationId = builder.recommendationId;
        this.typeId = builder.typeId;
        this.severity = builder.severity;
        this.resourceArn = builder.resourceArn;
        this.status = builder.status;
        this.createdTime = builder.createdTime;
        this.updatedTime = builder.updatedTime;
        this.detection = builder.detection;
        this.recommendation = builder.recommendation;
        this.description = builder.description;
        this.reason = builder.reason;
        this.recommendedActions = builder.recommendedActions;
        this.category = builder.category;
        this.source = builder.source;
        this.typeDetection = builder.typeDetection;
        this.typeRecommendation = builder.typeRecommendation;
        this.impact = builder.impact;
        this.additionalInfo = builder.additionalInfo;
        this.links = builder.links;
        this.issueDetails = builder.issueDetails;
    }

    public final String recommendationId() {
        return this.recommendationId;
    }

    public final String typeId() {
        return this.typeId;
    }

    public final String severity() {
        return this.severity;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String status() {
        return this.status;
    }

    public final Instant createdTime() {
        return this.createdTime;
    }

    public final Instant updatedTime() {
        return this.updatedTime;
    }

    public final String detection() {
        return this.detection;
    }

    public final String recommendation() {
        return this.recommendation;
    }

    public final String description() {
        return this.description;
    }

    public final String reason() {
        return this.reason;
    }

    public final boolean hasRecommendedActions() {
        return this.recommendedActions != null && !(this.recommendedActions instanceof SdkAutoConstructList);
    }

    public final List<RecommendedAction> recommendedActions() {
        return this.recommendedActions;
    }

    public final String category() {
        return this.category;
    }

    public final String source() {
        return this.source;
    }

    public final String typeDetection() {
        return this.typeDetection;
    }

    public final String typeRecommendation() {
        return this.typeRecommendation;
    }

    public final String impact() {
        return this.impact;
    }

    public final String additionalInfo() {
        return this.additionalInfo;
    }

    public final boolean hasLinks() {
        return this.links != null && !(this.links instanceof SdkAutoConstructList);
    }

    public final List<DocLink> links() {
        return this.links;
    }

    public final IssueDetails issueDetails() {
        return this.issueDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.detection());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendation());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.reason());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendedActions() ? this.recommendedActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.category());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeDetection());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeRecommendation());
        hashCode = 31 * hashCode + Objects.hashCode(this.impact());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLinks() ? this.links() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.issueDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DBRecommendation)) {
            return false;
        }
        DBRecommendation other = (DBRecommendation)obj;
        return Objects.equals(this.recommendationId(), other.recommendationId()) && Objects.equals(this.typeId(), other.typeId()) && Objects.equals(this.severity(), other.severity()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.createdTime(), other.createdTime()) && Objects.equals(this.updatedTime(), other.updatedTime()) && Objects.equals(this.detection(), other.detection()) && Objects.equals(this.recommendation(), other.recommendation()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.reason(), other.reason()) && this.hasRecommendedActions() == other.hasRecommendedActions() && Objects.equals(this.recommendedActions(), other.recommendedActions()) && Objects.equals(this.category(), other.category()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.typeDetection(), other.typeDetection()) && Objects.equals(this.typeRecommendation(), other.typeRecommendation()) && Objects.equals(this.impact(), other.impact()) && Objects.equals(this.additionalInfo(), other.additionalInfo()) && this.hasLinks() == other.hasLinks() && Objects.equals(this.links(), other.links()) && Objects.equals(this.issueDetails(), other.issueDetails());
    }

    public final String toString() {
        return ToString.builder((String)"DBRecommendation").add("RecommendationId", (Object)this.recommendationId()).add("TypeId", (Object)this.typeId()).add("Severity", (Object)this.severity()).add("ResourceArn", (Object)this.resourceArn()).add("Status", (Object)this.status()).add("CreatedTime", (Object)this.createdTime()).add("UpdatedTime", (Object)this.updatedTime()).add("Detection", (Object)this.detection()).add("Recommendation", (Object)this.recommendation()).add("Description", (Object)this.description()).add("Reason", (Object)this.reason()).add("RecommendedActions", this.hasRecommendedActions() ? this.recommendedActions() : null).add("Category", (Object)this.category()).add("Source", (Object)this.source()).add("TypeDetection", (Object)this.typeDetection()).add("TypeRecommendation", (Object)this.typeRecommendation()).add("Impact", (Object)this.impact()).add("AdditionalInfo", (Object)this.additionalInfo()).add("Links", this.hasLinks() ? this.links() : null).add("IssueDetails", (Object)this.issueDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecommendationId": {
                return Optional.ofNullable(clazz.cast(this.recommendationId()));
            }
            case "TypeId": {
                return Optional.ofNullable(clazz.cast(this.typeId()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severity()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "UpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.updatedTime()));
            }
            case "Detection": {
                return Optional.ofNullable(clazz.cast(this.detection()));
            }
            case "Recommendation": {
                return Optional.ofNullable(clazz.cast(this.recommendation()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Reason": {
                return Optional.ofNullable(clazz.cast(this.reason()));
            }
            case "RecommendedActions": {
                return Optional.ofNullable(clazz.cast(this.recommendedActions()));
            }
            case "Category": {
                return Optional.ofNullable(clazz.cast(this.category()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "TypeDetection": {
                return Optional.ofNullable(clazz.cast(this.typeDetection()));
            }
            case "TypeRecommendation": {
                return Optional.ofNullable(clazz.cast(this.typeRecommendation()));
            }
            case "Impact": {
                return Optional.ofNullable(clazz.cast(this.impact()));
            }
            case "AdditionalInfo": {
                return Optional.ofNullable(clazz.cast(this.additionalInfo()));
            }
            case "Links": {
                return Optional.ofNullable(clazz.cast(this.links()));
            }
            case "IssueDetails": {
                return Optional.ofNullable(clazz.cast(this.issueDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DBRecommendation, T> g) {
        return obj -> g.apply((DBRecommendation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String recommendationId;
        private String typeId;
        private String severity;
        private String resourceArn;
        private String status;
        private Instant createdTime;
        private Instant updatedTime;
        private String detection;
        private String recommendation;
        private String description;
        private String reason;
        private List<RecommendedAction> recommendedActions = DefaultSdkAutoConstructList.getInstance();
        private String category;
        private String source;
        private String typeDetection;
        private String typeRecommendation;
        private String impact;
        private String additionalInfo;
        private List<DocLink> links = DefaultSdkAutoConstructList.getInstance();
        private IssueDetails issueDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(DBRecommendation model) {
            this.recommendationId(model.recommendationId);
            this.typeId(model.typeId);
            this.severity(model.severity);
            this.resourceArn(model.resourceArn);
            this.status(model.status);
            this.createdTime(model.createdTime);
            this.updatedTime(model.updatedTime);
            this.detection(model.detection);
            this.recommendation(model.recommendation);
            this.description(model.description);
            this.reason(model.reason);
            this.recommendedActions(model.recommendedActions);
            this.category(model.category);
            this.source(model.source);
            this.typeDetection(model.typeDetection);
            this.typeRecommendation(model.typeRecommendation);
            this.impact(model.impact);
            this.additionalInfo(model.additionalInfo);
            this.links(model.links);
            this.issueDetails(model.issueDetails);
        }

        public final String getRecommendationId() {
            return this.recommendationId;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final String getTypeId() {
            return this.typeId;
        }

        public final void setTypeId(String typeId) {
            this.typeId = typeId;
        }

        @Override
        public final Builder typeId(String typeId) {
            this.typeId = typeId;
            return this;
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Instant getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getUpdatedTime() {
            return this.updatedTime;
        }

        public final void setUpdatedTime(Instant updatedTime) {
            this.updatedTime = updatedTime;
        }

        @Override
        public final Builder updatedTime(Instant updatedTime) {
            this.updatedTime = updatedTime;
            return this;
        }

        public final String getDetection() {
            return this.detection;
        }

        public final void setDetection(String detection) {
            this.detection = detection;
        }

        @Override
        public final Builder detection(String detection) {
            this.detection = detection;
            return this;
        }

        public final String getRecommendation() {
            return this.recommendation;
        }

        public final void setRecommendation(String recommendation) {
            this.recommendation = recommendation;
        }

        @Override
        public final Builder recommendation(String recommendation) {
            this.recommendation = recommendation;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getReason() {
            return this.reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final List<RecommendedAction.Builder> getRecommendedActions() {
            List<RecommendedAction.Builder> result = RecommendedActionListCopier.copyToBuilder(this.recommendedActions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecommendedActions(Collection<RecommendedAction.BuilderImpl> recommendedActions) {
            this.recommendedActions = RecommendedActionListCopier.copyFromBuilder(recommendedActions);
        }

        @Override
        public final Builder recommendedActions(Collection<RecommendedAction> recommendedActions) {
            this.recommendedActions = RecommendedActionListCopier.copy(recommendedActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendedActions(RecommendedAction ... recommendedActions) {
            this.recommendedActions(Arrays.asList(recommendedActions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendedActions(Consumer<RecommendedAction.Builder> ... recommendedActions) {
            this.recommendedActions(Stream.of(recommendedActions).map(c -> (RecommendedAction)((RecommendedAction.Builder)RecommendedAction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        public final String getSource() {
            return this.source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getTypeDetection() {
            return this.typeDetection;
        }

        public final void setTypeDetection(String typeDetection) {
            this.typeDetection = typeDetection;
        }

        @Override
        public final Builder typeDetection(String typeDetection) {
            this.typeDetection = typeDetection;
            return this;
        }

        public final String getTypeRecommendation() {
            return this.typeRecommendation;
        }

        public final void setTypeRecommendation(String typeRecommendation) {
            this.typeRecommendation = typeRecommendation;
        }

        @Override
        public final Builder typeRecommendation(String typeRecommendation) {
            this.typeRecommendation = typeRecommendation;
            return this;
        }

        public final String getImpact() {
            return this.impact;
        }

        public final void setImpact(String impact) {
            this.impact = impact;
        }

        @Override
        public final Builder impact(String impact) {
            this.impact = impact;
            return this;
        }

        public final String getAdditionalInfo() {
            return this.additionalInfo;
        }

        public final void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        @Override
        public final Builder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public final List<DocLink.Builder> getLinks() {
            List<DocLink.Builder> result = DocLinkListCopier.copyToBuilder(this.links);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLinks(Collection<DocLink.BuilderImpl> links) {
            this.links = DocLinkListCopier.copyFromBuilder(links);
        }

        @Override
        public final Builder links(Collection<DocLink> links) {
            this.links = DocLinkListCopier.copy(links);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder links(DocLink ... links) {
            this.links(Arrays.asList(links));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder links(Consumer<DocLink.Builder> ... links) {
            this.links(Stream.of(links).map(c -> (DocLink)((DocLink.Builder)DocLink.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final IssueDetails.Builder getIssueDetails() {
            return this.issueDetails != null ? this.issueDetails.toBuilder() : null;
        }

        public final void setIssueDetails(IssueDetails.BuilderImpl issueDetails) {
            this.issueDetails = issueDetails != null ? issueDetails.build() : null;
        }

        @Override
        public final Builder issueDetails(IssueDetails issueDetails) {
            this.issueDetails = issueDetails;
            return this;
        }

        public DBRecommendation build() {
            return new DBRecommendation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DBRecommendation> {
        public Builder recommendationId(String var1);

        public Builder typeId(String var1);

        public Builder severity(String var1);

        public Builder resourceArn(String var1);

        public Builder status(String var1);

        public Builder createdTime(Instant var1);

        public Builder updatedTime(Instant var1);

        public Builder detection(String var1);

        public Builder recommendation(String var1);

        public Builder description(String var1);

        public Builder reason(String var1);

        public Builder recommendedActions(Collection<RecommendedAction> var1);

        public Builder recommendedActions(RecommendedAction ... var1);

        public Builder recommendedActions(Consumer<RecommendedAction.Builder> ... var1);

        public Builder category(String var1);

        public Builder source(String var1);

        public Builder typeDetection(String var1);

        public Builder typeRecommendation(String var1);

        public Builder impact(String var1);

        public Builder additionalInfo(String var1);

        public Builder links(Collection<DocLink> var1);

        public Builder links(DocLink ... var1);

        public Builder links(Consumer<DocLink.Builder> ... var1);

        public Builder issueDetails(IssueDetails var1);

        default public Builder issueDetails(Consumer<IssueDetails.Builder> issueDetails) {
            return this.issueDetails((IssueDetails)((IssueDetails.Builder)IssueDetails.builder().applyMutation(issueDetails)).build());
        }
    }
}

