/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartDbInstanceAutomatedBackupsReplicationRequest extends RdsRequest
        implements
        ToCopyableBuilder<StartDbInstanceAutomatedBackupsReplicationRequest.Builder, StartDbInstanceAutomatedBackupsReplicationRequest> {
    private static final SdkField<String> SOURCE_DB_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceDBInstanceArn")
            .getter(getter(StartDbInstanceAutomatedBackupsReplicationRequest::sourceDBInstanceArn))
            .setter(setter(Builder::sourceDBInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceDBInstanceArn").build())
            .build();

    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BackupRetentionPeriod")
            .getter(getter(StartDbInstanceAutomatedBackupsReplicationRequest::backupRetentionPeriod))
            .setter(setter(Builder::backupRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build())
            .build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(StartDbInstanceAutomatedBackupsReplicationRequest::kmsKeyId))
            .setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<String> PRE_SIGNED_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreSignedUrl").getter(getter(StartDbInstanceAutomatedBackupsReplicationRequest::preSignedUrl))
            .setter(setter(Builder::preSignedUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreSignedUrl").build()).build();

    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceRegion").getter(getter(StartDbInstanceAutomatedBackupsReplicationRequest::sourceRegion))
            .setter(setter(Builder::sourceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_DB_INSTANCE_ARN_FIELD,
            BACKUP_RETENTION_PERIOD_FIELD, KMS_KEY_ID_FIELD, PRE_SIGNED_URL_FIELD, SOURCE_REGION_FIELD));

    private final String sourceDBInstanceArn;

    private final Integer backupRetentionPeriod;

    private final String kmsKeyId;

    private final String preSignedUrl;

    private final String sourceRegion;

    private StartDbInstanceAutomatedBackupsReplicationRequest(BuilderImpl builder) {
        super(builder);
        this.sourceDBInstanceArn = builder.sourceDBInstanceArn;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.kmsKeyId = builder.kmsKeyId;
        this.preSignedUrl = builder.preSignedUrl;
        this.sourceRegion = builder.sourceRegion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the source DB instance for the replicated automated backups, for example,
     * <code>arn:aws:rds:us-west-2:123456789012:db:mydatabase</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the source DB instance for the replicated automated backups, for
     *         example, <code>arn:aws:rds:us-west-2:123456789012:db:mydatabase</code>.
     */
    public final String sourceDBInstanceArn() {
        return sourceDBInstanceArn;
    }

    /**
     * <p>
     * The retention period for the replicated automated backups.
     * </p>
     * 
     * @return The retention period for the replicated automated backups.
     */
    public final Integer backupRetentionPeriod() {
        return backupRetentionPeriod;
    }

    /**
     * <p>
     * The Amazon Web Services KMS key identifier for encryption of the replicated automated backups. The KMS key ID is
     * the Amazon Resource Name (ARN) for the KMS encryption key in the destination Amazon Web Services Region, for
     * example, <code>arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE</code>.
     * </p>
     * 
     * @return The Amazon Web Services KMS key identifier for encryption of the replicated automated backups. The KMS
     *         key ID is the Amazon Resource Name (ARN) for the KMS encryption key in the destination Amazon Web
     *         Services Region, for example, <code>arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE</code>.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * In an Amazon Web Services GovCloud (US) Region, an URL that contains a Signature Version 4 signed request for the
     * <code>StartDBInstanceAutomatedBackupsReplication</code> operation to call in the Amazon Web Services Region of
     * the source DB instance. The presigned URL must be a valid request for the
     * <code>StartDBInstanceAutomatedBackupsReplication</code> API operation that can run in the Amazon Web Services
     * Region that contains the source DB instance.
     * </p>
     * <p>
     * This setting applies only to Amazon Web Services GovCloud (US) Regions. It's ignored in other Amazon Web Services
     * Regions.
     * </p>
     * <p>
     * To learn how to generate a Signature Version 4 signed request, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html"> Authenticating Requests:
     * Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a
     * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html"> Signature Version 4 Signing
     * Process</a>.
     * </p>
     * <note>
     * <p>
     * If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or
     * <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually. Specifying
     * <code>SourceRegion</code> autogenerates a presigned URL that is a valid request for the operation that can run in
     * the source Amazon Web Services Region.
     * </p>
     * </note>
     * 
     * @return In an Amazon Web Services GovCloud (US) Region, an URL that contains a Signature Version 4 signed request
     *         for the <code>StartDBInstanceAutomatedBackupsReplication</code> operation to call in the Amazon Web
     *         Services Region of the source DB instance. The presigned URL must be a valid request for the
     *         <code>StartDBInstanceAutomatedBackupsReplication</code> API operation that can run in the Amazon Web
     *         Services Region that contains the source DB instance.</p>
     *         <p>
     *         This setting applies only to Amazon Web Services GovCloud (US) Regions. It's ignored in other Amazon Web
     *         Services Regions.
     *         </p>
     *         <p>
     *         To learn how to generate a Signature Version 4 signed request, see <a
     *         href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html"> Authenticating
     *         Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html"> Signature Version 4
     *         Signing Process</a>.
     *         </p>
     *         <note>
     *         <p>
     *         If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code>
     *         (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually.
     *         Specifying <code>SourceRegion</code> autogenerates a presigned URL that is a valid request for the
     *         operation that can run in the source Amazon Web Services Region.
     *         </p>
     */
    public final String preSignedUrl() {
        return preSignedUrl;
    }

    /**
     * If PreSignedUrl is not specified, this is the region where the source snapshot is located. A PreSignedUrl will be
     * generated automatically by the SDK.
     * 
     * @return If PreSignedUrl is not specified, this is the region where the source snapshot is located. A PreSignedUrl
     *         will be generated automatically by the SDK.
     */
    public final String sourceRegion() {
        return sourceRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceDBInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(preSignedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDbInstanceAutomatedBackupsReplicationRequest)) {
            return false;
        }
        StartDbInstanceAutomatedBackupsReplicationRequest other = (StartDbInstanceAutomatedBackupsReplicationRequest) obj;
        return Objects.equals(sourceDBInstanceArn(), other.sourceDBInstanceArn())
                && Objects.equals(backupRetentionPeriod(), other.backupRetentionPeriod())
                && Objects.equals(kmsKeyId(), other.kmsKeyId()) && Objects.equals(preSignedUrl(), other.preSignedUrl())
                && Objects.equals(sourceRegion(), other.sourceRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartDbInstanceAutomatedBackupsReplicationRequest")
                .add("SourceDBInstanceArn", sourceDBInstanceArn()).add("BackupRetentionPeriod", backupRetentionPeriod())
                .add("KmsKeyId", kmsKeyId()).add("PreSignedUrl", preSignedUrl()).add("SourceRegion", sourceRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceDBInstanceArn":
            return Optional.ofNullable(clazz.cast(sourceDBInstanceArn()));
        case "BackupRetentionPeriod":
            return Optional.ofNullable(clazz.cast(backupRetentionPeriod()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "PreSignedUrl":
            return Optional.ofNullable(clazz.cast(preSignedUrl()));
        case "SourceRegion":
            return Optional.ofNullable(clazz.cast(sourceRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartDbInstanceAutomatedBackupsReplicationRequest, T> g) {
        return obj -> g.apply((StartDbInstanceAutomatedBackupsReplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartDbInstanceAutomatedBackupsReplicationRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the source DB instance for the replicated automated backups, for example,
         * <code>arn:aws:rds:us-west-2:123456789012:db:mydatabase</code>.
         * </p>
         * 
         * @param sourceDBInstanceArn
         *        The Amazon Resource Name (ARN) of the source DB instance for the replicated automated backups, for
         *        example, <code>arn:aws:rds:us-west-2:123456789012:db:mydatabase</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDBInstanceArn(String sourceDBInstanceArn);

        /**
         * <p>
         * The retention period for the replicated automated backups.
         * </p>
         * 
         * @param backupRetentionPeriod
         *        The retention period for the replicated automated backups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRetentionPeriod(Integer backupRetentionPeriod);

        /**
         * <p>
         * The Amazon Web Services KMS key identifier for encryption of the replicated automated backups. The KMS key ID
         * is the Amazon Resource Name (ARN) for the KMS encryption key in the destination Amazon Web Services Region,
         * for example, <code>arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE</code>.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Web Services KMS key identifier for encryption of the replicated automated backups. The KMS
         *        key ID is the Amazon Resource Name (ARN) for the KMS encryption key in the destination Amazon Web
         *        Services Region, for example, <code>arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * In an Amazon Web Services GovCloud (US) Region, an URL that contains a Signature Version 4 signed request for
         * the <code>StartDBInstanceAutomatedBackupsReplication</code> operation to call in the Amazon Web Services
         * Region of the source DB instance. The presigned URL must be a valid request for the
         * <code>StartDBInstanceAutomatedBackupsReplication</code> API operation that can run in the Amazon Web Services
         * Region that contains the source DB instance.
         * </p>
         * <p>
         * This setting applies only to Amazon Web Services GovCloud (US) Regions. It's ignored in other Amazon Web
         * Services Regions.
         * </p>
         * <p>
         * To learn how to generate a Signature Version 4 signed request, see <a
         * href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html"> Authenticating Requests:
         * Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a
         * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html"> Signature Version 4 Signing
         * Process</a>.
         * </p>
         * <note>
         * <p>
         * If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code> (or
         * <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code> manually.
         * Specifying <code>SourceRegion</code> autogenerates a presigned URL that is a valid request for the operation
         * that can run in the source Amazon Web Services Region.
         * </p>
         * </note>
         * 
         * @param preSignedUrl
         *        In an Amazon Web Services GovCloud (US) Region, an URL that contains a Signature Version 4 signed
         *        request for the <code>StartDBInstanceAutomatedBackupsReplication</code> operation to call in the
         *        Amazon Web Services Region of the source DB instance. The presigned URL must be a valid request for
         *        the <code>StartDBInstanceAutomatedBackupsReplication</code> API operation that can run in the Amazon
         *        Web Services Region that contains the source DB instance.</p>
         *        <p>
         *        This setting applies only to Amazon Web Services GovCloud (US) Regions. It's ignored in other Amazon
         *        Web Services Regions.
         *        </p>
         *        <p>
         *        To learn how to generate a Signature Version 4 signed request, see <a
         *        href="https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html"> Authenticating
         *        Requests: Using Query Parameters (Amazon Web Services Signature Version 4)</a> and <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html"> Signature Version 4
         *        Signing Process</a>.
         *        </p>
         *        <note>
         *        <p>
         *        If you are using an Amazon Web Services SDK tool or the CLI, you can specify <code>SourceRegion</code>
         *        (or <code>--source-region</code> for the CLI) instead of specifying <code>PreSignedUrl</code>
         *        manually. Specifying <code>SourceRegion</code> autogenerates a presigned URL that is a valid request
         *        for the operation that can run in the source Amazon Web Services Region.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preSignedUrl(String preSignedUrl);

        /**
         * If PreSignedUrl is not specified, this is the region where the source snapshot is located. A PreSignedUrl
         * will be generated automatically by the SDK.
         * 
         * @param sourceRegion
         *        If PreSignedUrl is not specified, this is the region where the source snapshot is located. A
         *        PreSignedUrl will be generated automatically by the SDK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRegion(String sourceRegion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String sourceDBInstanceArn;

        private Integer backupRetentionPeriod;

        private String kmsKeyId;

        private String preSignedUrl;

        private String sourceRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDbInstanceAutomatedBackupsReplicationRequest model) {
            super(model);
            sourceDBInstanceArn(model.sourceDBInstanceArn);
            backupRetentionPeriod(model.backupRetentionPeriod);
            kmsKeyId(model.kmsKeyId);
            preSignedUrl(model.preSignedUrl);
            sourceRegion(model.sourceRegion);
        }

        public final String getSourceDBInstanceArn() {
            return sourceDBInstanceArn;
        }

        public final void setSourceDBInstanceArn(String sourceDBInstanceArn) {
            this.sourceDBInstanceArn = sourceDBInstanceArn;
        }

        @Override
        public final Builder sourceDBInstanceArn(String sourceDBInstanceArn) {
            this.sourceDBInstanceArn = sourceDBInstanceArn;
            return this;
        }

        public final Integer getBackupRetentionPeriod() {
            return backupRetentionPeriod;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getPreSignedUrl() {
            return preSignedUrl;
        }

        public final void setPreSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
        }

        @Override
        public final Builder preSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
            return this;
        }

        public final String getSourceRegion() {
            return sourceRegion;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDbInstanceAutomatedBackupsReplicationRequest build() {
            return new StartDbInstanceAutomatedBackupsReplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
