/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Reserved for future use.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RdsCustomClusterConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RdsCustomClusterConfiguration.Builder, RdsCustomClusterConfiguration> {
    private static final SdkField<String> INTERCONNECT_SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InterconnectSubnetId").getter(getter(RdsCustomClusterConfiguration::interconnectSubnetId))
            .setter(setter(Builder::interconnectSubnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InterconnectSubnetId").build())
            .build();

    private static final SdkField<String> TRANSIT_GATEWAY_MULTICAST_DOMAIN_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("TransitGatewayMulticastDomainId")
            .getter(getter(RdsCustomClusterConfiguration::transitGatewayMulticastDomainId))
            .setter(setter(Builder::transitGatewayMulticastDomainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransitGatewayMulticastDomainId")
                    .build()).build();

    private static final SdkField<String> REPLICA_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReplicaMode").getter(getter(RdsCustomClusterConfiguration::replicaModeAsString))
            .setter(setter(Builder::replicaMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERCONNECT_SUBNET_ID_FIELD,
            TRANSIT_GATEWAY_MULTICAST_DOMAIN_ID_FIELD, REPLICA_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String interconnectSubnetId;

    private final String transitGatewayMulticastDomainId;

    private final String replicaMode;

    private RdsCustomClusterConfiguration(BuilderImpl builder) {
        this.interconnectSubnetId = builder.interconnectSubnetId;
        this.transitGatewayMulticastDomainId = builder.transitGatewayMulticastDomainId;
        this.replicaMode = builder.replicaMode;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public final String interconnectSubnetId() {
        return interconnectSubnetId;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public final String transitGatewayMulticastDomainId() {
        return transitGatewayMulticastDomainId;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicaMode} will
     * return {@link ReplicaMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #replicaModeAsString}.
     * </p>
     * 
     * @return Reserved for future use.
     * @see ReplicaMode
     */
    public final ReplicaMode replicaMode() {
        return ReplicaMode.fromValue(replicaMode);
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicaMode} will
     * return {@link ReplicaMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #replicaModeAsString}.
     * </p>
     * 
     * @return Reserved for future use.
     * @see ReplicaMode
     */
    public final String replicaModeAsString() {
        return replicaMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(interconnectSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(transitGatewayMulticastDomainId());
        hashCode = 31 * hashCode + Objects.hashCode(replicaModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RdsCustomClusterConfiguration)) {
            return false;
        }
        RdsCustomClusterConfiguration other = (RdsCustomClusterConfiguration) obj;
        return Objects.equals(interconnectSubnetId(), other.interconnectSubnetId())
                && Objects.equals(transitGatewayMulticastDomainId(), other.transitGatewayMulticastDomainId())
                && Objects.equals(replicaModeAsString(), other.replicaModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RdsCustomClusterConfiguration").add("InterconnectSubnetId", interconnectSubnetId())
                .add("TransitGatewayMulticastDomainId", transitGatewayMulticastDomainId())
                .add("ReplicaMode", replicaModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InterconnectSubnetId":
            return Optional.ofNullable(clazz.cast(interconnectSubnetId()));
        case "TransitGatewayMulticastDomainId":
            return Optional.ofNullable(clazz.cast(transitGatewayMulticastDomainId()));
        case "ReplicaMode":
            return Optional.ofNullable(clazz.cast(replicaModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RdsCustomClusterConfiguration, T> g) {
        return obj -> g.apply((RdsCustomClusterConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RdsCustomClusterConfiguration> {
        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param interconnectSubnetId
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder interconnectSubnetId(String interconnectSubnetId);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param transitGatewayMulticastDomainId
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitGatewayMulticastDomainId(String transitGatewayMulticastDomainId);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param replicaMode
         *        Reserved for future use.
         * @see ReplicaMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicaMode
         */
        Builder replicaMode(String replicaMode);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param replicaMode
         *        Reserved for future use.
         * @see ReplicaMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicaMode
         */
        Builder replicaMode(ReplicaMode replicaMode);
    }

    static final class BuilderImpl implements Builder {
        private String interconnectSubnetId;

        private String transitGatewayMulticastDomainId;

        private String replicaMode;

        private BuilderImpl() {
        }

        private BuilderImpl(RdsCustomClusterConfiguration model) {
            interconnectSubnetId(model.interconnectSubnetId);
            transitGatewayMulticastDomainId(model.transitGatewayMulticastDomainId);
            replicaMode(model.replicaMode);
        }

        public final String getInterconnectSubnetId() {
            return interconnectSubnetId;
        }

        public final void setInterconnectSubnetId(String interconnectSubnetId) {
            this.interconnectSubnetId = interconnectSubnetId;
        }

        @Override
        public final Builder interconnectSubnetId(String interconnectSubnetId) {
            this.interconnectSubnetId = interconnectSubnetId;
            return this;
        }

        public final String getTransitGatewayMulticastDomainId() {
            return transitGatewayMulticastDomainId;
        }

        public final void setTransitGatewayMulticastDomainId(String transitGatewayMulticastDomainId) {
            this.transitGatewayMulticastDomainId = transitGatewayMulticastDomainId;
        }

        @Override
        public final Builder transitGatewayMulticastDomainId(String transitGatewayMulticastDomainId) {
            this.transitGatewayMulticastDomainId = transitGatewayMulticastDomainId;
            return this;
        }

        public final String getReplicaMode() {
            return replicaMode;
        }

        public final void setReplicaMode(String replicaMode) {
            this.replicaMode = replicaMode;
        }

        @Override
        public final Builder replicaMode(String replicaMode) {
            this.replicaMode = replicaMode;
            return this;
        }

        @Override
        public final Builder replicaMode(ReplicaMode replicaMode) {
            this.replicaMode(replicaMode == null ? null : replicaMode.toString());
            return this;
        }

        @Override
        public RdsCustomClusterConfiguration build() {
            return new RdsCustomClusterConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
