/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The representation of a metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Metric implements SdkPojo, Serializable, ToCopyableBuilder<Metric.Builder, Metric> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Metric::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<MetricReference>> REFERENCES_FIELD = SdkField
            .<List<MetricReference>> builder(MarshallingType.LIST)
            .memberName("References")
            .getter(getter(Metric::references))
            .setter(setter(Builder::references))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("References").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetricReference> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetricReference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATISTICS_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatisticsDetails").getter(getter(Metric::statisticsDetails)).setter(setter(Builder::statisticsDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatisticsDetails").build()).build();

    private static final SdkField<MetricQuery> METRIC_QUERY_FIELD = SdkField.<MetricQuery> builder(MarshallingType.SDK_POJO)
            .memberName("MetricQuery").getter(getter(Metric::metricQuery)).setter(setter(Builder::metricQuery))
            .constructor(MetricQuery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricQuery").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, REFERENCES_FIELD,
            STATISTICS_DETAILS_FIELD, METRIC_QUERY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<MetricReference> references;

    private final String statisticsDetails;

    private final MetricQuery metricQuery;

    private Metric(BuilderImpl builder) {
        this.name = builder.name;
        this.references = builder.references;
        this.statisticsDetails = builder.statisticsDetails;
        this.metricQuery = builder.metricQuery;
    }

    /**
     * <p>
     * The name of a metric.
     * </p>
     * 
     * @return The name of a metric.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the References property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasReferences() {
        return references != null && !(references instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of metric references (thresholds).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReferences} method.
     * </p>
     * 
     * @return A list of metric references (thresholds).
     */
    public final List<MetricReference> references() {
        return references;
    }

    /**
     * <p>
     * The details of different statistics for a metric. The description might contain markdown.
     * </p>
     * 
     * @return The details of different statistics for a metric. The description might contain markdown.
     */
    public final String statisticsDetails() {
        return statisticsDetails;
    }

    /**
     * <p>
     * The query to retrieve metric data points.
     * </p>
     * 
     * @return The query to retrieve metric data points.
     */
    public final MetricQuery metricQuery() {
        return metricQuery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasReferences() ? references() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statisticsDetails());
        hashCode = 31 * hashCode + Objects.hashCode(metricQuery());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Metric)) {
            return false;
        }
        Metric other = (Metric) obj;
        return Objects.equals(name(), other.name()) && hasReferences() == other.hasReferences()
                && Objects.equals(references(), other.references())
                && Objects.equals(statisticsDetails(), other.statisticsDetails())
                && Objects.equals(metricQuery(), other.metricQuery());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Metric").add("Name", name()).add("References", hasReferences() ? references() : null)
                .add("StatisticsDetails", statisticsDetails()).add("MetricQuery", metricQuery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "References":
            return Optional.ofNullable(clazz.cast(references()));
        case "StatisticsDetails":
            return Optional.ofNullable(clazz.cast(statisticsDetails()));
        case "MetricQuery":
            return Optional.ofNullable(clazz.cast(metricQuery()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Metric, T> g) {
        return obj -> g.apply((Metric) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Metric> {
        /**
         * <p>
         * The name of a metric.
         * </p>
         * 
         * @param name
         *        The name of a metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A list of metric references (thresholds).
         * </p>
         * 
         * @param references
         *        A list of metric references (thresholds).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder references(Collection<MetricReference> references);

        /**
         * <p>
         * A list of metric references (thresholds).
         * </p>
         * 
         * @param references
         *        A list of metric references (thresholds).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder references(MetricReference... references);

        /**
         * <p>
         * A list of metric references (thresholds).
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.MetricReference.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.rds.model.MetricReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.rds.model.MetricReference.Builder#build()} is called immediately and
         * its result is passed to {@link #references(List<MetricReference>)}.
         * 
         * @param references
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.rds.model.MetricReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #references(java.util.Collection<MetricReference>)
         */
        Builder references(Consumer<MetricReference.Builder>... references);

        /**
         * <p>
         * The details of different statistics for a metric. The description might contain markdown.
         * </p>
         * 
         * @param statisticsDetails
         *        The details of different statistics for a metric. The description might contain markdown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statisticsDetails(String statisticsDetails);

        /**
         * <p>
         * The query to retrieve metric data points.
         * </p>
         * 
         * @param metricQuery
         *        The query to retrieve metric data points.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricQuery(MetricQuery metricQuery);

        /**
         * <p>
         * The query to retrieve metric data points.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetricQuery.Builder} avoiding the need to
         * create one manually via {@link MetricQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetricQuery.Builder#build()} is called immediately and its result
         * is passed to {@link #metricQuery(MetricQuery)}.
         * 
         * @param metricQuery
         *        a consumer that will call methods on {@link MetricQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricQuery(MetricQuery)
         */
        default Builder metricQuery(Consumer<MetricQuery.Builder> metricQuery) {
            return metricQuery(MetricQuery.builder().applyMutation(metricQuery).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<MetricReference> references = DefaultSdkAutoConstructList.getInstance();

        private String statisticsDetails;

        private MetricQuery metricQuery;

        private BuilderImpl() {
        }

        private BuilderImpl(Metric model) {
            name(model.name);
            references(model.references);
            statisticsDetails(model.statisticsDetails);
            metricQuery(model.metricQuery);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<MetricReference.Builder> getReferences() {
            List<MetricReference.Builder> result = MetricReferenceListCopier.copyToBuilder(this.references);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReferences(Collection<MetricReference.BuilderImpl> references) {
            this.references = MetricReferenceListCopier.copyFromBuilder(references);
        }

        @Override
        public final Builder references(Collection<MetricReference> references) {
            this.references = MetricReferenceListCopier.copy(references);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder references(MetricReference... references) {
            references(Arrays.asList(references));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder references(Consumer<MetricReference.Builder>... references) {
            references(Stream.of(references).map(c -> MetricReference.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getStatisticsDetails() {
            return statisticsDetails;
        }

        public final void setStatisticsDetails(String statisticsDetails) {
            this.statisticsDetails = statisticsDetails;
        }

        @Override
        public final Builder statisticsDetails(String statisticsDetails) {
            this.statisticsDetails = statisticsDetails;
            return this;
        }

        public final MetricQuery.Builder getMetricQuery() {
            return metricQuery != null ? metricQuery.toBuilder() : null;
        }

        public final void setMetricQuery(MetricQuery.BuilderImpl metricQuery) {
            this.metricQuery = metricQuery != null ? metricQuery.build() : null;
        }

        @Override
        public final Builder metricQuery(MetricQuery metricQuery) {
            this.metricQuery = metricQuery;
            return this;
        }

        @Override
        public Metric build() {
            return new Metric(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
