/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDbRecommendationsRequest extends RdsRequest implements
        ToCopyableBuilder<DescribeDbRecommendationsRequest.Builder, DescribeDbRecommendationsRequest> {
    private static final SdkField<Instant> LAST_UPDATED_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAfter").getter(getter(DescribeDbRecommendationsRequest::lastUpdatedAfter))
            .setter(setter(Builder::lastUpdatedAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAfter").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedBefore").getter(getter(DescribeDbRecommendationsRequest::lastUpdatedBefore))
            .setter(setter(Builder::lastUpdatedBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedBefore").build()).build();

    private static final SdkField<String> LOCALE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Locale")
            .getter(getter(DescribeDbRecommendationsRequest::locale)).setter(setter(Builder::locale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locale").build()).build();

    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField
            .<List<Filter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeDbRecommendationsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Filter")
                            .memberFieldInfo(
                                    SdkField.<Filter> builder(MarshallingType.SDK_POJO)
                                            .constructor(Filter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Filter").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeDbRecommendationsRequest::maxRecords))
            .setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeDbRecommendationsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAST_UPDATED_AFTER_FIELD,
            LAST_UPDATED_BEFORE_FIELD, LOCALE_FIELD, FILTERS_FIELD, MAX_RECORDS_FIELD, MARKER_FIELD));

    private final Instant lastUpdatedAfter;

    private final Instant lastUpdatedBefore;

    private final String locale;

    private final List<Filter> filters;

    private final Integer maxRecords;

    private final String marker;

    private DescribeDbRecommendationsRequest(BuilderImpl builder) {
        super(builder);
        this.lastUpdatedAfter = builder.lastUpdatedAfter;
        this.lastUpdatedBefore = builder.lastUpdatedBefore;
        this.locale = builder.locale;
        this.filters = builder.filters;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * A filter to include only the recommendations that were updated after this specified time.
     * </p>
     * 
     * @return A filter to include only the recommendations that were updated after this specified time.
     */
    public final Instant lastUpdatedAfter() {
        return lastUpdatedAfter;
    }

    /**
     * <p>
     * A filter to include only the recommendations that were updated before this specified time.
     * </p>
     * 
     * @return A filter to include only the recommendations that were updated before this specified time.
     */
    public final Instant lastUpdatedBefore() {
        return lastUpdatedBefore;
    }

    /**
     * <p>
     * The language that you choose to return the list of recommendations.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>en</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>en_UK</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>de</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>es</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>fr</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>id</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>it</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ja</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ko</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pt_BR</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh_TW</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zh_CN</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The language that you choose to return the list of recommendations.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>en</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>en_UK</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>de</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>es</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>fr</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>id</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>it</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ja</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ko</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pt_BR</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh_TW</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zh_CN</code>
     *         </p>
     *         </li>
     */
    public final String locale() {
        return locale;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A filter that specifies one or more recommendations to describe.
     * </p>
     * <p>
     * Supported Filters:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>recommendation-id</code> - Accepts a list of recommendation identifiers. The results list only includes the
     * recommendations whose identifier is one of the specified filter values.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>status</code> - Accepts a list of recommendation statuses.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>active</code> - The recommendations which are ready for you to apply.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending</code> - The applied or scheduled recommendations which are in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>resolved</code> - The recommendations which are completed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dismissed</code> - The recommendations that you dismissed.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The results list only includes the recommendations whose status is one of the specified filter values.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>severity</code> - Accepts a list of recommendation severities. The results list only includes the
     * recommendations whose severity is one of the specified filter values.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>high</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>medium</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>low</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>informational</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>type-id</code> - Accepts a list of recommendation type identifiers. The results list only includes the
     * recommendations whose type is one of the specified filter values.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>dbi-resource-id</code> - Accepts a list of database resource identifiers. The results list only includes
     * the recommendations that generated for the specified databases.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cluster-resource-id</code> - Accepts a list of cluster resource identifiers. The results list only includes
     * the recommendations that generated for the specified clusters.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pg-arn</code> - Accepts a list of parameter group ARNs. The results list only includes the recommendations
     * that generated for the specified parameter groups.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>cluster-pg-arn</code> - Accepts a list of cluster parameter group ARNs. The results list only includes the
     * recommendations that generated for the specified cluster parameter groups.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return A filter that specifies one or more recommendations to describe.</p>
     *         <p>
     *         Supported Filters:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>recommendation-id</code> - Accepts a list of recommendation identifiers. The results list only
     *         includes the recommendations whose identifier is one of the specified filter values.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>status</code> - Accepts a list of recommendation statuses.
     *         </p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>active</code> - The recommendations which are ready for you to apply.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending</code> - The applied or scheduled recommendations which are in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>resolved</code> - The recommendations which are completed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dismissed</code> - The recommendations that you dismissed.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The results list only includes the recommendations whose status is one of the specified filter values.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>severity</code> - Accepts a list of recommendation severities. The results list only includes the
     *         recommendations whose severity is one of the specified filter values.
     *         </p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>high</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>medium</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>low</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>informational</code>
     *         </p>
     *         </li>
     *         </ul>
     *         </li>
     *         <li>
     *         <p>
     *         <code>type-id</code> - Accepts a list of recommendation type identifiers. The results list only includes
     *         the recommendations whose type is one of the specified filter values.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>dbi-resource-id</code> - Accepts a list of database resource identifiers. The results list only
     *         includes the recommendations that generated for the specified databases.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cluster-resource-id</code> - Accepts a list of cluster resource identifiers. The results list only
     *         includes the recommendations that generated for the specified clusters.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pg-arn</code> - Accepts a list of parameter group ARNs. The results list only includes the
     *         recommendations that generated for the specified parameter groups.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>cluster-pg-arn</code> - Accepts a list of cluster parameter group ARNs. The results list only
     *         includes the recommendations that generated for the specified cluster parameter groups.
     *         </p>
     *         </li>
     */
    public final List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of recommendations to include in the response. If more records exist than the specified
     * <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can
     * retrieve the remaining results.
     * </p>
     * 
     * @return The maximum number of recommendations to include in the response. If more records exist than the
     *         specified <code>MaxRecords</code> value, a pagination token called a marker is included in the response
     *         so that you can retrieve the remaining results.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous <code>DescribeDBRecommendations</code> request. If this
     * parameter is specified, the response includes only records beyond the marker, up to the value specified by
     * <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous <code>DescribeDBRecommendations</code> request. If
     *         this parameter is specified, the response includes only records beyond the marker, up to the value
     *         specified by <code>MaxRecords</code>.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAfter());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedBefore());
        hashCode = 31 * hashCode + Objects.hashCode(locale());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbRecommendationsRequest)) {
            return false;
        }
        DescribeDbRecommendationsRequest other = (DescribeDbRecommendationsRequest) obj;
        return Objects.equals(lastUpdatedAfter(), other.lastUpdatedAfter())
                && Objects.equals(lastUpdatedBefore(), other.lastUpdatedBefore()) && Objects.equals(locale(), other.locale())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(maxRecords(), other.maxRecords()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDbRecommendationsRequest").add("LastUpdatedAfter", lastUpdatedAfter())
                .add("LastUpdatedBefore", lastUpdatedBefore()).add("Locale", locale())
                .add("Filters", hasFilters() ? filters() : null).add("MaxRecords", maxRecords()).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LastUpdatedAfter":
            return Optional.ofNullable(clazz.cast(lastUpdatedAfter()));
        case "LastUpdatedBefore":
            return Optional.ofNullable(clazz.cast(lastUpdatedBefore()));
        case "Locale":
            return Optional.ofNullable(clazz.cast(locale()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbRecommendationsRequest, T> g) {
        return obj -> g.apply((DescribeDbRecommendationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDbRecommendationsRequest> {
        /**
         * <p>
         * A filter to include only the recommendations that were updated after this specified time.
         * </p>
         * 
         * @param lastUpdatedAfter
         *        A filter to include only the recommendations that were updated after this specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAfter(Instant lastUpdatedAfter);

        /**
         * <p>
         * A filter to include only the recommendations that were updated before this specified time.
         * </p>
         * 
         * @param lastUpdatedBefore
         *        A filter to include only the recommendations that were updated before this specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedBefore(Instant lastUpdatedBefore);

        /**
         * <p>
         * The language that you choose to return the list of recommendations.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>en</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>en_UK</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>de</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>es</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>fr</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>id</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>it</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ja</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ko</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pt_BR</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh_TW</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zh_CN</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param locale
         *        The language that you choose to return the list of recommendations.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>en</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>en_UK</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>de</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>es</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>fr</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>id</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>it</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ja</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ko</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pt_BR</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh_TW</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zh_CN</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locale(String locale);

        /**
         * <p>
         * A filter that specifies one or more recommendations to describe.
         * </p>
         * <p>
         * Supported Filters:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>recommendation-id</code> - Accepts a list of recommendation identifiers. The results list only includes
         * the recommendations whose identifier is one of the specified filter values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - Accepts a list of recommendation statuses.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>active</code> - The recommendations which are ready for you to apply.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code> - The applied or scheduled recommendations which are in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resolved</code> - The recommendations which are completed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dismissed</code> - The recommendations that you dismissed.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The results list only includes the recommendations whose status is one of the specified filter values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>severity</code> - Accepts a list of recommendation severities. The results list only includes the
         * recommendations whose severity is one of the specified filter values.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>high</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>medium</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>low</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>informational</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>type-id</code> - Accepts a list of recommendation type identifiers. The results list only includes the
         * recommendations whose type is one of the specified filter values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dbi-resource-id</code> - Accepts a list of database resource identifiers. The results list only
         * includes the recommendations that generated for the specified databases.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cluster-resource-id</code> - Accepts a list of cluster resource identifiers. The results list only
         * includes the recommendations that generated for the specified clusters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pg-arn</code> - Accepts a list of parameter group ARNs. The results list only includes the
         * recommendations that generated for the specified parameter groups.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cluster-pg-arn</code> - Accepts a list of cluster parameter group ARNs. The results list only includes
         * the recommendations that generated for the specified cluster parameter groups.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        A filter that specifies one or more recommendations to describe.</p>
         *        <p>
         *        Supported Filters:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>recommendation-id</code> - Accepts a list of recommendation identifiers. The results list only
         *        includes the recommendations whose identifier is one of the specified filter values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status</code> - Accepts a list of recommendation statuses.
         *        </p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>active</code> - The recommendations which are ready for you to apply.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code> - The applied or scheduled recommendations which are in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resolved</code> - The recommendations which are completed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dismissed</code> - The recommendations that you dismissed.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The results list only includes the recommendations whose status is one of the specified filter values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>severity</code> - Accepts a list of recommendation severities. The results list only includes
         *        the recommendations whose severity is one of the specified filter values.
         *        </p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>high</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>medium</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>low</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>informational</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>type-id</code> - Accepts a list of recommendation type identifiers. The results list only
         *        includes the recommendations whose type is one of the specified filter values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dbi-resource-id</code> - Accepts a list of database resource identifiers. The results list only
         *        includes the recommendations that generated for the specified databases.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cluster-resource-id</code> - Accepts a list of cluster resource identifiers. The results list
         *        only includes the recommendations that generated for the specified clusters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pg-arn</code> - Accepts a list of parameter group ARNs. The results list only includes the
         *        recommendations that generated for the specified parameter groups.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cluster-pg-arn</code> - Accepts a list of cluster parameter group ARNs. The results list only
         *        includes the recommendations that generated for the specified cluster parameter groups.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * A filter that specifies one or more recommendations to describe.
         * </p>
         * <p>
         * Supported Filters:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>recommendation-id</code> - Accepts a list of recommendation identifiers. The results list only includes
         * the recommendations whose identifier is one of the specified filter values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - Accepts a list of recommendation statuses.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>active</code> - The recommendations which are ready for you to apply.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code> - The applied or scheduled recommendations which are in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resolved</code> - The recommendations which are completed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dismissed</code> - The recommendations that you dismissed.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The results list only includes the recommendations whose status is one of the specified filter values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>severity</code> - Accepts a list of recommendation severities. The results list only includes the
         * recommendations whose severity is one of the specified filter values.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>high</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>medium</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>low</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>informational</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>type-id</code> - Accepts a list of recommendation type identifiers. The results list only includes the
         * recommendations whose type is one of the specified filter values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dbi-resource-id</code> - Accepts a list of database resource identifiers. The results list only
         * includes the recommendations that generated for the specified databases.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cluster-resource-id</code> - Accepts a list of cluster resource identifiers. The results list only
         * includes the recommendations that generated for the specified clusters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pg-arn</code> - Accepts a list of parameter group ARNs. The results list only includes the
         * recommendations that generated for the specified parameter groups.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cluster-pg-arn</code> - Accepts a list of cluster parameter group ARNs. The results list only includes
         * the recommendations that generated for the specified cluster parameter groups.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        A filter that specifies one or more recommendations to describe.</p>
         *        <p>
         *        Supported Filters:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>recommendation-id</code> - Accepts a list of recommendation identifiers. The results list only
         *        includes the recommendations whose identifier is one of the specified filter values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status</code> - Accepts a list of recommendation statuses.
         *        </p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>active</code> - The recommendations which are ready for you to apply.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code> - The applied or scheduled recommendations which are in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>resolved</code> - The recommendations which are completed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dismissed</code> - The recommendations that you dismissed.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The results list only includes the recommendations whose status is one of the specified filter values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>severity</code> - Accepts a list of recommendation severities. The results list only includes
         *        the recommendations whose severity is one of the specified filter values.
         *        </p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>high</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>medium</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>low</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>informational</code>
         *        </p>
         *        </li>
         *        </ul>
         *        </li>
         *        <li>
         *        <p>
         *        <code>type-id</code> - Accepts a list of recommendation type identifiers. The results list only
         *        includes the recommendations whose type is one of the specified filter values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>dbi-resource-id</code> - Accepts a list of database resource identifiers. The results list only
         *        includes the recommendations that generated for the specified databases.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cluster-resource-id</code> - Accepts a list of cluster resource identifiers. The results list
         *        only includes the recommendations that generated for the specified clusters.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pg-arn</code> - Accepts a list of parameter group ARNs. The results list only includes the
         *        recommendations that generated for the specified parameter groups.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>cluster-pg-arn</code> - Accepts a list of cluster parameter group ARNs. The results list only
         *        includes the recommendations that generated for the specified cluster parameter groups.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * A filter that specifies one or more recommendations to describe.
         * </p>
         * <p>
         * Supported Filters:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>recommendation-id</code> - Accepts a list of recommendation identifiers. The results list only includes
         * the recommendations whose identifier is one of the specified filter values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status</code> - Accepts a list of recommendation statuses.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>active</code> - The recommendations which are ready for you to apply.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code> - The applied or scheduled recommendations which are in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>resolved</code> - The recommendations which are completed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dismissed</code> - The recommendations that you dismissed.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The results list only includes the recommendations whose status is one of the specified filter values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>severity</code> - Accepts a list of recommendation severities. The results list only includes the
         * recommendations whose severity is one of the specified filter values.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>high</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>medium</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>low</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>informational</code>
         * </p>
         * </li>
         * </ul>
         * </li>
         * <li>
         * <p>
         * <code>type-id</code> - Accepts a list of recommendation type identifiers. The results list only includes the
         * recommendations whose type is one of the specified filter values.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>dbi-resource-id</code> - Accepts a list of database resource identifiers. The results list only
         * includes the recommendations that generated for the specified databases.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cluster-resource-id</code> - Accepts a list of cluster resource identifiers. The results list only
         * includes the recommendations that generated for the specified clusters.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pg-arn</code> - Accepts a list of parameter group ARNs. The results list only includes the
         * recommendations that generated for the specified parameter groups.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>cluster-pg-arn</code> - Accepts a list of cluster parameter group ARNs. The results list only includes
         * the recommendations that generated for the specified cluster parameter groups.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.Filter.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.rds.model.Filter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.rds.model.Filter.Builder#build()}
         * is called immediately and its result is passed to {@link #filters(List<Filter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.rds.model.Filter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<Filter>)
         */
        Builder filters(Consumer<Filter.Builder>... filters);

        /**
         * <p>
         * The maximum number of recommendations to include in the response. If more records exist than the specified
         * <code>MaxRecords</code> value, a pagination token called a marker is included in the response so that you can
         * retrieve the remaining results.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of recommendations to include in the response. If more records exist than the
         *        specified <code>MaxRecords</code> value, a pagination token called a marker is included in the
         *        response so that you can retrieve the remaining results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * An optional pagination token provided by a previous <code>DescribeDBRecommendations</code> request. If this
         * parameter is specified, the response includes only records beyond the marker, up to the value specified by
         * <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous <code>DescribeDBRecommendations</code> request. If
         *        this parameter is specified, the response includes only records beyond the marker, up to the value
         *        specified by <code>MaxRecords</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private Instant lastUpdatedAfter;

        private Instant lastUpdatedBefore;

        private String locale;

        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxRecords;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbRecommendationsRequest model) {
            super(model);
            lastUpdatedAfter(model.lastUpdatedAfter);
            lastUpdatedBefore(model.lastUpdatedBefore);
            locale(model.locale);
            filters(model.filters);
            maxRecords(model.maxRecords);
            marker(model.marker);
        }

        public final Instant getLastUpdatedAfter() {
            return lastUpdatedAfter;
        }

        public final void setLastUpdatedAfter(Instant lastUpdatedAfter) {
            this.lastUpdatedAfter = lastUpdatedAfter;
        }

        @Override
        public final Builder lastUpdatedAfter(Instant lastUpdatedAfter) {
            this.lastUpdatedAfter = lastUpdatedAfter;
            return this;
        }

        public final Instant getLastUpdatedBefore() {
            return lastUpdatedBefore;
        }

        public final void setLastUpdatedBefore(Instant lastUpdatedBefore) {
            this.lastUpdatedBefore = lastUpdatedBefore;
        }

        @Override
        public final Builder lastUpdatedBefore(Instant lastUpdatedBefore) {
            this.lastUpdatedBefore = lastUpdatedBefore;
            return this;
        }

        public final String getLocale() {
            return locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> Filter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final String getMarker() {
            return marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDbRecommendationsRequest build() {
            return new DescribeDbRecommendationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
