/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCustomDbEngineVersionRequest extends RdsRequest implements
        ToCopyableBuilder<CreateCustomDbEngineVersionRequest.Builder, CreateCustomDbEngineVersionRequest> {
    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(CreateCustomDbEngineVersionRequest::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(CreateCustomDbEngineVersionRequest::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<String> DATABASE_INSTALLATION_FILES_S3_BUCKET_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DatabaseInstallationFilesS3BucketName")
            .getter(getter(CreateCustomDbEngineVersionRequest::databaseInstallationFilesS3BucketName))
            .setter(setter(Builder::databaseInstallationFilesS3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("DatabaseInstallationFilesS3BucketName").build()).build();

    private static final SdkField<String> DATABASE_INSTALLATION_FILES_S3_PREFIX_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DatabaseInstallationFilesS3Prefix")
            .getter(getter(CreateCustomDbEngineVersionRequest::databaseInstallationFilesS3Prefix))
            .setter(setter(Builder::databaseInstallationFilesS3Prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseInstallationFilesS3Prefix")
                    .build()).build();

    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageId").getter(getter(CreateCustomDbEngineVersionRequest::imageId)).setter(setter(Builder::imageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").build()).build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KMSKeyId").getter(getter(CreateCustomDbEngineVersionRequest::kmsKeyId))
            .setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateCustomDbEngineVersionRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> MANIFEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Manifest").getter(getter(CreateCustomDbEngineVersionRequest::manifest))
            .setter(setter(Builder::manifest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Manifest").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateCustomDbEngineVersionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("Tag")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Tag").build()).build()).build()).build();

    private static final SdkField<String> SOURCE_CUSTOM_DB_ENGINE_VERSION_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceCustomDbEngineVersionIdentifier")
            .getter(getter(CreateCustomDbEngineVersionRequest::sourceCustomDbEngineVersionIdentifier))
            .setter(setter(Builder::sourceCustomDbEngineVersionIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SourceCustomDbEngineVersionIdentifier").build()).build();

    private static final SdkField<Boolean> USE_AWS_PROVIDED_LATEST_IMAGE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("UseAwsProvidedLatestImage")
            .getter(getter(CreateCustomDbEngineVersionRequest::useAwsProvidedLatestImage))
            .setter(setter(Builder::useAwsProvidedLatestImage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseAwsProvidedLatestImage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_FIELD,
            ENGINE_VERSION_FIELD, DATABASE_INSTALLATION_FILES_S3_BUCKET_NAME_FIELD, DATABASE_INSTALLATION_FILES_S3_PREFIX_FIELD,
            IMAGE_ID_FIELD, KMS_KEY_ID_FIELD, DESCRIPTION_FIELD, MANIFEST_FIELD, TAGS_FIELD,
            SOURCE_CUSTOM_DB_ENGINE_VERSION_IDENTIFIER_FIELD, USE_AWS_PROVIDED_LATEST_IMAGE_FIELD));

    private final String engine;

    private final String engineVersion;

    private final String databaseInstallationFilesS3BucketName;

    private final String databaseInstallationFilesS3Prefix;

    private final String imageId;

    private final String kmsKeyId;

    private final String description;

    private final String manifest;

    private final List<Tag> tags;

    private final String sourceCustomDbEngineVersionIdentifier;

    private final Boolean useAwsProvidedLatestImage;

    private CreateCustomDbEngineVersionRequest(BuilderImpl builder) {
        super(builder);
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.databaseInstallationFilesS3BucketName = builder.databaseInstallationFilesS3BucketName;
        this.databaseInstallationFilesS3Prefix = builder.databaseInstallationFilesS3Prefix;
        this.imageId = builder.imageId;
        this.kmsKeyId = builder.kmsKeyId;
        this.description = builder.description;
        this.manifest = builder.manifest;
        this.tags = builder.tags;
        this.sourceCustomDbEngineVersionIdentifier = builder.sourceCustomDbEngineVersionIdentifier;
        this.useAwsProvidedLatestImage = builder.useAwsProvidedLatestImage;
    }

    /**
     * <p>
     * The database engine. RDS Custom for Oracle supports the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>custom-oracle-ee</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>custom-oracle-ee-cdb</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>custom-oracle-se2</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>custom-oracle-se2-cdb</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The database engine. RDS Custom for Oracle supports the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>custom-oracle-ee</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>custom-oracle-ee-cdb</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>custom-oracle-se2</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>custom-oracle-se2-cdb</code>
     *         </p>
     *         </li>
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * The name of your CEV. The name format is 19.<i>customized_string</i>. For example, a valid CEV name is
     * <code>19.my_cev1</code>. This setting is required for RDS Custom for Oracle, but optional for Amazon RDS. The
     * combination of <code>Engine</code> and <code>EngineVersion</code> is unique per customer per Region.
     * </p>
     * 
     * @return The name of your CEV. The name format is 19.<i>customized_string</i>. For example, a valid CEV name is
     *         <code>19.my_cev1</code>. This setting is required for RDS Custom for Oracle, but optional for Amazon RDS.
     *         The combination of <code>Engine</code> and <code>EngineVersion</code> is unique per customer per Region.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * The name of an Amazon S3 bucket that contains database installation files for your CEV. For example, a valid
     * bucket name is <code>my-custom-installation-files</code>.
     * </p>
     * 
     * @return The name of an Amazon S3 bucket that contains database installation files for your CEV. For example, a
     *         valid bucket name is <code>my-custom-installation-files</code>.
     */
    public final String databaseInstallationFilesS3BucketName() {
        return databaseInstallationFilesS3BucketName;
    }

    /**
     * <p>
     * The Amazon S3 directory that contains the database installation files for your CEV. For example, a valid bucket
     * name is <code>123456789012/cev1</code>. If this setting isn't specified, no prefix is assumed.
     * </p>
     * 
     * @return The Amazon S3 directory that contains the database installation files for your CEV. For example, a valid
     *         bucket name is <code>123456789012/cev1</code>. If this setting isn't specified, no prefix is assumed.
     */
    public final String databaseInstallationFilesS3Prefix() {
        return databaseInstallationFilesS3Prefix;
    }

    /**
     * <p>
     * The ID of the Amazon Machine Image (AMI). For RDS Custom for SQL Server, an AMI ID is required to create a CEV.
     * For RDS Custom for Oracle, the default is the most recent AMI available, but you can specify an AMI ID that was
     * used in a different Oracle CEV. Find the AMIs used by your CEVs by calling the <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBEngineVersions.html"
     * >DescribeDBEngineVersions</a> operation.
     * </p>
     * 
     * @return The ID of the Amazon Machine Image (AMI). For RDS Custom for SQL Server, an AMI ID is required to create
     *         a CEV. For RDS Custom for Oracle, the default is the most recent AMI available, but you can specify an
     *         AMI ID that was used in a different Oracle CEV. Find the AMIs used by your CEVs by calling the <a
     *         href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBEngineVersions.html"
     *         >DescribeDBEngineVersions</a> operation.
     */
    public final String imageId() {
        return imageId;
    }

    /**
     * <p>
     * The Amazon Web Services KMS key identifier for an encrypted CEV. A symmetric encryption KMS key is required for
     * RDS Custom, but optional for Amazon RDS.
     * </p>
     * <p>
     * If you have an existing symmetric encryption KMS key in your account, you can use it with RDS Custom. No further
     * action is necessary. If you don't already have a symmetric encryption KMS key in your account, follow the
     * instructions in <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html#create-symmetric-cmk"> Creating a
     * symmetric encryption KMS key</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.
     * </p>
     * <p>
     * You can choose the same symmetric encryption key when you create a CEV and a DB instance, or choose different
     * keys.
     * </p>
     * 
     * @return The Amazon Web Services KMS key identifier for an encrypted CEV. A symmetric encryption KMS key is
     *         required for RDS Custom, but optional for Amazon RDS.</p>
     *         <p>
     *         If you have an existing symmetric encryption KMS key in your account, you can use it with RDS Custom. No
     *         further action is necessary. If you don't already have a symmetric encryption KMS key in your account,
     *         follow the instructions in <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html#create-symmetric-cmk">
     *         Creating a symmetric encryption KMS key</a> in the <i>Amazon Web Services Key Management Service
     *         Developer Guide</i>.
     *         </p>
     *         <p>
     *         You can choose the same symmetric encryption key when you create a CEV and a DB instance, or choose
     *         different keys.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * An optional description of your CEV.
     * </p>
     * 
     * @return An optional description of your CEV.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The CEV manifest, which is a JSON document that describes the installation .zip files stored in Amazon S3.
     * Specify the name/value pairs in a file or a quoted string. RDS Custom applies the patches in the order in which
     * they are listed.
     * </p>
     * <p>
     * The following JSON fields are valid:
     * </p>
     * <dl>
     * <dt>MediaImportTemplateVersion</dt>
     * <dd>
     * <p>
     * Version of the CEV manifest. The date is in the format <code>YYYY-MM-DD</code>.
     * </p>
     * </dd>
     * <dt>databaseInstallationFileNames</dt>
     * <dd>
     * <p>
     * Ordered list of installation files for the CEV.
     * </p>
     * </dd>
     * <dt>opatchFileNames</dt>
     * <dd>
     * <p>
     * Ordered list of OPatch installers used for the Oracle DB engine.
     * </p>
     * </dd>
     * <dt>psuRuPatchFileNames</dt>
     * <dd>
     * <p>
     * The PSU and RU patches for this CEV.
     * </p>
     * </dd>
     * <dt>OtherPatchFileNames</dt>
     * <dd>
     * <p>
     * The patches that are not in the list of PSU and RU patches. Amazon RDS applies these patches after applying the
     * PSU and RU patches.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.preparing.manifest">
     * Creating the CEV manifest</a> in the <i>Amazon RDS User Guide</i>.
     * </p>
     * 
     * @return The CEV manifest, which is a JSON document that describes the installation .zip files stored in Amazon
     *         S3. Specify the name/value pairs in a file or a quoted string. RDS Custom applies the patches in the
     *         order in which they are listed.</p>
     *         <p>
     *         The following JSON fields are valid:
     *         </p>
     *         <dl>
     *         <dt>MediaImportTemplateVersion</dt>
     *         <dd>
     *         <p>
     *         Version of the CEV manifest. The date is in the format <code>YYYY-MM-DD</code>.
     *         </p>
     *         </dd>
     *         <dt>databaseInstallationFileNames</dt>
     *         <dd>
     *         <p>
     *         Ordered list of installation files for the CEV.
     *         </p>
     *         </dd>
     *         <dt>opatchFileNames</dt>
     *         <dd>
     *         <p>
     *         Ordered list of OPatch installers used for the Oracle DB engine.
     *         </p>
     *         </dd>
     *         <dt>psuRuPatchFileNames</dt>
     *         <dd>
     *         <p>
     *         The PSU and RU patches for this CEV.
     *         </p>
     *         </dd>
     *         <dt>OtherPatchFileNames</dt>
     *         <dd>
     *         <p>
     *         The patches that are not in the list of PSU and RU patches. Amazon RDS applies these patches after
     *         applying the PSU and RU patches.
     *         </p>
     *         </dd>
     *         </dl>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.preparing.manifest">
     *         Creating the CEV manifest</a> in the <i>Amazon RDS User Guide</i>.
     */
    public final String manifest() {
        return manifest;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The ARN of a CEV to use as a source for creating a new CEV. You can specify a different Amazon Machine Imagine
     * (AMI) by using either <code>Source</code> or <code>UseAwsProvidedLatestImage</code>. You can't specify a
     * different JSON manifest when you specify <code>SourceCustomDbEngineVersionIdentifier</code>.
     * </p>
     * 
     * @return The ARN of a CEV to use as a source for creating a new CEV. You can specify a different Amazon Machine
     *         Imagine (AMI) by using either <code>Source</code> or <code>UseAwsProvidedLatestImage</code>. You can't
     *         specify a different JSON manifest when you specify <code>SourceCustomDbEngineVersionIdentifier</code>.
     */
    public final String sourceCustomDbEngineVersionIdentifier() {
        return sourceCustomDbEngineVersionIdentifier;
    }

    /**
     * <p>
     * Specifies whether to use the latest service-provided Amazon Machine Image (AMI) for the CEV. If you specify
     * <code>UseAwsProvidedLatestImage</code>, you can't also specify <code>ImageId</code>.
     * </p>
     * 
     * @return Specifies whether to use the latest service-provided Amazon Machine Image (AMI) for the CEV. If you
     *         specify <code>UseAwsProvidedLatestImage</code>, you can't also specify <code>ImageId</code>.
     */
    public final Boolean useAwsProvidedLatestImage() {
        return useAwsProvidedLatestImage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(databaseInstallationFilesS3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(databaseInstallationFilesS3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(manifest());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sourceCustomDbEngineVersionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(useAwsProvidedLatestImage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomDbEngineVersionRequest)) {
            return false;
        }
        CreateCustomDbEngineVersionRequest other = (CreateCustomDbEngineVersionRequest) obj;
        return Objects.equals(engine(), other.engine()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(databaseInstallationFilesS3BucketName(), other.databaseInstallationFilesS3BucketName())
                && Objects.equals(databaseInstallationFilesS3Prefix(), other.databaseInstallationFilesS3Prefix())
                && Objects.equals(imageId(), other.imageId()) && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(description(), other.description()) && Objects.equals(manifest(), other.manifest())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(sourceCustomDbEngineVersionIdentifier(), other.sourceCustomDbEngineVersionIdentifier())
                && Objects.equals(useAwsProvidedLatestImage(), other.useAwsProvidedLatestImage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCustomDbEngineVersionRequest").add("Engine", engine())
                .add("EngineVersion", engineVersion())
                .add("DatabaseInstallationFilesS3BucketName", databaseInstallationFilesS3BucketName())
                .add("DatabaseInstallationFilesS3Prefix", databaseInstallationFilesS3Prefix()).add("ImageId", imageId())
                .add("KMSKeyId", kmsKeyId()).add("Description", description()).add("Manifest", manifest())
                .add("Tags", hasTags() ? tags() : null)
                .add("SourceCustomDbEngineVersionIdentifier", sourceCustomDbEngineVersionIdentifier())
                .add("UseAwsProvidedLatestImage", useAwsProvidedLatestImage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "DatabaseInstallationFilesS3BucketName":
            return Optional.ofNullable(clazz.cast(databaseInstallationFilesS3BucketName()));
        case "DatabaseInstallationFilesS3Prefix":
            return Optional.ofNullable(clazz.cast(databaseInstallationFilesS3Prefix()));
        case "ImageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "KMSKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Manifest":
            return Optional.ofNullable(clazz.cast(manifest()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "SourceCustomDbEngineVersionIdentifier":
            return Optional.ofNullable(clazz.cast(sourceCustomDbEngineVersionIdentifier()));
        case "UseAwsProvidedLatestImage":
            return Optional.ofNullable(clazz.cast(useAwsProvidedLatestImage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateCustomDbEngineVersionRequest, T> g) {
        return obj -> g.apply((CreateCustomDbEngineVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RdsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCustomDbEngineVersionRequest> {
        /**
         * <p>
         * The database engine. RDS Custom for Oracle supports the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>custom-oracle-ee</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>custom-oracle-ee-cdb</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>custom-oracle-se2</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>custom-oracle-se2-cdb</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param engine
         *        The database engine. RDS Custom for Oracle supports the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>custom-oracle-ee</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>custom-oracle-ee-cdb</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>custom-oracle-se2</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>custom-oracle-se2-cdb</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * The name of your CEV. The name format is 19.<i>customized_string</i>. For example, a valid CEV name is
         * <code>19.my_cev1</code>. This setting is required for RDS Custom for Oracle, but optional for Amazon RDS. The
         * combination of <code>Engine</code> and <code>EngineVersion</code> is unique per customer per Region.
         * </p>
         * 
         * @param engineVersion
         *        The name of your CEV. The name format is 19.<i>customized_string</i>. For example, a valid CEV name is
         *        <code>19.my_cev1</code>. This setting is required for RDS Custom for Oracle, but optional for Amazon
         *        RDS. The combination of <code>Engine</code> and <code>EngineVersion</code> is unique per customer per
         *        Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * The name of an Amazon S3 bucket that contains database installation files for your CEV. For example, a valid
         * bucket name is <code>my-custom-installation-files</code>.
         * </p>
         * 
         * @param databaseInstallationFilesS3BucketName
         *        The name of an Amazon S3 bucket that contains database installation files for your CEV. For example, a
         *        valid bucket name is <code>my-custom-installation-files</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseInstallationFilesS3BucketName(String databaseInstallationFilesS3BucketName);

        /**
         * <p>
         * The Amazon S3 directory that contains the database installation files for your CEV. For example, a valid
         * bucket name is <code>123456789012/cev1</code>. If this setting isn't specified, no prefix is assumed.
         * </p>
         * 
         * @param databaseInstallationFilesS3Prefix
         *        The Amazon S3 directory that contains the database installation files for your CEV. For example, a
         *        valid bucket name is <code>123456789012/cev1</code>. If this setting isn't specified, no prefix is
         *        assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseInstallationFilesS3Prefix(String databaseInstallationFilesS3Prefix);

        /**
         * <p>
         * The ID of the Amazon Machine Image (AMI). For RDS Custom for SQL Server, an AMI ID is required to create a
         * CEV. For RDS Custom for Oracle, the default is the most recent AMI available, but you can specify an AMI ID
         * that was used in a different Oracle CEV. Find the AMIs used by your CEVs by calling the <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBEngineVersions.html"
         * >DescribeDBEngineVersions</a> operation.
         * </p>
         * 
         * @param imageId
         *        The ID of the Amazon Machine Image (AMI). For RDS Custom for SQL Server, an AMI ID is required to
         *        create a CEV. For RDS Custom for Oracle, the default is the most recent AMI available, but you can
         *        specify an AMI ID that was used in a different Oracle CEV. Find the AMIs used by your CEVs by calling
         *        the <a
         *        href="https://docs.aws.amazon.com/AmazonRDS/latest/APIReference/API_DescribeDBEngineVersions.html"
         *        >DescribeDBEngineVersions</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * The Amazon Web Services KMS key identifier for an encrypted CEV. A symmetric encryption KMS key is required
         * for RDS Custom, but optional for Amazon RDS.
         * </p>
         * <p>
         * If you have an existing symmetric encryption KMS key in your account, you can use it with RDS Custom. No
         * further action is necessary. If you don't already have a symmetric encryption KMS key in your account, follow
         * the instructions in <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html#create-symmetric-cmk"> Creating
         * a symmetric encryption KMS key</a> in the <i>Amazon Web Services Key Management Service Developer Guide</i>.
         * </p>
         * <p>
         * You can choose the same symmetric encryption key when you create a CEV and a DB instance, or choose different
         * keys.
         * </p>
         * 
         * @param kmsKeyId
         *        The Amazon Web Services KMS key identifier for an encrypted CEV. A symmetric encryption KMS key is
         *        required for RDS Custom, but optional for Amazon RDS.</p>
         *        <p>
         *        If you have an existing symmetric encryption KMS key in your account, you can use it with RDS Custom.
         *        No further action is necessary. If you don't already have a symmetric encryption KMS key in your
         *        account, follow the instructions in <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html#create-symmetric-cmk">
         *        Creating a symmetric encryption KMS key</a> in the <i>Amazon Web Services Key Management Service
         *        Developer Guide</i>.
         *        </p>
         *        <p>
         *        You can choose the same symmetric encryption key when you create a CEV and a DB instance, or choose
         *        different keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * An optional description of your CEV.
         * </p>
         * 
         * @param description
         *        An optional description of your CEV.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The CEV manifest, which is a JSON document that describes the installation .zip files stored in Amazon S3.
         * Specify the name/value pairs in a file or a quoted string. RDS Custom applies the patches in the order in
         * which they are listed.
         * </p>
         * <p>
         * The following JSON fields are valid:
         * </p>
         * <dl>
         * <dt>MediaImportTemplateVersion</dt>
         * <dd>
         * <p>
         * Version of the CEV manifest. The date is in the format <code>YYYY-MM-DD</code>.
         * </p>
         * </dd>
         * <dt>databaseInstallationFileNames</dt>
         * <dd>
         * <p>
         * Ordered list of installation files for the CEV.
         * </p>
         * </dd>
         * <dt>opatchFileNames</dt>
         * <dd>
         * <p>
         * Ordered list of OPatch installers used for the Oracle DB engine.
         * </p>
         * </dd>
         * <dt>psuRuPatchFileNames</dt>
         * <dd>
         * <p>
         * The PSU and RU patches for this CEV.
         * </p>
         * </dd>
         * <dt>OtherPatchFileNames</dt>
         * <dd>
         * <p>
         * The patches that are not in the list of PSU and RU patches. Amazon RDS applies these patches after applying
         * the PSU and RU patches.
         * </p>
         * </dd>
         * </dl>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.preparing.manifest">
         * Creating the CEV manifest</a> in the <i>Amazon RDS User Guide</i>.
         * </p>
         * 
         * @param manifest
         *        The CEV manifest, which is a JSON document that describes the installation .zip files stored in Amazon
         *        S3. Specify the name/value pairs in a file or a quoted string. RDS Custom applies the patches in the
         *        order in which they are listed.</p>
         *        <p>
         *        The following JSON fields are valid:
         *        </p>
         *        <dl>
         *        <dt>MediaImportTemplateVersion</dt>
         *        <dd>
         *        <p>
         *        Version of the CEV manifest. The date is in the format <code>YYYY-MM-DD</code>.
         *        </p>
         *        </dd>
         *        <dt>databaseInstallationFileNames</dt>
         *        <dd>
         *        <p>
         *        Ordered list of installation files for the CEV.
         *        </p>
         *        </dd>
         *        <dt>opatchFileNames</dt>
         *        <dd>
         *        <p>
         *        Ordered list of OPatch installers used for the Oracle DB engine.
         *        </p>
         *        </dd>
         *        <dt>psuRuPatchFileNames</dt>
         *        <dd>
         *        <p>
         *        The PSU and RU patches for this CEV.
         *        </p>
         *        </dd>
         *        <dt>OtherPatchFileNames</dt>
         *        <dd>
         *        <p>
         *        The patches that are not in the list of PSU and RU patches. Amazon RDS applies these patches after
         *        applying the PSU and RU patches.
         *        </p>
         *        </dd>
         *        </dl>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.preparing.manifest"
         *        > Creating the CEV manifest</a> in the <i>Amazon RDS User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifest(String manifest);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * Sets the value of the Tags property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.rds.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.rds.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.rds.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.rds.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The ARN of a CEV to use as a source for creating a new CEV. You can specify a different Amazon Machine
         * Imagine (AMI) by using either <code>Source</code> or <code>UseAwsProvidedLatestImage</code>. You can't
         * specify a different JSON manifest when you specify <code>SourceCustomDbEngineVersionIdentifier</code>.
         * </p>
         * 
         * @param sourceCustomDbEngineVersionIdentifier
         *        The ARN of a CEV to use as a source for creating a new CEV. You can specify a different Amazon Machine
         *        Imagine (AMI) by using either <code>Source</code> or <code>UseAwsProvidedLatestImage</code>. You can't
         *        specify a different JSON manifest when you specify <code>SourceCustomDbEngineVersionIdentifier</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCustomDbEngineVersionIdentifier(String sourceCustomDbEngineVersionIdentifier);

        /**
         * <p>
         * Specifies whether to use the latest service-provided Amazon Machine Image (AMI) for the CEV. If you specify
         * <code>UseAwsProvidedLatestImage</code>, you can't also specify <code>ImageId</code>.
         * </p>
         * 
         * @param useAwsProvidedLatestImage
         *        Specifies whether to use the latest service-provided Amazon Machine Image (AMI) for the CEV. If you
         *        specify <code>UseAwsProvidedLatestImage</code>, you can't also specify <code>ImageId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useAwsProvidedLatestImage(Boolean useAwsProvidedLatestImage);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RdsRequest.BuilderImpl implements Builder {
        private String engine;

        private String engineVersion;

        private String databaseInstallationFilesS3BucketName;

        private String databaseInstallationFilesS3Prefix;

        private String imageId;

        private String kmsKeyId;

        private String description;

        private String manifest;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String sourceCustomDbEngineVersionIdentifier;

        private Boolean useAwsProvidedLatestImage;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomDbEngineVersionRequest model) {
            super(model);
            engine(model.engine);
            engineVersion(model.engineVersion);
            databaseInstallationFilesS3BucketName(model.databaseInstallationFilesS3BucketName);
            databaseInstallationFilesS3Prefix(model.databaseInstallationFilesS3Prefix);
            imageId(model.imageId);
            kmsKeyId(model.kmsKeyId);
            description(model.description);
            manifest(model.manifest);
            tags(model.tags);
            sourceCustomDbEngineVersionIdentifier(model.sourceCustomDbEngineVersionIdentifier);
            useAwsProvidedLatestImage(model.useAwsProvidedLatestImage);
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getDatabaseInstallationFilesS3BucketName() {
            return databaseInstallationFilesS3BucketName;
        }

        public final void setDatabaseInstallationFilesS3BucketName(String databaseInstallationFilesS3BucketName) {
            this.databaseInstallationFilesS3BucketName = databaseInstallationFilesS3BucketName;
        }

        @Override
        public final Builder databaseInstallationFilesS3BucketName(String databaseInstallationFilesS3BucketName) {
            this.databaseInstallationFilesS3BucketName = databaseInstallationFilesS3BucketName;
            return this;
        }

        public final String getDatabaseInstallationFilesS3Prefix() {
            return databaseInstallationFilesS3Prefix;
        }

        public final void setDatabaseInstallationFilesS3Prefix(String databaseInstallationFilesS3Prefix) {
            this.databaseInstallationFilesS3Prefix = databaseInstallationFilesS3Prefix;
        }

        @Override
        public final Builder databaseInstallationFilesS3Prefix(String databaseInstallationFilesS3Prefix) {
            this.databaseInstallationFilesS3Prefix = databaseInstallationFilesS3Prefix;
            return this;
        }

        public final String getImageId() {
            return imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getManifest() {
            return manifest;
        }

        public final void setManifest(String manifest) {
            this.manifest = manifest;
        }

        @Override
        public final Builder manifest(String manifest) {
            this.manifest = manifest;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSourceCustomDbEngineVersionIdentifier() {
            return sourceCustomDbEngineVersionIdentifier;
        }

        public final void setSourceCustomDbEngineVersionIdentifier(String sourceCustomDbEngineVersionIdentifier) {
            this.sourceCustomDbEngineVersionIdentifier = sourceCustomDbEngineVersionIdentifier;
        }

        @Override
        public final Builder sourceCustomDbEngineVersionIdentifier(String sourceCustomDbEngineVersionIdentifier) {
            this.sourceCustomDbEngineVersionIdentifier = sourceCustomDbEngineVersionIdentifier;
            return this;
        }

        public final Boolean getUseAwsProvidedLatestImage() {
            return useAwsProvidedLatestImage;
        }

        public final void setUseAwsProvidedLatestImage(Boolean useAwsProvidedLatestImage) {
            this.useAwsProvidedLatestImage = useAwsProvidedLatestImage;
        }

        @Override
        public final Builder useAwsProvidedLatestImage(Boolean useAwsProvidedLatestImage) {
            this.useAwsProvidedLatestImage = useAwsProvidedLatestImage;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCustomDbEngineVersionRequest build() {
            return new CreateCustomDbEngineVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
