/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.AvailabilityZonesCopier;
import software.amazon.awssdk.services.rds.model.LogTypeListCopier;
import software.amazon.awssdk.services.rds.model.RdsCustomClusterConfiguration;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.model.ScalingConfiguration;
import software.amazon.awssdk.services.rds.model.ServerlessV2ScalingConfiguration;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDbClusterRequest
extends RdsRequest
implements ToCopyableBuilder<Builder, CreateDbClusterRequest> {
    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AvailabilityZones").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::availabilityZones)).setter(CreateDbClusterRequest.setter(Builder::availabilityZones)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(), ListTrait.builder().memberLocationName("AvailabilityZone").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build()).build()}).build();
    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BackupRetentionPeriod").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::backupRetentionPeriod)).setter(CreateDbClusterRequest.setter(Builder::backupRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build()}).build();
    private static final SdkField<String> CHARACTER_SET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CharacterSetName").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::characterSetName)).setter(CreateDbClusterRequest.setter(Builder::characterSetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CharacterSetName").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::databaseName)).setter(CreateDbClusterRequest.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterIdentifier").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::dbClusterIdentifier)).setter(CreateDbClusterRequest.setter(Builder::dbClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build()}).build();
    private static final SdkField<String> DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterParameterGroupName").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::dbClusterParameterGroupName)).setter(CreateDbClusterRequest.setter(Builder::dbClusterParameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterParameterGroupName").build()}).build();
    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSecurityGroupIds").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::vpcSecurityGroupIds)).setter(CreateDbClusterRequest.setter(Builder::vpcSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(), ListTrait.builder().memberLocationName("VpcSecurityGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupId").build()}).build()).build()}).build();
    private static final SdkField<String> DB_SUBNET_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBSubnetGroupName").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::dbSubnetGroupName)).setter(CreateDbClusterRequest.setter(Builder::dbSubnetGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroupName").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::engine)).setter(CreateDbClusterRequest.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::engineVersion)).setter(CreateDbClusterRequest.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::port)).setter(CreateDbClusterRequest.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterUsername").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::masterUsername)).setter(CreateDbClusterRequest.setter(Builder::masterUsername)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()}).build();
    private static final SdkField<String> MASTER_USER_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterUserPassword").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::masterUserPassword)).setter(CreateDbClusterRequest.setter(Builder::masterUserPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserPassword").build()}).build();
    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptionGroupName").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::optionGroupName)).setter(CreateDbClusterRequest.setter(Builder::optionGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()}).build();
    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredBackupWindow").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::preferredBackupWindow)).setter(CreateDbClusterRequest.setter(Builder::preferredBackupWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredMaintenanceWindow").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::preferredMaintenanceWindow)).setter(CreateDbClusterRequest.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build()}).build();
    private static final SdkField<String> REPLICATION_SOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplicationSourceIdentifier").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::replicationSourceIdentifier)).setter(CreateDbClusterRequest.setter(Builder::replicationSourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationSourceIdentifier").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::tags)).setter(CreateDbClusterRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final SdkField<Boolean> STORAGE_ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("StorageEncrypted").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::storageEncrypted)).setter(CreateDbClusterRequest.setter(Builder::storageEncrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEncrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::kmsKeyId)).setter(CreateDbClusterRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> PRE_SIGNED_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreSignedUrl").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::preSignedUrl)).setter(CreateDbClusterRequest.setter(Builder::preSignedUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreSignedUrl").build()}).build();
    private static final SdkField<Boolean> ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableIAMDatabaseAuthentication").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::enableIAMDatabaseAuthentication)).setter(CreateDbClusterRequest.setter(Builder::enableIAMDatabaseAuthentication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIAMDatabaseAuthentication").build()}).build();
    private static final SdkField<Long> BACKTRACK_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BacktrackWindow").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::backtrackWindow)).setter(CreateDbClusterRequest.setter(Builder::backtrackWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BacktrackWindow").build()}).build();
    private static final SdkField<List<String>> ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnableCloudwatchLogsExports").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::enableCloudwatchLogsExports)).setter(CreateDbClusterRequest.setter(Builder::enableCloudwatchLogsExports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCloudwatchLogsExports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ENGINE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineMode").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::engineMode)).setter(CreateDbClusterRequest.setter(Builder::engineMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineMode").build()}).build();
    private static final SdkField<ScalingConfiguration> SCALING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScalingConfiguration").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::scalingConfiguration)).setter(CreateDbClusterRequest.setter(Builder::scalingConfiguration)).constructor(ScalingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingConfiguration").build()}).build();
    private static final SdkField<RdsCustomClusterConfiguration> RDS_CUSTOM_CLUSTER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RdsCustomClusterConfiguration").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::rdsCustomClusterConfiguration)).setter(CreateDbClusterRequest.setter(Builder::rdsCustomClusterConfiguration)).constructor(RdsCustomClusterConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RdsCustomClusterConfiguration").build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeletionProtection").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::deletionProtection)).setter(CreateDbClusterRequest.setter(Builder::deletionProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build()}).build();
    private static final SdkField<String> GLOBAL_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GlobalClusterIdentifier").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::globalClusterIdentifier)).setter(CreateDbClusterRequest.setter(Builder::globalClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalClusterIdentifier").build()}).build();
    private static final SdkField<Boolean> ENABLE_HTTP_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableHttpEndpoint").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::enableHttpEndpoint)).setter(CreateDbClusterRequest.setter(Builder::enableHttpEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableHttpEndpoint").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTagsToSnapshot").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::copyTagsToSnapshot)).setter(CreateDbClusterRequest.setter(Builder::copyTagsToSnapshot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshot").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::domain)).setter(CreateDbClusterRequest.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").build()}).build();
    private static final SdkField<String> DOMAIN_IAM_ROLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainIAMRoleName").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::domainIAMRoleName)).setter(CreateDbClusterRequest.setter(Builder::domainIAMRoleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainIAMRoleName").build()}).build();
    private static final SdkField<Boolean> ENABLE_GLOBAL_WRITE_FORWARDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableGlobalWriteForwarding").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::enableGlobalWriteForwarding)).setter(CreateDbClusterRequest.setter(Builder::enableGlobalWriteForwarding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableGlobalWriteForwarding").build()}).build();
    private static final SdkField<String> DB_CLUSTER_INSTANCE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBClusterInstanceClass").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::dbClusterInstanceClass)).setter(CreateDbClusterRequest.setter(Builder::dbClusterInstanceClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterInstanceClass").build()}).build();
    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocatedStorage").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::allocatedStorage)).setter(CreateDbClusterRequest.setter(Builder::allocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageType").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::storageType)).setter(CreateDbClusterRequest.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()}).build();
    private static final SdkField<Integer> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Iops").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::iops)).setter(CreateDbClusterRequest.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PubliclyAccessible").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::publiclyAccessible)).setter(CreateDbClusterRequest.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build()}).build();
    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoMinorVersionUpgrade").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::autoMinorVersionUpgrade)).setter(CreateDbClusterRequest.setter(Builder::autoMinorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build()}).build();
    private static final SdkField<Integer> MONITORING_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MonitoringInterval").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::monitoringInterval)).setter(CreateDbClusterRequest.setter(Builder::monitoringInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringInterval").build()}).build();
    private static final SdkField<String> MONITORING_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitoringRoleArn").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::monitoringRoleArn)).setter(CreateDbClusterRequest.setter(Builder::monitoringRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringRoleArn").build()}).build();
    private static final SdkField<Boolean> ENABLE_PERFORMANCE_INSIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnablePerformanceInsights").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::enablePerformanceInsights)).setter(CreateDbClusterRequest.setter(Builder::enablePerformanceInsights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePerformanceInsights").build()}).build();
    private static final SdkField<String> PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PerformanceInsightsKMSKeyId").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::performanceInsightsKMSKeyId)).setter(CreateDbClusterRequest.setter(Builder::performanceInsightsKMSKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsKMSKeyId").build()}).build();
    private static final SdkField<Integer> PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PerformanceInsightsRetentionPeriod").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::performanceInsightsRetentionPeriod)).setter(CreateDbClusterRequest.setter(Builder::performanceInsightsRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsRetentionPeriod").build()}).build();
    private static final SdkField<Boolean> ENABLE_LIMITLESS_DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableLimitlessDatabase").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::enableLimitlessDatabase)).setter(CreateDbClusterRequest.setter(Builder::enableLimitlessDatabase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableLimitlessDatabase").build()}).build();
    private static final SdkField<ServerlessV2ScalingConfiguration> SERVERLESS_V2_SCALING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ServerlessV2ScalingConfiguration").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::serverlessV2ScalingConfiguration)).setter(CreateDbClusterRequest.setter(Builder::serverlessV2ScalingConfiguration)).constructor(ServerlessV2ScalingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerlessV2ScalingConfiguration").build()}).build();
    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkType").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::networkType)).setter(CreateDbClusterRequest.setter(Builder::networkType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType").build()}).build();
    private static final SdkField<String> DB_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBSystemId").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::dbSystemId)).setter(CreateDbClusterRequest.setter(Builder::dbSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSystemId").build()}).build();
    private static final SdkField<Boolean> MANAGE_MASTER_USER_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ManageMasterUserPassword").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::manageMasterUserPassword)).setter(CreateDbClusterRequest.setter(Builder::manageMasterUserPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManageMasterUserPassword").build()}).build();
    private static final SdkField<String> MASTER_USER_SECRET_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterUserSecretKmsKeyId").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::masterUserSecretKmsKeyId)).setter(CreateDbClusterRequest.setter(Builder::masterUserSecretKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserSecretKmsKeyId").build()}).build();
    private static final SdkField<Boolean> ENABLE_LOCAL_WRITE_FORWARDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableLocalWriteForwarding").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::enableLocalWriteForwarding)).setter(CreateDbClusterRequest.setter(Builder::enableLocalWriteForwarding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableLocalWriteForwarding").build()}).build();
    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceRegion").getter(CreateDbClusterRequest.getter(CreateDbClusterRequest::sourceRegion)).setter(CreateDbClusterRequest.setter(Builder::sourceRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceRegion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONES_FIELD, BACKUP_RETENTION_PERIOD_FIELD, CHARACTER_SET_NAME_FIELD, DATABASE_NAME_FIELD, DB_CLUSTER_IDENTIFIER_FIELD, DB_CLUSTER_PARAMETER_GROUP_NAME_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, DB_SUBNET_GROUP_NAME_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, PORT_FIELD, MASTER_USERNAME_FIELD, MASTER_USER_PASSWORD_FIELD, OPTION_GROUP_NAME_FIELD, PREFERRED_BACKUP_WINDOW_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, REPLICATION_SOURCE_IDENTIFIER_FIELD, TAGS_FIELD, STORAGE_ENCRYPTED_FIELD, KMS_KEY_ID_FIELD, PRE_SIGNED_URL_FIELD, ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD, BACKTRACK_WINDOW_FIELD, ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD, ENGINE_MODE_FIELD, SCALING_CONFIGURATION_FIELD, RDS_CUSTOM_CLUSTER_CONFIGURATION_FIELD, DELETION_PROTECTION_FIELD, GLOBAL_CLUSTER_IDENTIFIER_FIELD, ENABLE_HTTP_ENDPOINT_FIELD, COPY_TAGS_TO_SNAPSHOT_FIELD, DOMAIN_FIELD, DOMAIN_IAM_ROLE_NAME_FIELD, ENABLE_GLOBAL_WRITE_FORWARDING_FIELD, DB_CLUSTER_INSTANCE_CLASS_FIELD, ALLOCATED_STORAGE_FIELD, STORAGE_TYPE_FIELD, IOPS_FIELD, PUBLICLY_ACCESSIBLE_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, MONITORING_INTERVAL_FIELD, MONITORING_ROLE_ARN_FIELD, ENABLE_PERFORMANCE_INSIGHTS_FIELD, PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD, PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD, ENABLE_LIMITLESS_DATABASE_FIELD, SERVERLESS_V2_SCALING_CONFIGURATION_FIELD, NETWORK_TYPE_FIELD, DB_SYSTEM_ID_FIELD, MANAGE_MASTER_USER_PASSWORD_FIELD, MASTER_USER_SECRET_KMS_KEY_ID_FIELD, ENABLE_LOCAL_WRITE_FORWARDING_FIELD, SOURCE_REGION_FIELD));
    private final List<String> availabilityZones;
    private final Integer backupRetentionPeriod;
    private final String characterSetName;
    private final String databaseName;
    private final String dbClusterIdentifier;
    private final String dbClusterParameterGroupName;
    private final List<String> vpcSecurityGroupIds;
    private final String dbSubnetGroupName;
    private final String engine;
    private final String engineVersion;
    private final Integer port;
    private final String masterUsername;
    private final String masterUserPassword;
    private final String optionGroupName;
    private final String preferredBackupWindow;
    private final String preferredMaintenanceWindow;
    private final String replicationSourceIdentifier;
    private final List<Tag> tags;
    private final Boolean storageEncrypted;
    private final String kmsKeyId;
    private final String preSignedUrl;
    private final Boolean enableIAMDatabaseAuthentication;
    private final Long backtrackWindow;
    private final List<String> enableCloudwatchLogsExports;
    private final String engineMode;
    private final ScalingConfiguration scalingConfiguration;
    private final RdsCustomClusterConfiguration rdsCustomClusterConfiguration;
    private final Boolean deletionProtection;
    private final String globalClusterIdentifier;
    private final Boolean enableHttpEndpoint;
    private final Boolean copyTagsToSnapshot;
    private final String domain;
    private final String domainIAMRoleName;
    private final Boolean enableGlobalWriteForwarding;
    private final String dbClusterInstanceClass;
    private final Integer allocatedStorage;
    private final String storageType;
    private final Integer iops;
    private final Boolean publiclyAccessible;
    private final Boolean autoMinorVersionUpgrade;
    private final Integer monitoringInterval;
    private final String monitoringRoleArn;
    private final Boolean enablePerformanceInsights;
    private final String performanceInsightsKMSKeyId;
    private final Integer performanceInsightsRetentionPeriod;
    private final Boolean enableLimitlessDatabase;
    private final ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration;
    private final String networkType;
    private final String dbSystemId;
    private final Boolean manageMasterUserPassword;
    private final String masterUserSecretKmsKeyId;
    private final Boolean enableLocalWriteForwarding;
    private final String sourceRegion;

    private CreateDbClusterRequest(BuilderImpl builder) {
        super(builder);
        this.availabilityZones = builder.availabilityZones;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.characterSetName = builder.characterSetName;
        this.databaseName = builder.databaseName;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.dbClusterParameterGroupName = builder.dbClusterParameterGroupName;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.port = builder.port;
        this.masterUsername = builder.masterUsername;
        this.masterUserPassword = builder.masterUserPassword;
        this.optionGroupName = builder.optionGroupName;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.replicationSourceIdentifier = builder.replicationSourceIdentifier;
        this.tags = builder.tags;
        this.storageEncrypted = builder.storageEncrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.preSignedUrl = builder.preSignedUrl;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
        this.backtrackWindow = builder.backtrackWindow;
        this.enableCloudwatchLogsExports = builder.enableCloudwatchLogsExports;
        this.engineMode = builder.engineMode;
        this.scalingConfiguration = builder.scalingConfiguration;
        this.rdsCustomClusterConfiguration = builder.rdsCustomClusterConfiguration;
        this.deletionProtection = builder.deletionProtection;
        this.globalClusterIdentifier = builder.globalClusterIdentifier;
        this.enableHttpEndpoint = builder.enableHttpEndpoint;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.domain = builder.domain;
        this.domainIAMRoleName = builder.domainIAMRoleName;
        this.enableGlobalWriteForwarding = builder.enableGlobalWriteForwarding;
        this.dbClusterInstanceClass = builder.dbClusterInstanceClass;
        this.allocatedStorage = builder.allocatedStorage;
        this.storageType = builder.storageType;
        this.iops = builder.iops;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.monitoringInterval = builder.monitoringInterval;
        this.monitoringRoleArn = builder.monitoringRoleArn;
        this.enablePerformanceInsights = builder.enablePerformanceInsights;
        this.performanceInsightsKMSKeyId = builder.performanceInsightsKMSKeyId;
        this.performanceInsightsRetentionPeriod = builder.performanceInsightsRetentionPeriod;
        this.enableLimitlessDatabase = builder.enableLimitlessDatabase;
        this.serverlessV2ScalingConfiguration = builder.serverlessV2ScalingConfiguration;
        this.networkType = builder.networkType;
        this.dbSystemId = builder.dbSystemId;
        this.manageMasterUserPassword = builder.manageMasterUserPassword;
        this.masterUserSecretKmsKeyId = builder.masterUserSecretKmsKeyId;
        this.enableLocalWriteForwarding = builder.enableLocalWriteForwarding;
        this.sourceRegion = builder.sourceRegion;
    }

    public final boolean hasAvailabilityZones() {
        return this.availabilityZones != null && !(this.availabilityZones instanceof SdkAutoConstructList);
    }

    public final List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public final Integer backupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public final String characterSetName() {
        return this.characterSetName;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public final String dbClusterParameterGroupName() {
        return this.dbClusterParameterGroupName;
    }

    public final boolean hasVpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds != null && !(this.vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public final String dbSubnetGroupName() {
        return this.dbSubnetGroupName;
    }

    public final String engine() {
        return this.engine;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final Integer port() {
        return this.port;
    }

    public final String masterUsername() {
        return this.masterUsername;
    }

    public final String masterUserPassword() {
        return this.masterUserPassword;
    }

    public final String optionGroupName() {
        return this.optionGroupName;
    }

    public final String preferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public final String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public final String replicationSourceIdentifier() {
        return this.replicationSourceIdentifier;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final Boolean storageEncrypted() {
        return this.storageEncrypted;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String preSignedUrl() {
        return this.preSignedUrl;
    }

    public final Boolean enableIAMDatabaseAuthentication() {
        return this.enableIAMDatabaseAuthentication;
    }

    public final Long backtrackWindow() {
        return this.backtrackWindow;
    }

    public final boolean hasEnableCloudwatchLogsExports() {
        return this.enableCloudwatchLogsExports != null && !(this.enableCloudwatchLogsExports instanceof SdkAutoConstructList);
    }

    public final List<String> enableCloudwatchLogsExports() {
        return this.enableCloudwatchLogsExports;
    }

    public final String engineMode() {
        return this.engineMode;
    }

    public final ScalingConfiguration scalingConfiguration() {
        return this.scalingConfiguration;
    }

    public final RdsCustomClusterConfiguration rdsCustomClusterConfiguration() {
        return this.rdsCustomClusterConfiguration;
    }

    public final Boolean deletionProtection() {
        return this.deletionProtection;
    }

    public final String globalClusterIdentifier() {
        return this.globalClusterIdentifier;
    }

    public final Boolean enableHttpEndpoint() {
        return this.enableHttpEndpoint;
    }

    public final Boolean copyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public final String domain() {
        return this.domain;
    }

    public final String domainIAMRoleName() {
        return this.domainIAMRoleName;
    }

    public final Boolean enableGlobalWriteForwarding() {
        return this.enableGlobalWriteForwarding;
    }

    public final String dbClusterInstanceClass() {
        return this.dbClusterInstanceClass;
    }

    public final Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public final String storageType() {
        return this.storageType;
    }

    public final Integer iops() {
        return this.iops;
    }

    public final Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public final Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public final Integer monitoringInterval() {
        return this.monitoringInterval;
    }

    public final String monitoringRoleArn() {
        return this.monitoringRoleArn;
    }

    public final Boolean enablePerformanceInsights() {
        return this.enablePerformanceInsights;
    }

    public final String performanceInsightsKMSKeyId() {
        return this.performanceInsightsKMSKeyId;
    }

    public final Integer performanceInsightsRetentionPeriod() {
        return this.performanceInsightsRetentionPeriod;
    }

    public final Boolean enableLimitlessDatabase() {
        return this.enableLimitlessDatabase;
    }

    public final ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration() {
        return this.serverlessV2ScalingConfiguration;
    }

    public final String networkType() {
        return this.networkType;
    }

    public final String dbSystemId() {
        return this.dbSystemId;
    }

    public final Boolean manageMasterUserPassword() {
        return this.manageMasterUserPassword;
    }

    public final String masterUserSecretKmsKeyId() {
        return this.masterUserSecretKmsKeyId;
    }

    public final Boolean enableLocalWriteForwarding() {
        return this.enableLocalWriteForwarding;
    }

    public final String sourceRegion() {
        return this.sourceRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAvailabilityZones() ? this.availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.characterSetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationSourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.storageEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.preSignedUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableIAMDatabaseAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.backtrackWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnableCloudwatchLogsExports() ? this.enableCloudwatchLogsExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.engineMode());
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.rdsCustomClusterConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableHttpEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIAMRoleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableGlobalWriteForwarding());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablePerformanceInsights());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceInsightsKMSKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceInsightsRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableLimitlessDatabase());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverlessV2ScalingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkType());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.manageMasterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUserSecretKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableLocalWriteForwarding());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceRegion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDbClusterRequest)) {
            return false;
        }
        CreateDbClusterRequest other = (CreateDbClusterRequest)((Object)obj);
        return this.hasAvailabilityZones() == other.hasAvailabilityZones() && Objects.equals(this.availabilityZones(), other.availabilityZones()) && Objects.equals(this.backupRetentionPeriod(), other.backupRetentionPeriod()) && Objects.equals(this.characterSetName(), other.characterSetName()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.dbClusterParameterGroupName(), other.dbClusterParameterGroupName()) && this.hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds() && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && Objects.equals(this.dbSubnetGroupName(), other.dbSubnetGroupName()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.masterUsername(), other.masterUsername()) && Objects.equals(this.masterUserPassword(), other.masterUserPassword()) && Objects.equals(this.optionGroupName(), other.optionGroupName()) && Objects.equals(this.preferredBackupWindow(), other.preferredBackupWindow()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.replicationSourceIdentifier(), other.replicationSourceIdentifier()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.storageEncrypted(), other.storageEncrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.preSignedUrl(), other.preSignedUrl()) && Objects.equals(this.enableIAMDatabaseAuthentication(), other.enableIAMDatabaseAuthentication()) && Objects.equals(this.backtrackWindow(), other.backtrackWindow()) && this.hasEnableCloudwatchLogsExports() == other.hasEnableCloudwatchLogsExports() && Objects.equals(this.enableCloudwatchLogsExports(), other.enableCloudwatchLogsExports()) && Objects.equals(this.engineMode(), other.engineMode()) && Objects.equals(this.scalingConfiguration(), other.scalingConfiguration()) && Objects.equals(this.rdsCustomClusterConfiguration(), other.rdsCustomClusterConfiguration()) && Objects.equals(this.deletionProtection(), other.deletionProtection()) && Objects.equals(this.globalClusterIdentifier(), other.globalClusterIdentifier()) && Objects.equals(this.enableHttpEndpoint(), other.enableHttpEndpoint()) && Objects.equals(this.copyTagsToSnapshot(), other.copyTagsToSnapshot()) && Objects.equals(this.domain(), other.domain()) && Objects.equals(this.domainIAMRoleName(), other.domainIAMRoleName()) && Objects.equals(this.enableGlobalWriteForwarding(), other.enableGlobalWriteForwarding()) && Objects.equals(this.dbClusterInstanceClass(), other.dbClusterInstanceClass()) && Objects.equals(this.allocatedStorage(), other.allocatedStorage()) && Objects.equals(this.storageType(), other.storageType()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.monitoringInterval(), other.monitoringInterval()) && Objects.equals(this.monitoringRoleArn(), other.monitoringRoleArn()) && Objects.equals(this.enablePerformanceInsights(), other.enablePerformanceInsights()) && Objects.equals(this.performanceInsightsKMSKeyId(), other.performanceInsightsKMSKeyId()) && Objects.equals(this.performanceInsightsRetentionPeriod(), other.performanceInsightsRetentionPeriod()) && Objects.equals(this.enableLimitlessDatabase(), other.enableLimitlessDatabase()) && Objects.equals(this.serverlessV2ScalingConfiguration(), other.serverlessV2ScalingConfiguration()) && Objects.equals(this.networkType(), other.networkType()) && Objects.equals(this.dbSystemId(), other.dbSystemId()) && Objects.equals(this.manageMasterUserPassword(), other.manageMasterUserPassword()) && Objects.equals(this.masterUserSecretKmsKeyId(), other.masterUserSecretKmsKeyId()) && Objects.equals(this.enableLocalWriteForwarding(), other.enableLocalWriteForwarding()) && Objects.equals(this.sourceRegion(), other.sourceRegion());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDbClusterRequest").add("AvailabilityZones", this.hasAvailabilityZones() ? this.availabilityZones() : null).add("BackupRetentionPeriod", (Object)this.backupRetentionPeriod()).add("CharacterSetName", (Object)this.characterSetName()).add("DatabaseName", (Object)this.databaseName()).add("DBClusterIdentifier", (Object)this.dbClusterIdentifier()).add("DBClusterParameterGroupName", (Object)this.dbClusterParameterGroupName()).add("VpcSecurityGroupIds", this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null).add("DBSubnetGroupName", (Object)this.dbSubnetGroupName()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("Port", (Object)this.port()).add("MasterUsername", (Object)this.masterUsername()).add("MasterUserPassword", (Object)this.masterUserPassword()).add("OptionGroupName", (Object)this.optionGroupName()).add("PreferredBackupWindow", (Object)this.preferredBackupWindow()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("ReplicationSourceIdentifier", (Object)this.replicationSourceIdentifier()).add("Tags", this.hasTags() ? this.tags() : null).add("StorageEncrypted", (Object)this.storageEncrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).add("PreSignedUrl", (Object)this.preSignedUrl()).add("EnableIAMDatabaseAuthentication", (Object)this.enableIAMDatabaseAuthentication()).add("BacktrackWindow", (Object)this.backtrackWindow()).add("EnableCloudwatchLogsExports", this.hasEnableCloudwatchLogsExports() ? this.enableCloudwatchLogsExports() : null).add("EngineMode", (Object)this.engineMode()).add("ScalingConfiguration", (Object)this.scalingConfiguration()).add("RdsCustomClusterConfiguration", (Object)this.rdsCustomClusterConfiguration()).add("DeletionProtection", (Object)this.deletionProtection()).add("GlobalClusterIdentifier", (Object)this.globalClusterIdentifier()).add("EnableHttpEndpoint", (Object)this.enableHttpEndpoint()).add("CopyTagsToSnapshot", (Object)this.copyTagsToSnapshot()).add("Domain", (Object)this.domain()).add("DomainIAMRoleName", (Object)this.domainIAMRoleName()).add("EnableGlobalWriteForwarding", (Object)this.enableGlobalWriteForwarding()).add("DBClusterInstanceClass", (Object)this.dbClusterInstanceClass()).add("AllocatedStorage", (Object)this.allocatedStorage()).add("StorageType", (Object)this.storageType()).add("Iops", (Object)this.iops()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("MonitoringInterval", (Object)this.monitoringInterval()).add("MonitoringRoleArn", (Object)this.monitoringRoleArn()).add("EnablePerformanceInsights", (Object)this.enablePerformanceInsights()).add("PerformanceInsightsKMSKeyId", (Object)this.performanceInsightsKMSKeyId()).add("PerformanceInsightsRetentionPeriod", (Object)this.performanceInsightsRetentionPeriod()).add("EnableLimitlessDatabase", (Object)this.enableLimitlessDatabase()).add("ServerlessV2ScalingConfiguration", (Object)this.serverlessV2ScalingConfiguration()).add("NetworkType", (Object)this.networkType()).add("DBSystemId", (Object)this.dbSystemId()).add("ManageMasterUserPassword", (Object)this.manageMasterUserPassword()).add("MasterUserSecretKmsKeyId", (Object)this.masterUserSecretKmsKeyId()).add("EnableLocalWriteForwarding", (Object)this.enableLocalWriteForwarding()).add("SourceRegion", (Object)this.sourceRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZones": {
                return Optional.ofNullable(clazz.cast(this.availabilityZones()));
            }
            case "BackupRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.backupRetentionPeriod()));
            }
            case "CharacterSetName": {
                return Optional.ofNullable(clazz.cast(this.characterSetName()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "DBClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "DBClusterParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbClusterParameterGroupName()));
            }
            case "VpcSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroupIds()));
            }
            case "DBSubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbSubnetGroupName()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "MasterUsername": {
                return Optional.ofNullable(clazz.cast(this.masterUsername()));
            }
            case "MasterUserPassword": {
                return Optional.ofNullable(clazz.cast(this.masterUserPassword()));
            }
            case "OptionGroupName": {
                return Optional.ofNullable(clazz.cast(this.optionGroupName()));
            }
            case "PreferredBackupWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredBackupWindow()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "ReplicationSourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.replicationSourceIdentifier()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "StorageEncrypted": {
                return Optional.ofNullable(clazz.cast(this.storageEncrypted()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "PreSignedUrl": {
                return Optional.ofNullable(clazz.cast(this.preSignedUrl()));
            }
            case "EnableIAMDatabaseAuthentication": {
                return Optional.ofNullable(clazz.cast(this.enableIAMDatabaseAuthentication()));
            }
            case "BacktrackWindow": {
                return Optional.ofNullable(clazz.cast(this.backtrackWindow()));
            }
            case "EnableCloudwatchLogsExports": {
                return Optional.ofNullable(clazz.cast(this.enableCloudwatchLogsExports()));
            }
            case "EngineMode": {
                return Optional.ofNullable(clazz.cast(this.engineMode()));
            }
            case "ScalingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.scalingConfiguration()));
            }
            case "RdsCustomClusterConfiguration": {
                return Optional.ofNullable(clazz.cast(this.rdsCustomClusterConfiguration()));
            }
            case "DeletionProtection": {
                return Optional.ofNullable(clazz.cast(this.deletionProtection()));
            }
            case "GlobalClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.globalClusterIdentifier()));
            }
            case "EnableHttpEndpoint": {
                return Optional.ofNullable(clazz.cast(this.enableHttpEndpoint()));
            }
            case "CopyTagsToSnapshot": {
                return Optional.ofNullable(clazz.cast(this.copyTagsToSnapshot()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "DomainIAMRoleName": {
                return Optional.ofNullable(clazz.cast(this.domainIAMRoleName()));
            }
            case "EnableGlobalWriteForwarding": {
                return Optional.ofNullable(clazz.cast(this.enableGlobalWriteForwarding()));
            }
            case "DBClusterInstanceClass": {
                return Optional.ofNullable(clazz.cast(this.dbClusterInstanceClass()));
            }
            case "AllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.allocatedStorage()));
            }
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageType()));
            }
            case "Iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "PubliclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "MonitoringInterval": {
                return Optional.ofNullable(clazz.cast(this.monitoringInterval()));
            }
            case "MonitoringRoleArn": {
                return Optional.ofNullable(clazz.cast(this.monitoringRoleArn()));
            }
            case "EnablePerformanceInsights": {
                return Optional.ofNullable(clazz.cast(this.enablePerformanceInsights()));
            }
            case "PerformanceInsightsKMSKeyId": {
                return Optional.ofNullable(clazz.cast(this.performanceInsightsKMSKeyId()));
            }
            case "PerformanceInsightsRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.performanceInsightsRetentionPeriod()));
            }
            case "EnableLimitlessDatabase": {
                return Optional.ofNullable(clazz.cast(this.enableLimitlessDatabase()));
            }
            case "ServerlessV2ScalingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.serverlessV2ScalingConfiguration()));
            }
            case "NetworkType": {
                return Optional.ofNullable(clazz.cast(this.networkType()));
            }
            case "DBSystemId": {
                return Optional.ofNullable(clazz.cast(this.dbSystemId()));
            }
            case "ManageMasterUserPassword": {
                return Optional.ofNullable(clazz.cast(this.manageMasterUserPassword()));
            }
            case "MasterUserSecretKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.masterUserSecretKmsKeyId()));
            }
            case "EnableLocalWriteForwarding": {
                return Optional.ofNullable(clazz.cast(this.enableLocalWriteForwarding()));
            }
            case "SourceRegion": {
                return Optional.ofNullable(clazz.cast(this.sourceRegion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDbClusterRequest, T> g) {
        return obj -> g.apply((CreateDbClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();
        private Integer backupRetentionPeriod;
        private String characterSetName;
        private String databaseName;
        private String dbClusterIdentifier;
        private String dbClusterParameterGroupName;
        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String dbSubnetGroupName;
        private String engine;
        private String engineVersion;
        private Integer port;
        private String masterUsername;
        private String masterUserPassword;
        private String optionGroupName;
        private String preferredBackupWindow;
        private String preferredMaintenanceWindow;
        private String replicationSourceIdentifier;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Boolean storageEncrypted;
        private String kmsKeyId;
        private String preSignedUrl;
        private Boolean enableIAMDatabaseAuthentication;
        private Long backtrackWindow;
        private List<String> enableCloudwatchLogsExports = DefaultSdkAutoConstructList.getInstance();
        private String engineMode;
        private ScalingConfiguration scalingConfiguration;
        private RdsCustomClusterConfiguration rdsCustomClusterConfiguration;
        private Boolean deletionProtection;
        private String globalClusterIdentifier;
        private Boolean enableHttpEndpoint;
        private Boolean copyTagsToSnapshot;
        private String domain;
        private String domainIAMRoleName;
        private Boolean enableGlobalWriteForwarding;
        private String dbClusterInstanceClass;
        private Integer allocatedStorage;
        private String storageType;
        private Integer iops;
        private Boolean publiclyAccessible;
        private Boolean autoMinorVersionUpgrade;
        private Integer monitoringInterval;
        private String monitoringRoleArn;
        private Boolean enablePerformanceInsights;
        private String performanceInsightsKMSKeyId;
        private Integer performanceInsightsRetentionPeriod;
        private Boolean enableLimitlessDatabase;
        private ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration;
        private String networkType;
        private String dbSystemId;
        private Boolean manageMasterUserPassword;
        private String masterUserSecretKmsKeyId;
        private Boolean enableLocalWriteForwarding;
        private String sourceRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDbClusterRequest model) {
            super(model);
            this.availabilityZones(model.availabilityZones);
            this.backupRetentionPeriod(model.backupRetentionPeriod);
            this.characterSetName(model.characterSetName);
            this.databaseName(model.databaseName);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.dbClusterParameterGroupName(model.dbClusterParameterGroupName);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.dbSubnetGroupName(model.dbSubnetGroupName);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.port(model.port);
            this.masterUsername(model.masterUsername);
            this.masterUserPassword(model.masterUserPassword);
            this.optionGroupName(model.optionGroupName);
            this.preferredBackupWindow(model.preferredBackupWindow);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.replicationSourceIdentifier(model.replicationSourceIdentifier);
            this.tags(model.tags);
            this.storageEncrypted(model.storageEncrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.preSignedUrl(model.preSignedUrl);
            this.enableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
            this.backtrackWindow(model.backtrackWindow);
            this.enableCloudwatchLogsExports(model.enableCloudwatchLogsExports);
            this.engineMode(model.engineMode);
            this.scalingConfiguration(model.scalingConfiguration);
            this.rdsCustomClusterConfiguration(model.rdsCustomClusterConfiguration);
            this.deletionProtection(model.deletionProtection);
            this.globalClusterIdentifier(model.globalClusterIdentifier);
            this.enableHttpEndpoint(model.enableHttpEndpoint);
            this.copyTagsToSnapshot(model.copyTagsToSnapshot);
            this.domain(model.domain);
            this.domainIAMRoleName(model.domainIAMRoleName);
            this.enableGlobalWriteForwarding(model.enableGlobalWriteForwarding);
            this.dbClusterInstanceClass(model.dbClusterInstanceClass);
            this.allocatedStorage(model.allocatedStorage);
            this.storageType(model.storageType);
            this.iops(model.iops);
            this.publiclyAccessible(model.publiclyAccessible);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.monitoringInterval(model.monitoringInterval);
            this.monitoringRoleArn(model.monitoringRoleArn);
            this.enablePerformanceInsights(model.enablePerformanceInsights);
            this.performanceInsightsKMSKeyId(model.performanceInsightsKMSKeyId);
            this.performanceInsightsRetentionPeriod(model.performanceInsightsRetentionPeriod);
            this.enableLimitlessDatabase(model.enableLimitlessDatabase);
            this.serverlessV2ScalingConfiguration(model.serverlessV2ScalingConfiguration);
            this.networkType(model.networkType);
            this.dbSystemId(model.dbSystemId);
            this.manageMasterUserPassword(model.manageMasterUserPassword);
            this.masterUserSecretKmsKeyId(model.masterUserSecretKmsKeyId);
            this.enableLocalWriteForwarding(model.enableLocalWriteForwarding);
            this.sourceRegion(model.sourceRegion);
        }

        public final Collection<String> getAvailabilityZones() {
            if (this.availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return this.availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = AvailabilityZonesCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String ... availabilityZones) {
            this.availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final Integer getBackupRetentionPeriod() {
            return this.backupRetentionPeriod;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final String getCharacterSetName() {
            return this.characterSetName;
        }

        public final void setCharacterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
        }

        @Override
        public final Builder characterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final String getDbClusterParameterGroupName() {
            return this.dbClusterParameterGroupName;
        }

        public final void setDbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
        }

        @Override
        public final Builder dbClusterParameterGroupName(String dbClusterParameterGroupName) {
            this.dbClusterParameterGroupName = dbClusterParameterGroupName;
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (this.vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final String getDbSubnetGroupName() {
            return this.dbSubnetGroupName;
        }

        public final void setDbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final String getMasterUsername() {
            return this.masterUsername;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final String getMasterUserPassword() {
            return this.masterUserPassword;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final String getReplicationSourceIdentifier() {
            return this.replicationSourceIdentifier;
        }

        public final void setReplicationSourceIdentifier(String replicationSourceIdentifier) {
            this.replicationSourceIdentifier = replicationSourceIdentifier;
        }

        @Override
        public final Builder replicationSourceIdentifier(String replicationSourceIdentifier) {
            this.replicationSourceIdentifier = replicationSourceIdentifier;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getStorageEncrypted() {
            return this.storageEncrypted;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getPreSignedUrl() {
            return this.preSignedUrl;
        }

        public final void setPreSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
        }

        @Override
        public final Builder preSignedUrl(String preSignedUrl) {
            this.preSignedUrl = preSignedUrl;
            return this;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return this.enableIAMDatabaseAuthentication;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final Long getBacktrackWindow() {
            return this.backtrackWindow;
        }

        public final void setBacktrackWindow(Long backtrackWindow) {
            this.backtrackWindow = backtrackWindow;
        }

        @Override
        public final Builder backtrackWindow(Long backtrackWindow) {
            this.backtrackWindow = backtrackWindow;
            return this;
        }

        public final Collection<String> getEnableCloudwatchLogsExports() {
            if (this.enableCloudwatchLogsExports instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enableCloudwatchLogsExports;
        }

        public final void setEnableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
        }

        @Override
        public final Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enableCloudwatchLogsExports(String ... enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports(Arrays.asList(enableCloudwatchLogsExports));
            return this;
        }

        public final String getEngineMode() {
            return this.engineMode;
        }

        public final void setEngineMode(String engineMode) {
            this.engineMode = engineMode;
        }

        @Override
        public final Builder engineMode(String engineMode) {
            this.engineMode = engineMode;
            return this;
        }

        public final ScalingConfiguration.Builder getScalingConfiguration() {
            return this.scalingConfiguration != null ? this.scalingConfiguration.toBuilder() : null;
        }

        public final void setScalingConfiguration(ScalingConfiguration.BuilderImpl scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration != null ? scalingConfiguration.build() : null;
        }

        @Override
        public final Builder scalingConfiguration(ScalingConfiguration scalingConfiguration) {
            this.scalingConfiguration = scalingConfiguration;
            return this;
        }

        public final RdsCustomClusterConfiguration.Builder getRdsCustomClusterConfiguration() {
            return this.rdsCustomClusterConfiguration != null ? this.rdsCustomClusterConfiguration.toBuilder() : null;
        }

        public final void setRdsCustomClusterConfiguration(RdsCustomClusterConfiguration.BuilderImpl rdsCustomClusterConfiguration) {
            this.rdsCustomClusterConfiguration = rdsCustomClusterConfiguration != null ? rdsCustomClusterConfiguration.build() : null;
        }

        @Override
        public final Builder rdsCustomClusterConfiguration(RdsCustomClusterConfiguration rdsCustomClusterConfiguration) {
            this.rdsCustomClusterConfiguration = rdsCustomClusterConfiguration;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final String getGlobalClusterIdentifier() {
            return this.globalClusterIdentifier;
        }

        public final void setGlobalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
        }

        @Override
        public final Builder globalClusterIdentifier(String globalClusterIdentifier) {
            this.globalClusterIdentifier = globalClusterIdentifier;
            return this;
        }

        public final Boolean getEnableHttpEndpoint() {
            return this.enableHttpEndpoint;
        }

        public final void setEnableHttpEndpoint(Boolean enableHttpEndpoint) {
            this.enableHttpEndpoint = enableHttpEndpoint;
        }

        @Override
        public final Builder enableHttpEndpoint(Boolean enableHttpEndpoint) {
            this.enableHttpEndpoint = enableHttpEndpoint;
            return this;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return this.copyTagsToSnapshot;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final String getDomainIAMRoleName() {
            return this.domainIAMRoleName;
        }

        public final void setDomainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
        }

        @Override
        public final Builder domainIAMRoleName(String domainIAMRoleName) {
            this.domainIAMRoleName = domainIAMRoleName;
            return this;
        }

        public final Boolean getEnableGlobalWriteForwarding() {
            return this.enableGlobalWriteForwarding;
        }

        public final void setEnableGlobalWriteForwarding(Boolean enableGlobalWriteForwarding) {
            this.enableGlobalWriteForwarding = enableGlobalWriteForwarding;
        }

        @Override
        public final Builder enableGlobalWriteForwarding(Boolean enableGlobalWriteForwarding) {
            this.enableGlobalWriteForwarding = enableGlobalWriteForwarding;
            return this;
        }

        public final String getDbClusterInstanceClass() {
            return this.dbClusterInstanceClass;
        }

        public final void setDbClusterInstanceClass(String dbClusterInstanceClass) {
            this.dbClusterInstanceClass = dbClusterInstanceClass;
        }

        @Override
        public final Builder dbClusterInstanceClass(String dbClusterInstanceClass) {
            this.dbClusterInstanceClass = dbClusterInstanceClass;
            return this;
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final Integer getIops() {
            return this.iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final Integer getMonitoringInterval() {
            return this.monitoringInterval;
        }

        public final void setMonitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
        }

        @Override
        public final Builder monitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        public final String getMonitoringRoleArn() {
            return this.monitoringRoleArn;
        }

        public final void setMonitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
        }

        @Override
        public final Builder monitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
            return this;
        }

        public final Boolean getEnablePerformanceInsights() {
            return this.enablePerformanceInsights;
        }

        public final void setEnablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
        }

        @Override
        public final Builder enablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
            return this;
        }

        public final String getPerformanceInsightsKMSKeyId() {
            return this.performanceInsightsKMSKeyId;
        }

        public final void setPerformanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
        }

        @Override
        public final Builder performanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
            return this;
        }

        public final Integer getPerformanceInsightsRetentionPeriod() {
            return this.performanceInsightsRetentionPeriod;
        }

        public final void setPerformanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
        }

        @Override
        public final Builder performanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
            return this;
        }

        public final Boolean getEnableLimitlessDatabase() {
            return this.enableLimitlessDatabase;
        }

        public final void setEnableLimitlessDatabase(Boolean enableLimitlessDatabase) {
            this.enableLimitlessDatabase = enableLimitlessDatabase;
        }

        @Override
        public final Builder enableLimitlessDatabase(Boolean enableLimitlessDatabase) {
            this.enableLimitlessDatabase = enableLimitlessDatabase;
            return this;
        }

        public final ServerlessV2ScalingConfiguration.Builder getServerlessV2ScalingConfiguration() {
            return this.serverlessV2ScalingConfiguration != null ? this.serverlessV2ScalingConfiguration.toBuilder() : null;
        }

        public final void setServerlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration.BuilderImpl serverlessV2ScalingConfiguration) {
            this.serverlessV2ScalingConfiguration = serverlessV2ScalingConfiguration != null ? serverlessV2ScalingConfiguration.build() : null;
        }

        @Override
        public final Builder serverlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration serverlessV2ScalingConfiguration) {
            this.serverlessV2ScalingConfiguration = serverlessV2ScalingConfiguration;
            return this;
        }

        public final String getNetworkType() {
            return this.networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        public final String getDbSystemId() {
            return this.dbSystemId;
        }

        public final void setDbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
        }

        @Override
        public final Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        public final Boolean getManageMasterUserPassword() {
            return this.manageMasterUserPassword;
        }

        public final void setManageMasterUserPassword(Boolean manageMasterUserPassword) {
            this.manageMasterUserPassword = manageMasterUserPassword;
        }

        @Override
        public final Builder manageMasterUserPassword(Boolean manageMasterUserPassword) {
            this.manageMasterUserPassword = manageMasterUserPassword;
            return this;
        }

        public final String getMasterUserSecretKmsKeyId() {
            return this.masterUserSecretKmsKeyId;
        }

        public final void setMasterUserSecretKmsKeyId(String masterUserSecretKmsKeyId) {
            this.masterUserSecretKmsKeyId = masterUserSecretKmsKeyId;
        }

        @Override
        public final Builder masterUserSecretKmsKeyId(String masterUserSecretKmsKeyId) {
            this.masterUserSecretKmsKeyId = masterUserSecretKmsKeyId;
            return this;
        }

        public final Boolean getEnableLocalWriteForwarding() {
            return this.enableLocalWriteForwarding;
        }

        public final void setEnableLocalWriteForwarding(Boolean enableLocalWriteForwarding) {
            this.enableLocalWriteForwarding = enableLocalWriteForwarding;
        }

        @Override
        public final Builder enableLocalWriteForwarding(Boolean enableLocalWriteForwarding) {
            this.enableLocalWriteForwarding = enableLocalWriteForwarding;
            return this;
        }

        public final String getSourceRegion() {
            return this.sourceRegion;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDbClusterRequest build() {
            return new CreateDbClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDbClusterRequest> {
        public Builder availabilityZones(Collection<String> var1);

        public Builder availabilityZones(String ... var1);

        public Builder backupRetentionPeriod(Integer var1);

        public Builder characterSetName(String var1);

        public Builder databaseName(String var1);

        public Builder dbClusterIdentifier(String var1);

        public Builder dbClusterParameterGroupName(String var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder dbSubnetGroupName(String var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder port(Integer var1);

        public Builder masterUsername(String var1);

        public Builder masterUserPassword(String var1);

        public Builder optionGroupName(String var1);

        public Builder preferredBackupWindow(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder replicationSourceIdentifier(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder storageEncrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder preSignedUrl(String var1);

        public Builder enableIAMDatabaseAuthentication(Boolean var1);

        public Builder backtrackWindow(Long var1);

        public Builder enableCloudwatchLogsExports(Collection<String> var1);

        public Builder enableCloudwatchLogsExports(String ... var1);

        public Builder engineMode(String var1);

        public Builder scalingConfiguration(ScalingConfiguration var1);

        default public Builder scalingConfiguration(Consumer<ScalingConfiguration.Builder> scalingConfiguration) {
            return this.scalingConfiguration((ScalingConfiguration)((ScalingConfiguration.Builder)ScalingConfiguration.builder().applyMutation(scalingConfiguration)).build());
        }

        public Builder rdsCustomClusterConfiguration(RdsCustomClusterConfiguration var1);

        default public Builder rdsCustomClusterConfiguration(Consumer<RdsCustomClusterConfiguration.Builder> rdsCustomClusterConfiguration) {
            return this.rdsCustomClusterConfiguration((RdsCustomClusterConfiguration)((RdsCustomClusterConfiguration.Builder)RdsCustomClusterConfiguration.builder().applyMutation(rdsCustomClusterConfiguration)).build());
        }

        public Builder deletionProtection(Boolean var1);

        public Builder globalClusterIdentifier(String var1);

        public Builder enableHttpEndpoint(Boolean var1);

        public Builder copyTagsToSnapshot(Boolean var1);

        public Builder domain(String var1);

        public Builder domainIAMRoleName(String var1);

        public Builder enableGlobalWriteForwarding(Boolean var1);

        public Builder dbClusterInstanceClass(String var1);

        public Builder allocatedStorage(Integer var1);

        public Builder storageType(String var1);

        public Builder iops(Integer var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder monitoringInterval(Integer var1);

        public Builder monitoringRoleArn(String var1);

        public Builder enablePerformanceInsights(Boolean var1);

        public Builder performanceInsightsKMSKeyId(String var1);

        public Builder performanceInsightsRetentionPeriod(Integer var1);

        public Builder enableLimitlessDatabase(Boolean var1);

        public Builder serverlessV2ScalingConfiguration(ServerlessV2ScalingConfiguration var1);

        default public Builder serverlessV2ScalingConfiguration(Consumer<ServerlessV2ScalingConfiguration.Builder> serverlessV2ScalingConfiguration) {
            return this.serverlessV2ScalingConfiguration((ServerlessV2ScalingConfiguration)((ServerlessV2ScalingConfiguration.Builder)ServerlessV2ScalingConfiguration.builder().applyMutation(serverlessV2ScalingConfiguration)).build());
        }

        public Builder networkType(String var1);

        public Builder dbSystemId(String var1);

        public Builder manageMasterUserPassword(Boolean var1);

        public Builder masterUserSecretKmsKeyId(String var1);

        public Builder enableLocalWriteForwarding(Boolean var1);

        public Builder sourceRegion(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

