/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.rds.model.RdsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisableHttpEndpointResponse
extends RdsResponse
implements ToCopyableBuilder<Builder, DisableHttpEndpointResponse> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(DisableHttpEndpointResponse.getter(DisableHttpEndpointResponse::resourceArn)).setter(DisableHttpEndpointResponse.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<Boolean> HTTP_ENDPOINT_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("HttpEndpointEnabled").getter(DisableHttpEndpointResponse.getter(DisableHttpEndpointResponse::httpEndpointEnabled)).setter(DisableHttpEndpointResponse.setter(Builder::httpEndpointEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpEndpointEnabled").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD, HTTP_ENDPOINT_ENABLED_FIELD));
    private final String resourceArn;
    private final Boolean httpEndpointEnabled;

    private DisableHttpEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.httpEndpointEnabled = builder.httpEndpointEnabled;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final Boolean httpEndpointEnabled() {
        return this.httpEndpointEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpEndpointEnabled());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableHttpEndpointResponse)) {
            return false;
        }
        DisableHttpEndpointResponse other = (DisableHttpEndpointResponse)((Object)obj);
        return Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.httpEndpointEnabled(), other.httpEndpointEnabled());
    }

    public final String toString() {
        return ToString.builder((String)"DisableHttpEndpointResponse").add("ResourceArn", (Object)this.resourceArn()).add("HttpEndpointEnabled", (Object)this.httpEndpointEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "HttpEndpointEnabled": {
                return Optional.ofNullable(clazz.cast(this.httpEndpointEnabled()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DisableHttpEndpointResponse, T> g) {
        return obj -> g.apply((DisableHttpEndpointResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsResponse.BuilderImpl
    implements Builder {
        private String resourceArn;
        private Boolean httpEndpointEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableHttpEndpointResponse model) {
            super(model);
            this.resourceArn(model.resourceArn);
            this.httpEndpointEnabled(model.httpEndpointEnabled);
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final Boolean getHttpEndpointEnabled() {
            return this.httpEndpointEnabled;
        }

        public final void setHttpEndpointEnabled(Boolean httpEndpointEnabled) {
            this.httpEndpointEnabled = httpEndpointEnabled;
        }

        @Override
        public final Builder httpEndpointEnabled(Boolean httpEndpointEnabled) {
            this.httpEndpointEnabled = httpEndpointEnabled;
            return this;
        }

        @Override
        public DisableHttpEndpointResponse build() {
            return new DisableHttpEndpointResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RdsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisableHttpEndpointResponse> {
        public Builder resourceArn(String var1);

        public Builder httpEndpointEnabled(Boolean var1);
    }
}

